/*
 * Decompiled with CFR 0.152.
 */
package org.joone.engine;

import org.joone.engine.LearnableLayer;
import org.joone.engine.SimpleLayer;
import org.joone.exception.JooneRuntimeException;
import org.joone.log.ILogger;
import org.joone.log.LoggerFactory;

public class SineLayer
extends SimpleLayer
implements LearnableLayer {
    private static final long serialVersionUID = -2636086679111635756L;
    private static final ILogger log = LoggerFactory.getLogger(SineLayer.class);

    public SineLayer() {
        this.learnable = true;
    }

    public SineLayer(String aName) {
        this();
        this.setLayerName(aName);
    }

    protected void forward(double[] aPattern) throws JooneRuntimeException {
        int myRows = this.getRows();
        int i = 0;
        try {
            i = 0;
            while (i < myRows) {
                double myNeuronInput = aPattern[i] + this.getBias().value[i][0];
                this.outs[i] = Math.sin(myNeuronInput);
                ++i;
            }
        }
        catch (Exception aioobe) {
            String msg = "Exception thrown while processing the element " + i + " of the array. Value is : " + aPattern[i] + " Exception thrown is " + aioobe.getClass().getName() + ". Message is " + aioobe.getMessage();
            log.error(msg);
            throw new JooneRuntimeException(msg, aioobe);
        }
    }

    public void backward(double[] aPattern) throws JooneRuntimeException {
        super.backward(aPattern);
        int myRows = this.getRows();
        int i = 0;
        i = 0;
        while (i < myRows) {
            this.gradientOuts[i] = aPattern[i] * Math.cos(this.inps[i]);
            ++i;
        }
        this.myLearner.requestBiasUpdate(this.gradientOuts);
    }
}

