/*
 * Decompiled with CFR 0.152.
 */
package org.joone.engine;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.TreeSet;
import java.util.Vector;
import org.joone.engine.BasicLearner;
import org.joone.engine.Learner;
import org.joone.engine.LearnerFactory;
import org.joone.engine.NetStoppedEventNotifier;
import org.joone.engine.NeuralNetEvent;
import org.joone.engine.NeuralNetListener;
import org.joone.log.ILogger;
import org.joone.log.LoggerFactory;
import org.joone.net.NetCheck;

public class Monitor
implements Serializable {
    private static final long serialVersionUID = 2909501813894146845L;
    private int preLearning = 0;
    private boolean learning = false;
    private int currentCicle;
    private int run = 0;
    private int saveCurrentCicle;
    private int saveRun;
    private int patterns;
    private int validationPatterns;
    private int totCicles;
    private double learningRate;
    private double momentum;
    private double globalError;
    private int batchSize = 0;
    private boolean useRMSE = true;
    private LearnerFactory theLearnerFactory = null;
    private Monitor parent = null;
    private transient Vector internalListeners = new Vector();
    private transient Vector netListeners = new Vector();
    private transient boolean firstTime = true;
    private transient boolean exporting = false;
    private transient boolean validation = false;
    private transient boolean running = false;
    private transient boolean trainingDataForValidation = false;
    private static final ILogger log = LoggerFactory.getLogger(Monitor.class);
    private boolean supervisioned = false;
    private boolean singleThreadMode = true;
    public int learningMode = 0;
    private List learners;
    private Hashtable params;

    public Monitor() {
        this.internalListeners = new Vector();
    }

    public void addNeuralNetListener(NeuralNetListener l) {
        this.addNeuralNetListener(l, true);
    }

    public synchronized void addNeuralNetListener(NeuralNetListener l, boolean removable) {
        if (this.parent != null) {
            this.parent.addNeuralNetListener(l, removable);
        } else if (!this.getListeners().contains(l)) {
            this.netListeners.addElement(l);
            if (!removable && !this.getNoDetachListeners().contains(l)) {
                this.getNoDetachListeners().addElement(l);
            }
        }
    }

    private Vector getNoDetachListeners() {
        if (this.internalListeners == null) {
            this.internalListeners = new Vector();
        }
        return this.internalListeners;
    }

    private Vector getListeners() {
        if (this.netListeners == null) {
            this.netListeners = new Vector();
        }
        return this.netListeners;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireCicleTerminated() {
        if (this.parent != null) {
            this.parent.fireCicleTerminated();
        } else {
            Object[] list;
            int size = this.getListeners().size();
            if (size == 0) {
                return;
            }
            Monitor monitor = this;
            synchronized (monitor) {
                list = this.getListeners().toArray();
            }
            NeuralNetEvent event = new NeuralNetEvent(this);
            int i = 0;
            while (i < size) {
                NeuralNetListener listener = (NeuralNetListener)list[i];
                listener.cicleTerminated(event);
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireNetStarted() {
        if (this.parent != null) {
            this.parent.fireNetStarted();
        } else {
            Object[] list;
            int size = this.getListeners().size();
            if (size == 0) {
                return;
            }
            Monitor monitor = this;
            synchronized (monitor) {
                list = this.getListeners().toArray();
            }
            NeuralNetEvent event = new NeuralNetEvent(this);
            int i = 0;
            while (i < list.length) {
                NeuralNetListener listener = (NeuralNetListener)list[i];
                listener.netStarted(event);
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireNetStopped() {
        if (this.parent != null) {
            this.parent.fireNetStopped();
        } else {
            Object[] list;
            int size = this.getListeners().size();
            if (size == 0) {
                return;
            }
            Monitor monitor = this;
            synchronized (monitor) {
                list = this.getListeners().toArray();
            }
            NeuralNetEvent event = new NeuralNetEvent(this);
            int i = 0;
            while (i < list.length) {
                NeuralNetListener listener = (NeuralNetListener)list[i];
                listener.netStopped(event);
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireNetStoppedError(String errMsg) {
        if (this.parent != null) {
            this.parent.fireNetStoppedError(errMsg);
        } else {
            Object[] list;
            int size = this.getListeners().size();
            if (size == 0) {
                return;
            }
            Monitor monitor = this;
            synchronized (monitor) {
                list = this.getListeners().toArray();
            }
            NeuralNetEvent event = new NeuralNetEvent(this);
            int i = 0;
            while (i < list.length) {
                NeuralNetListener listener = (NeuralNetListener)list[i];
                listener.netStoppedError(event, errMsg);
                ++i;
            }
            if (this.running) {
                log.error("Neural net stopped due to the following error: " + errMsg);
                log.debug("\tepoch:" + this.currentCicle);
                log.debug("\tcycle:" + this.run);
                log.debug("\tlearning:" + this.isLearning());
                log.debug("\tvalidation:" + this.isValidation());
                log.debug("\ttrainingPatterns:" + this.getTrainingPatterns());
                log.debug("\tvalidationPatterns:" + this.getValidationPatterns());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireErrorChanged() {
        if (this.parent != null) {
            this.parent.fireErrorChanged();
        } else {
            Object[] list;
            int size = this.getListeners().size();
            if (size == 0) {
                return;
            }
            Monitor monitor = this;
            synchronized (monitor) {
                list = this.getListeners().toArray();
            }
            NeuralNetEvent event = new NeuralNetEvent(this);
            int i = 0;
            while (i < list.length) {
                NeuralNetListener listener = (NeuralNetListener)list[i];
                listener.errorChanged(event);
                ++i;
            }
        }
    }

    public synchronized int getCurrentCicle() {
        if (this.parent != null) {
            return this.parent.getCurrentCicle();
        }
        return this.currentCicle;
    }

    public double getGlobalError() {
        if (this.parent != null) {
            return this.parent.getGlobalError();
        }
        return this.globalError;
    }

    public synchronized double getLearningRate() {
        if (this.parent != null) {
            return this.parent.getLearningRate();
        }
        return this.learningRate;
    }

    public double getMomentum() {
        if (this.parent != null) {
            return this.parent.getMomentum();
        }
        return this.momentum;
    }

    public int getTrainingPatterns() {
        if (this.parent != null) {
            return this.parent.getTrainingPatterns();
        }
        return this.patterns;
    }

    public void setTrainingPatterns(int newPatterns) {
        if (this.parent != null) {
            this.parent.setTrainingPatterns(newPatterns);
        } else {
            this.patterns = newPatterns;
        }
    }

    public int getPreLearning() {
        if (this.parent != null) {
            return this.parent.getPreLearning();
        }
        return this.preLearning;
    }

    public synchronized int getStep() {
        if (this.parent != null) {
            return this.parent.getStep();
        }
        return this.run;
    }

    public int getTotCicles() {
        if (this.parent != null) {
            return this.parent.getTotCicles();
        }
        return this.totCicles;
    }

    public synchronized void Go() {
        if (this.parent != null) {
            this.parent.Go();
        } else {
            this.setSingleThreadMode(false);
            this.run = this.getNumOfPatterns();
            this.currentCicle = this.totCicles;
            this.firstTime = false;
            this.running = true;
            this.notifyAll();
        }
    }

    public boolean isLearning() {
        return this.learning;
    }

    public boolean isLearningCicle(int num) {
        if (this.parent != null) {
            boolean learn = this.parent.isLearningCicle(num);
            return learn & this.isLearning();
        }
        if (num > this.preLearning) {
            return this.isLearning();
        }
        return false;
    }

    public synchronized void resetCycle() {
        this.run = 0;
    }

    /*
     * Unable to fully structure code
     */
    public synchronized boolean nextStep() {
        if (this.parent == null) ** GOTO lbl29
        return this.parent.nextStep();
lbl-1000:
        // 1 sources

        {
            block10: {
                try {
                    if (this.firstTime) break block10;
                    if (this.currentCicle > 0) {
                        this.fireCicleTerminated();
                        --this.currentCicle;
                        if (this.currentCicle < 0) {
                            this.currentCicle = 0;
                        }
                        this.run = this.getNumOfPatterns();
                    }
                    if (this.currentCicle != 0) continue;
                    this.running = false;
                    if (!this.isSupervised() || !this.isLearning() && !this.isValidation()) {
                        new NetStoppedEventNotifier(this).start();
                    }
                    if (this.saveRun == 0) {
                        this.saveRun = this.getNumOfPatterns();
                        this.saveCurrentCicle = this.totCicles;
                    }
                    this.run = 0;
                    this.firstTime = true;
                    return false;
                }
                catch (InterruptedException e) {
                    this.run = 0;
                    this.firstTime = true;
                    return false;
                }
            }
            this.wait();
lbl29:
            // 3 sources

            ** while (this.run == 0)
        }
lbl30:
        // 1 sources

        if (this.run == this.getNumOfPatterns() && this.currentCicle == this.totCicles) {
            this.fireNetStarted();
        }
        if (this.run > 0) {
            --this.run;
        }
        return true;
    }

    protected Object readResolve() {
        this.firstTime = true;
        return this;
    }

    public synchronized void removeNeuralNetListener(NeuralNetListener l) {
        if (this.parent != null) {
            this.parent.removeNeuralNetListener(l);
        } else {
            this.getListeners().removeElement(l);
            this.getNoDetachListeners().removeElement(l);
        }
    }

    public synchronized void runAgain() {
        if (this.parent != null) {
            this.parent.runAgain();
        } else {
            this.run = this.getNumOfPatterns();
            this.currentCicle = this.saveCurrentCicle;
            this.firstTime = false;
            this.running = true;
            this.notifyAll();
        }
    }

    public void setCurrentCicle(int newCurrentCicle) {
        if (this.parent != null) {
            this.parent.setCurrentCicle(newCurrentCicle);
        } else {
            this.currentCicle = newCurrentCicle;
        }
    }

    public void setGlobalError(double newGlobalError) {
        if (this.parent != null) {
            this.parent.setGlobalError(newGlobalError);
        } else {
            this.globalError = newGlobalError;
            this.fireErrorChanged();
        }
    }

    public void setLearning(boolean newLearning) {
        this.learning = newLearning;
    }

    public void setLearningRate(double newLearningRate) {
        if (this.parent != null) {
            this.parent.setLearningRate(newLearningRate);
        } else {
            this.learningRate = newLearningRate;
        }
    }

    public void setMomentum(double newMomentum) {
        if (this.parent != null) {
            this.parent.setMomentum(newMomentum);
        } else {
            this.momentum = newMomentum;
        }
    }

    public void setPreLearning(int newPreLearning) {
        if (this.parent != null) {
            this.parent.setPreLearning(newPreLearning);
        } else {
            this.preLearning = newPreLearning;
        }
    }

    public void setTotCicles(int newTotCicles) {
        if (this.parent != null) {
            this.parent.setTotCicles(newTotCicles);
        } else {
            this.totCicles = newTotCicles;
        }
    }

    public synchronized void Stop() {
        if (this.parent != null) {
            this.parent.Stop();
        } else {
            this.saveRun = this.run;
            this.saveCurrentCicle = this.currentCicle;
            this.run = 0;
            this.currentCicle = 0;
        }
    }

    public boolean isExporting() {
        if (this.parent != null) {
            return this.parent.isExporting();
        }
        return this.exporting;
    }

    public void setExporting(boolean exporting) {
        if (this.parent != null) {
            this.parent.setExporting(exporting);
        } else {
            this.exporting = exporting;
        }
    }

    public int getRun() {
        return this.run;
    }

    public boolean isValidation() {
        if (this.parent != null) {
            return this.parent.isValidation();
        }
        return this.validation;
    }

    public void setValidation(boolean validation) {
        if (this.parent != null) {
            this.parent.setValidation(validation);
        } else {
            this.validation = validation;
        }
    }

    public boolean isTrainingDataForValidation() {
        if (this.parent != null) {
            return this.parent.isTrainingDataForValidation();
        }
        return this.trainingDataForValidation;
    }

    public void setTrainingDataForValidation(boolean aMode) {
        if (this.parent != null) {
            this.parent.setTrainingDataForValidation(aMode);
        } else {
            this.trainingDataForValidation = aMode;
        }
    }

    public void removeAllListeners() {
        if (this.parent != null) {
            this.parent.removeAllListeners();
        } else {
            this.netListeners = this.internalListeners != null ? (Vector)this.internalListeners.clone() : null;
        }
    }

    public Monitor getParent() {
        return this.parent;
    }

    public void setParent(Monitor parent) {
        this.parent = parent;
    }

    public int getValidationPatterns() {
        if (this.parent != null) {
            return this.parent.getValidationPatterns();
        }
        return this.validationPatterns;
    }

    public void setValidationPatterns(int newPatterns) {
        if (this.parent != null) {
            this.parent.setValidationPatterns(newPatterns);
        } else {
            this.validationPatterns = newPatterns;
        }
    }

    public int getNumOfPatterns() {
        if (this.parent != null) {
            return this.parent.getNumOfPatterns();
        }
        if (this.isValidation() && !this.isTrainingDataForValidation()) {
            return this.validationPatterns;
        }
        return this.patterns;
    }

    public TreeSet check() {
        TreeSet<NetCheck> checks = new TreeSet<NetCheck>();
        if (this.getLearningRate() <= 0.0 && this.isLearning()) {
            checks.add(new NetCheck(0, "Learning Rate must be greater than zero.", this));
        }
        if (this.isValidation() && this.getValidationPatterns() <= 0) {
            checks.add(new NetCheck(0, "Validation Patterns not set.", this));
        }
        if (this.isLearning() && this.getTrainingPatterns() <= 0) {
            checks.add(new NetCheck(0, "Training Patterns not set.", this));
        }
        if (!this.isValidation() && this.getTrainingPatterns() <= 0) {
            checks.add(new NetCheck(0, "Training Patterns not set.", this));
        }
        if (this.getTotCicles() <= 0) {
            checks.add(new NetCheck(0, "TotCicles (epochs) not set.", this));
        }
        return checks;
    }

    public boolean isSupervised() {
        if (this.parent != null) {
            return this.parent.isSupervised();
        }
        return this.supervisioned;
    }

    public void setSupervised(boolean supervised) {
        if (this.parent != null) {
            this.parent.setSupervised(supervised);
        } else {
            this.supervisioned = supervised;
        }
    }

    public int getBatchSize() {
        if (this.parent != null) {
            return this.getBatchSize();
        }
        return this.batchSize;
    }

    public void setBatchSize(int i) {
        if (this.parent != null) {
            this.parent.setBatchSize(i);
        } else {
            this.batchSize = i;
        }
    }

    public int getLearningMode() {
        return this.learningMode;
    }

    public void setLearningMode(int learningMode) {
        this.learningMode = learningMode;
    }

    public Learner getLearner(int index) {
        Learner myLearner = null;
        if (index < this.getLearners().size() && index >= 0) {
            String myClassName = (String)this.getLearners().get(index);
            try {
                Class<?> myClass = Class.forName(myClassName);
                myLearner = (Learner)myClass.newInstance();
            }
            catch (ClassNotFoundException cnfe) {
                log.error("Class " + myClassName + " not found");
            }
            catch (InstantiationException ie) {
                log.error("Error instantiating the class " + myClassName);
            }
            catch (IllegalAccessException iae) {
                log.error("Illegal access instantiating the class " + myClassName);
            }
        }
        if (myLearner == null) {
            myLearner = new BasicLearner();
        }
        myLearner.setMonitor(this);
        return myLearner;
    }

    public Learner getLearner() {
        Learner myLearner = null;
        if (this.theLearnerFactory != null) {
            myLearner = this.theLearnerFactory.getLearner(this);
            myLearner.setMonitor(this);
        }
        if (myLearner == null) {
            myLearner = this.getLearner(this.getLearningMode());
        }
        return myLearner;
    }

    protected List getLearners() {
        if (this.learners == null) {
            this.learners = new ArrayList(10);
        }
        return this.learners;
    }

    protected void setLearners(List learners) {
        this.learners = learners;
    }

    public void addLearner(int i, String learner) {
        if (!this.getLearners().contains(learner)) {
            this.getLearners().add(i, learner);
        }
    }

    public Object getParam(String key) {
        if (this.params == null) {
            return null;
        }
        return this.params.get(key);
    }

    public void setParam(String key, Object obj) {
        if (this.params == null) {
            this.params = new Hashtable();
        }
        if (this.params.containsKey(key)) {
            this.params.remove(key);
        }
        this.params.put(key, obj);
    }

    public String[] getKeys() {
        if (this.params == null) {
            return null;
        }
        String[] keys = new String[this.params.keySet().size()];
        Enumeration myEnum = this.params.keys();
        int i = 0;
        while (myEnum.hasMoreElements()) {
            keys[i] = (String)myEnum.nextElement();
            ++i;
        }
        return keys;
    }

    public void setUseRMSE(boolean aMode) {
        this.useRMSE = aMode;
    }

    public boolean isUseRMSE() {
        return this.useRMSE;
    }

    public void setLearnerFactory(LearnerFactory aFactory) {
        this.theLearnerFactory = aFactory;
    }

    public boolean isSingleThreadMode() {
        if (this.parent != null) {
            return this.parent.isSingleThreadMode();
        }
        return this.singleThreadMode;
    }

    public void setSingleThreadMode(boolean singleThreadMode) {
        if (this.parent != null) {
            this.parent.setSingleThreadMode(singleThreadMode);
        } else {
            this.singleThreadMode = singleThreadMode;
        }
    }
}

