/*
 * Decompiled with CFR 0.152.
 */
package org.joone.engine;

import java.util.ArrayList;
import java.util.Collection;
import org.joone.engine.SimpleLayer;
import org.joone.inspection.implementations.BiasInspection;
import org.joone.log.ILogger;
import org.joone.log.LoggerFactory;

public class LinearLayer
extends SimpleLayer {
    private double beta = 1.0;
    private static final ILogger log = LoggerFactory.getLogger(LinearLayer.class);
    private static final long serialVersionUID = 2243109263560495304L;

    public LinearLayer() {
    }

    public LinearLayer(String ElemName) {
        super(ElemName);
    }

    public void backward(double[] pattern) {
        int n = this.getRows();
        int x = 0;
        while (x < n) {
            this.gradientOuts[x] = pattern[x] * this.beta;
            ++x;
        }
    }

    public void forward(double[] pattern) {
        int n = this.getRows();
        int x = 0;
        while (x < n) {
            this.outs[x] = this.beta * pattern[x];
            ++x;
        }
    }

    public double getBeta() {
        return this.beta;
    }

    public void setBeta(double newBeta) {
        this.beta = newBeta;
    }

    public Collection Inspections() {
        ArrayList<BiasInspection> col = new ArrayList<BiasInspection>();
        col.add(new BiasInspection(null));
        return col;
    }
}

