/*
 * Decompiled with CFR 0.152.
 */
package org.joone.engine;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.TreeSet;
import org.joone.engine.FullSynapse;
import org.joone.engine.Learner;
import org.joone.engine.Monitor;
import org.joone.engine.NeuralNetEvent;
import org.joone.engine.NeuralNetListener;

public class KohonenSynapse
extends FullSynapse
implements NeuralNetListener {
    private static final long serialVersionUID = -4966435217407942471L;
    double currentLearningRate = 1.0;
    private double timeConstant = 200.0;
    private int orderingPhase = 1000;

    public KohonenSynapse() {
        this.learnable = false;
    }

    protected void backward(double[] pattern) {
        double dFalloff = 0.0;
        int num_outs = this.getOutputDimension();
        double[] o_pattern = this.b_pattern.getOutArray();
        int x = 0;
        while (x < num_outs) {
            dFalloff = o_pattern[x];
            this.adjustNodeWeight(x, this.currentLearningRate, dFalloff, this.inps);
            ++x;
        }
    }

    protected void forward(double[] pattern) {
        double temp = 0.0;
        double curDist = 0.0;
        int num_outs = this.getOutputDimension();
        int x = 0;
        while (x < num_outs) {
            curDist = 0.0;
            int inputs = 0;
            while (inputs < pattern.length) {
                temp = this.array.value[inputs][x] - pattern[inputs];
                temp *= temp;
                curDist += temp;
                ++inputs;
            }
            this.outs[x] = curDist;
            ++x;
        }
    }

    private void adjustNodeWeight(int curnode, double learningRate, double distanceFalloff, double[] pattern) {
        int output = curnode;
        int w = 0;
        while (w < this.getInputDimension()) {
            double wt = this.array.value[w][output];
            double vw = pattern[w];
            wt += distanceFalloff * learningRate * (vw - wt);
            this.array.value[w][output] = wt;
            ++w;
        }
    }

    public void setMonitor(Monitor newMonitor) {
        super.setMonitor(newMonitor);
        if (this.getMonitor() != null) {
            this.getMonitor().addNeuralNetListener(this, false);
        }
    }

    public void cicleTerminated(NeuralNetEvent e) {
        int currentCycle = this.getMonitor().getTotCicles() - this.getMonitor().getCurrentCicle();
        this.currentLearningRate = currentCycle < this.getOrderingPhase() ? this.getMonitor().getLearningRate() * Math.exp(-((double)currentCycle / this.getTimeConstant())) : 0.01;
    }

    public void errorChanged(NeuralNetEvent e) {
    }

    public void netStarted(NeuralNetEvent e) {
        this.currentLearningRate = this.getMonitor().getLearningRate();
    }

    public void netStopped(NeuralNetEvent e) {
    }

    public void netStoppedError(NeuralNetEvent e, String error) {
    }

    public TreeSet check() {
        TreeSet checks = super.check();
        return checks;
    }

    public int getOrderingPhase() {
        return this.orderingPhase;
    }

    public void setOrderingPhase(int orderingPhase) {
        this.orderingPhase = orderingPhase;
    }

    public double getTimeConstant() {
        return this.timeConstant;
    }

    public void setTimeConstant(double timeConstant) {
        this.timeConstant = timeConstant;
    }

    public Learner getLearner() {
        this.learnable = false;
        return super.getLearner();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.getMonitor() != null) {
            this.getMonitor().addNeuralNetListener(this, false);
        }
    }
}

