/*
 * Decompiled with CFR 0.152.
 */
package org.joone.engine;

import java.io.Serializable;
import org.joone.engine.Matrix;

public class FIRFilter
implements Serializable {
    protected int m_taps;
    protected double[] memory;
    protected double[] backmemory;
    protected double[] outs;
    protected double[] bouts;
    protected Matrix array;
    public double lrate;
    public double momentum;
    private static final long serialVersionUID = 2539307324689626619L;

    public FIRFilter(int taps) {
        this.outs = new double[taps];
        this.bouts = new double[taps];
        this.memory = new double[taps];
        this.backmemory = new double[taps];
        this.array = new Matrix(taps, 1);
        this.m_taps = taps - 1;
    }

    public void addNoise(double amplitude) {
        this.array.addNoise(amplitude);
    }

    protected double backDelay(double[] pattern) {
        int y = 0;
        while (y < this.m_taps) {
            this.backmemory[y] = this.backmemory[y + 1];
            int n = y;
            this.backmemory[n] = this.backmemory[n] + pattern[y];
            ++y;
        }
        this.backmemory[this.m_taps] = pattern[this.m_taps];
        return this.backmemory[0];
    }

    protected double[] backFilter(double input) {
        int x = 0;
        while (x <= this.m_taps) {
            this.bouts[x] = input * this.array.value[x][0];
            double dw = this.lrate * input * this.outs[x] + this.momentum * this.array.delta[x][0];
            double[] dArray = this.array.value[x];
            dArray[0] = dArray[0] + dw;
            this.array.delta[x][0] = dw;
            ++x;
        }
        return this.bouts;
    }

    public double backward(double input) {
        return this.backDelay(this.backFilter(input));
    }

    protected double[] Delay(double input) {
        int y = this.m_taps;
        while (y > 0) {
            this.memory[y] = this.memory[y - 1];
            this.outs[y] = this.memory[y];
            --y;
        }
        this.memory[0] = input;
        this.outs[0] = input;
        return this.outs;
    }

    protected double Filter(double[] pattern) {
        double s = 0.0;
        int x = 0;
        while (x <= this.m_taps) {
            s += pattern[x] * this.array.value[x][0];
            ++x;
        }
        return s;
    }

    public double forward(double input) {
        return this.Filter(this.Delay(input));
    }
}

