/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.font;

import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.freehep.graphics2d.font.CharTable;
import org.freehep.graphics2d.font.FontEncoder;
import org.freehep.graphics2d.font.Lookup;

public class FontUtilities {
    private static final Properties windowsFonts = new Properties();
    private static final CharTable[] STANDARD_CHAR_TABLES;
    private static final Font[] STANDARD_FONT;

    private FontUtilities() {
    }

    public static List getAllAvailableFonts() {
        return Arrays.asList(GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames());
    }

    public static String getWindowsFontName(String fontName) {
        return windowsFonts.getProperty(fontName, fontName);
    }

    public static String getEncodedString(String string, String tableName) {
        return FontEncoder.getEncodedString((String)string, (String)tableName);
    }

    public static String getEncodedString(String string, CharTable charTable) {
        return FontEncoder.getEncodedString((String)string, (CharTable)charTable);
    }

    public static void showString(Font font, String string, CharTable latinTable, ShowString device) throws IOException {
        if (latinTable == null) {
            throw new RuntimeException("FontUtilities.showString(...): latinTable cannot be 'null'");
        }
        FontUtilities.STANDARD_FONT[0] = font;
        FontUtilities.STANDARD_FONT[1] = new Font("Symbol", 0, font.getSize());
        FontUtilities.STANDARD_FONT[2] = new Font("ZapfDingbats", 0, font.getSize());
        FontUtilities.STANDARD_CHAR_TABLES[0] = latinTable;
        char[] chars = string.toCharArray();
        String out = "";
        int lastTable = 0;
        for (int i = 0; i < chars.length; ++i) {
            int table = lastTable;
            char encoding = (char)STANDARD_CHAR_TABLES[table].toEncoding(chars[i]);
            if (encoding == '\u0000') {
                table = -1;
                do {
                    if (++table == lastTable) continue;
                    encoding = (char)STANDARD_CHAR_TABLES[table].toEncoding(chars[i]);
                } while (encoding == '\u0000' && table < STANDARD_CHAR_TABLES.length - 1);
            }
            if (encoding == '\u0000') {
                table = lastTable;
            }
            if (table != lastTable && !out.equals("")) {
                device.showString(STANDARD_FONT[lastTable], out);
                out = "";
            }
            out = out + encoding;
            lastTable = table;
        }
        device.showString(STANDARD_FONT[lastTable], out);
    }

    static {
        String arial = "Arial";
        windowsFonts.setProperty("Dialog", arial);
        windowsFonts.setProperty("DialogInput", "Courier New");
        windowsFonts.setProperty("Serif", "Times New Roman");
        windowsFonts.setProperty("SansSerif", arial);
        windowsFonts.setProperty("Monospaced", "Courier New");
        windowsFonts.setProperty("Courier", "Courier New");
        windowsFonts.setProperty("Helvetica", arial);
        windowsFonts.setProperty("Times-Roman", "Times New Roman");
        windowsFonts.setProperty("TimesRoman", "Times New Roman");
        windowsFonts.setProperty("Times", "Times New Roman");
        windowsFonts.setProperty("Symbol", "Arial Unicode MS");
        windowsFonts.setProperty("ZapfDingbats", "Arial Unicode MS");
        STANDARD_CHAR_TABLES = new CharTable[]{null, Lookup.getInstance().getTable("Symbol"), Lookup.getInstance().getTable("Zapfdingbats")};
        STANDARD_FONT = new Font[]{null, new Font("Symbol", 0, 10), new Font("ZapfDingbats", 0, 10)};
    }

    public static interface ShowString {
        public void showString(Font var1, String var2) throws IOException;
    }
}

