/*
 * Decompiled with CFR 0.152.
 */
package com.ingres.gcf.jdbc;

import com.ingres.gcf.jdbc.DrvClob;
import com.ingres.gcf.jdbc.DrvConn;
import com.ingres.gcf.jdbc.JdbcClob;
import com.ingres.gcf.jdbc.JdbcNlob;
import com.ingres.gcf.util.SqlDates;
import com.ingres.gcf.util.SqlExFactory;
import com.ingres.gcf.util.SqlLoc;
import com.ingres.gcf.util.SqlLongChar;
import com.ingres.gcf.util.SqlStream;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.TimeZone;

class SqlCLoc
extends SqlLoc {
    private DrvConn conn = null;

    public SqlCLoc(DrvConn drvConn) throws SQLException {
        this.conn = drvConn;
    }

    public void set(SqlCLoc sqlCLoc) {
        if (sqlCLoc == null) {
            this.setNull();
        } else {
            this.conn = sqlCLoc.conn;
            this.set((SqlLoc)sqlCLoc);
        }
    }

    @Override
    public void setClob(Clob clob) throws SQLException {
        if (clob == null) {
            this.setNull();
        } else if (clob instanceof DrvClob) {
            this.set(((DrvClob)clob).getLocator());
        } else {
            throw SqlExFactory.get(ERR_GC401A_CONVERSION_ERR);
        }
    }

    @Override
    public Clob getClob() throws SQLException {
        return new JdbcClob(new DrvClob(this.conn, this.value), this.conn.cnf_lob_segSize, this.conn.trace);
    }

    @Override
    public NClob getNlob() throws SQLException {
        return new JdbcNlob(new DrvClob(this.conn, this.value), this.conn.cnf_lob_segSize, this.conn.trace);
    }

    @Override
    public boolean getBoolean() throws SQLException {
        String string = this.getString().trim();
        return string.equals("1") ? true : Boolean.valueOf(string);
    }

    @Override
    public byte getByte() throws SQLException {
        byte by;
        try {
            by = Byte.parseByte(this.getString().trim());
        }
        catch (NumberFormatException numberFormatException) {
            throw SqlExFactory.get(ERR_GC401A_CONVERSION_ERR);
        }
        return by;
    }

    @Override
    public short getShort() throws SQLException {
        short s;
        try {
            s = Short.parseShort(this.getString().trim());
        }
        catch (NumberFormatException numberFormatException) {
            throw SqlExFactory.get(ERR_GC401A_CONVERSION_ERR);
        }
        return s;
    }

    @Override
    public int getInt() throws SQLException {
        int n;
        try {
            n = Integer.parseInt(this.getString().trim());
        }
        catch (NumberFormatException numberFormatException) {
            throw SqlExFactory.get(ERR_GC401A_CONVERSION_ERR);
        }
        return n;
    }

    @Override
    public long getLong() throws SQLException {
        long l;
        try {
            l = Long.parseLong(this.getString().trim());
        }
        catch (NumberFormatException numberFormatException) {
            throw SqlExFactory.get(ERR_GC401A_CONVERSION_ERR);
        }
        return l;
    }

    @Override
    public float getFloat() throws SQLException {
        float f;
        try {
            f = Float.parseFloat(this.getString().trim());
        }
        catch (NumberFormatException numberFormatException) {
            throw SqlExFactory.get(ERR_GC401A_CONVERSION_ERR);
        }
        return f;
    }

    @Override
    public double getDouble() throws SQLException {
        double d;
        try {
            d = Double.parseDouble(this.getString().trim());
        }
        catch (NumberFormatException numberFormatException) {
            throw SqlExFactory.get(ERR_GC401A_CONVERSION_ERR);
        }
        return d;
    }

    @Override
    public BigDecimal getBigDecimal() throws SQLException {
        BigDecimal bigDecimal;
        try {
            bigDecimal = new BigDecimal(this.getString().trim());
        }
        catch (NumberFormatException numberFormatException) {
            throw SqlExFactory.get(ERR_GC401A_CONVERSION_ERR);
        }
        return bigDecimal;
    }

    @Override
    public String getString() throws SQLException {
        return SqlLongChar.strm2str(this.getCharacterStream());
    }

    @Override
    public String getString(int n) throws SQLException {
        return SqlLongChar.strm2str(this.getCharacterStream(), n);
    }

    @Override
    public Date getDate(TimeZone timeZone) throws SQLException {
        SqlDates sqlDates = SqlDates.getDefaultInstance();
        String string = this.getString().trim();
        return timeZone == null ? sqlDates.parseDate(string, false) : sqlDates.parseDate(string, timeZone);
    }

    @Override
    public Time getTime(TimeZone timeZone) throws SQLException {
        SqlDates sqlDates = SqlDates.getDefaultInstance();
        String string = this.getString().trim();
        return timeZone == null ? sqlDates.parseTime(string, false) : sqlDates.parseTime(string, timeZone);
    }

    @Override
    public Timestamp getTimestamp(TimeZone timeZone) throws SQLException {
        SqlDates sqlDates = SqlDates.getDefaultInstance();
        String string = this.getString().trim();
        return timeZone == null ? sqlDates.parseTimestamp(string, false) : sqlDates.parseTimestamp(string, timeZone);
    }

    @Override
    public InputStream getAsciiStream() throws SQLException {
        DrvClob drvClob = new DrvClob(this.conn, this.value);
        InputStream inputStream = drvClob.getAsciiStream();
        return inputStream;
    }

    @Override
    public InputStream getUnicodeStream() throws SQLException {
        return SqlStream.getUnicodeIS(this.getCharacterStream());
    }

    @Override
    public Reader getCharacterStream() throws SQLException {
        DrvClob drvClob = new DrvClob(this.conn, this.value);
        Reader reader = drvClob.getCharacterStream();
        return reader;
    }

    @Override
    public Object getObject() throws SQLException {
        return this.getClob();
    }
}

