/*
 * Decompiled with CFR 0.152.
 */
package com.ingres.gcf.jdbc;

import com.ingres.gcf.jdbc.DrvClob;
import com.ingres.gcf.jdbc.DrvConn;
import com.ingres.gcf.jdbc.DrvConst;
import com.ingres.gcf.jdbc.DrvLOB;
import com.ingres.gcf.jdbc.DrvNlob;
import com.ingres.gcf.jdbc.DrvTrace;
import com.ingres.gcf.util.BufferedClob;
import com.ingres.gcf.util.BufferedNlob;
import com.ingres.gcf.util.GcfErr;
import com.ingres.gcf.util.SqlExFactory;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.sql.Clob;
import java.sql.SQLException;

public class JdbcClob
implements Clob,
DrvConst,
GcfErr {
    private Clob clob;
    private int segSize;
    private DrvTrace trace;
    private String title;

    protected JdbcClob(Clob clob, int n, DrvTrace drvTrace, String string) {
        this.clob = clob;
        this.segSize = n;
        this.trace = drvTrace;
        this.title = drvTrace.getTraceName() + "-" + string;
    }

    JdbcClob(DrvTrace drvTrace) {
        this(8192, drvTrace);
    }

    JdbcClob(int n, DrvTrace drvTrace) {
        this(new BufferedClob(n), n, drvTrace, "Clob[cache]");
    }

    JdbcClob(DrvClob drvClob, DrvTrace drvTrace) {
        this(drvClob, 8192, drvTrace);
    }

    JdbcClob(DrvNlob drvNlob, DrvTrace drvTrace) {
        this(drvNlob, 8192, drvTrace);
    }

    JdbcClob(DrvClob drvClob, int n, DrvTrace drvTrace) {
        this(drvClob, n, drvTrace, "Clob[LOC:" + drvClob.toString() + "]");
    }

    JdbcClob(DrvNlob drvNlob, int n, DrvTrace drvTrace) {
        this(drvNlob, n, drvTrace, "Nlob[LOC:" + drvNlob.toString() + "]");
    }

    public String toString() {
        return this.title;
    }

    boolean isValidLocator(DrvConn drvConn) {
        return this.clob instanceof DrvLOB ? ((DrvLOB)((Object)this.clob)).hasSameDomain(drvConn) : false;
    }

    DrvLOB getLOB() {
        return this.clob instanceof DrvLOB ? (DrvLOB)((Object)this.clob) : null;
    }

    @Override
    public long length() throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".length()");
        }
        this.isValid();
        long l = this.clob.length();
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".length: " + l);
        }
        return l;
    }

    @Override
    public InputStream getAsciiStream() throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getAsciiStream()");
        }
        this.isValid();
        return this.clob.getAsciiStream();
    }

    @Override
    public Reader getCharacterStream() throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getCharacterStream()");
        }
        this.isValid();
        return this.clob.getCharacterStream();
    }

    @Override
    public String getSubString(long l, int n) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getSubString(" + l + "," + n + ")");
        }
        this.isValid();
        String string = this.clob.getSubString(l, n);
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getSubString:" + string.length() + " characters");
        }
        return string;
    }

    @Override
    public long position(String string, long l) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".position(" + l + ")");
        }
        this.isValid();
        long l2 = this.clob.position(string, l);
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".position: " + l2);
        }
        return l2;
    }

    @Override
    public long position(Clob clob, long l) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".position(" + clob + "," + l + ")");
        }
        if (clob == null) {
            throw new NullPointerException();
        }
        if (clob instanceof JdbcClob) {
            clob = ((JdbcClob)clob).clob;
        }
        this.isValid();
        long l2 = this.clob.position(clob, l);
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".position: " + l2);
        }
        return l2;
    }

    @Override
    public int setString(long l, String string) throws SQLException {
        return this.setString(l, string, 0, string.length());
    }

    @Override
    public int setString(long l, String string, int n, int n2) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".setString(" + l + "," + n2 + ")");
        }
        this.isValid();
        this.prepareToUpdate();
        int n3 = this.clob.setString(l, string, n, n2);
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".setString: " + n3);
        }
        return n3;
    }

    @Override
    public OutputStream setAsciiStream(long l) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".setAsciiStream(" + l + ")");
        }
        this.isValid();
        this.prepareToUpdate();
        return this.clob.setAsciiStream(l);
    }

    @Override
    public Writer setCharacterStream(long l) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".setCharacterStream(" + l + ")");
        }
        this.isValid();
        this.prepareToUpdate();
        return this.clob.setCharacterStream(l);
    }

    @Override
    public void truncate(long l) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".truncate(" + l + ")");
        }
        this.isValid();
        this.prepareToUpdate();
        this.clob.truncate(l);
    }

    private void prepareToUpdate() throws SQLException {
        if (this.clob instanceof DrvClob) {
            this.clob = new BufferedClob(this.segSize, ((DrvClob)this.clob).get());
            this.title = this.trace.getTraceName() + "-Clob[cache]";
        } else if (this.clob instanceof DrvNlob) {
            this.clob = new BufferedNlob(this.segSize, ((DrvNlob)this.clob).get());
            this.title = this.trace.getTraceName() + "-Nlob[cache]";
        }
    }

    @Override
    public Reader getCharacterStream(long l, long l2) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getCharacterStream( " + l + "," + l2 + ")");
        }
        this.isValid();
        return this.clob.getCharacterStream(l, l2);
    }

    @Override
    public void free() throws SQLException {
        if (this.clob != null) {
            this.clob.free();
            this.clob = null;
        }
    }

    private void isValid() throws SQLException {
        if (this.clob == null) {
            throw SqlExFactory.get(ERR_GC4022_LOB_FREED);
        }
    }
}

