/*
 * Decompiled with CFR 0.152.
 */
package com.ingres.gcf.jdbc;

import com.ingres.gcf.dam.MsgConn;
import com.ingres.gcf.dam.MsgConst;
import com.ingres.gcf.jdbc.DrvConst;
import com.ingres.gcf.jdbc.DrvObj;
import com.ingres.gcf.jdbc.DrvPrep;
import com.ingres.gcf.jdbc.DrvTrace;
import com.ingres.gcf.jdbc.JdbcConn;
import com.ingres.gcf.jdbc.JdbcRSMD;
import com.ingres.gcf.jdbc.JdbcStmt;
import com.ingres.gcf.util.Config;
import com.ingres.gcf.util.ConfigKey;
import com.ingres.gcf.util.DbmsConst;
import com.ingres.gcf.util.GcfErr;
import com.ingres.gcf.util.SqlDates;
import com.ingres.gcf.util.SqlExFactory;
import com.ingres.gcf.util.TraceLog;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Random;
import java.util.Stack;

class DrvConn
implements DrvConst,
MsgConst,
DbmsConst,
GcfErr {
    public MsgConn msg = null;
    public JdbcConn jdbc = null;
    public Config config = null;
    public DrvTrace trace = null;
    public TraceLog dbms_log = null;
    public DbCaps dbCaps = null;
    public DbInfo dbInfo = null;
    public String driverName = "Ingres JDBC Driver";
    public String protocol = "?";
    public static final int CNF_LOCATORS = 1;
    public static final int CNF_LOC_AUTO = 2;
    public static final int CNF_LOC_LOOP = 4;
    public static final int CNF_LOB_CACHE = 8;
    public static final int CNF_CURS_SCROLL = 16;
    public static final int CNF_BATCH = 32;
    public int cnf_flags = 49;
    public int cnf_lob_segSize = 8192;
    public String cnf_empty_date = "";
    public String host = null;
    public String database = null;
    public byte msg_protocol_level = 1;
    public byte db_protocol_level = 1;
    public byte[] session_mask = new byte[8];
    public boolean is_dtmc = false;
    public boolean is_ingres = true;
    public int sqlLevel = 0;
    public boolean osql_dates = false;
    public boolean is_gmt = true;
    public boolean ucs2_supported = false;
    public boolean select_loops = false;
    public int cursor_mode = 0;
    public boolean snd_ing_dte = false;
    public boolean autoCommit = true;
    public boolean readOnly = false;
    public int max_char_len = 2000;
    public int max_vchr_len = 2000;
    public int max_byte_len = 2000;
    public int max_vbyt_len = 2000;
    public int max_nchr_len = 1000;
    public int max_nvch_len = 1000;
    public int max_dec_prec = 31;
    public SqlDates dt_frmt = SqlDates.getInstance();
    public SqlDates dt_lit = SqlDates.getLiteralInstance();
    private static final String STMT_PREFIX = "JDBC_STMT_";
    private Hashtable prepStmts = new Hashtable();
    private Hashtable activeStmts = new Hashtable();
    private Stack stmtNames = new Stack();
    private int tran_id = 0;
    private int obj_id = 0;
    private String tr_id = "Conn";

    public DrvConn(String string, Config config, DrvTrace drvTrace, boolean bl) throws SQLException {
        this.host = string;
        this.trace = drvTrace;
        this.config = config;
        this.init();
        this.connect(bl);
    }

    private void init() throws SQLException {
        new Random(System.currentTimeMillis()).nextBytes(this.session_mask);
        this.dbms_log = TraceLog.getTraceLog(this.config.getKey("dbms"), new ConfigKey("dbms", this.config));
        String string = this.config.get("lob.cache.enabled");
        if (string != null) {
            string = string.trim();
            if (this.trace.enabled(3)) {
                this.trace.write(this.tr_id + ": " + "lob.cache.enabled" + "=" + string);
            }
            if (string.equalsIgnoreCase("true")) {
                this.cnf_flags |= 8;
            } else if (string.equalsIgnoreCase("false")) {
                this.cnf_flags &= 0xFFFFFFF7;
            } else {
                throw SqlExFactory.get(ERR_GC4010_PARAM_VALUE);
            }
        }
        if ((string = this.config.get("lob.cache.segment_size")) != null) {
            int n = 8192;
            string = string.trim();
            if (this.trace.enabled(3)) {
                this.trace.write(this.tr_id + ": " + "lob.cache.segment_size" + "=" + string);
            }
            try {
                n = Integer.parseInt(string);
                if (n > 0) {
                    this.cnf_lob_segSize = n;
                }
            }
            catch (Exception exception) {
                throw SqlExFactory.get(ERR_GC4010_PARAM_VALUE);
            }
        }
        if ((string = this.config.get("lob.locators.enabled")) != null) {
            string = string.trim();
            if (this.trace.enabled(3)) {
                this.trace.write(this.tr_id + ": " + "lob.locators.enabled" + "=" + string);
            }
            if (string.equalsIgnoreCase("true")) {
                this.cnf_flags |= 1;
            } else if (string.equalsIgnoreCase("false")) {
                this.cnf_flags &= 0xFFFFFFFE;
            } else {
                throw SqlExFactory.get(ERR_GC4010_PARAM_VALUE);
            }
        }
        if ((this.cnf_flags & 1) == 0) {
            this.cnf_flags &= 0xFFFFFFF9;
        } else {
            string = this.config.get("lob.locators.autocommit.enabled");
            if (string != null) {
                string = string.trim();
                if (this.trace.enabled(3)) {
                    this.trace.write(this.tr_id + ": " + "lob.locators.autocommit.enabled" + "=" + string);
                }
                if (string.equalsIgnoreCase("true")) {
                    this.cnf_flags |= 2;
                } else if (string.equalsIgnoreCase("false")) {
                    this.cnf_flags &= 0xFFFFFFFD;
                } else {
                    throw SqlExFactory.get(ERR_GC4010_PARAM_VALUE);
                }
            }
            if ((string = this.config.get("lob.locators.select_loop.enabled")) != null) {
                string = string.trim();
                if (this.trace.enabled(3)) {
                    this.trace.write(this.tr_id + ": " + "lob.locators.select_loop.enabled" + "=" + string);
                }
                if (string.equalsIgnoreCase("true")) {
                    this.cnf_flags |= 4;
                } else if (string.equalsIgnoreCase("false")) {
                    this.cnf_flags &= 0xFFFFFFFB;
                } else {
                    throw SqlExFactory.get(ERR_GC4010_PARAM_VALUE);
                }
            }
        }
        string = this.config.get("date.empty");
        if (string != null) {
            string = string.trim();
            if (this.trace.enabled(3)) {
                this.trace.write(this.tr_id + ": " + "date.empty" + "=" + string);
            }
            this.cnf_empty_date = string.length() == 0 || string.equalsIgnoreCase("empty") ? "" : (string.equalsIgnoreCase("default") ? "" : (string.equalsIgnoreCase("null") ? null : string));
        }
        if ((string = this.config.get("scroll.enabled")) != null) {
            string = string.trim();
            if (this.trace.enabled(3)) {
                this.trace.write(this.tr_id + ": " + "scroll.enabled" + "=" + string);
            }
            if (string.equalsIgnoreCase("true")) {
                this.cnf_flags |= 0x10;
            } else if (string.equalsIgnoreCase("false")) {
                this.cnf_flags &= 0xFFFFFFEF;
            } else {
                throw SqlExFactory.get(ERR_GC4010_PARAM_VALUE);
            }
        }
        if ((string = this.config.get("batch.enabled")) != null) {
            string = string.trim();
            if (this.trace.enabled(3)) {
                this.trace.write(this.tr_id + ": " + "batch.enabled" + "=" + string);
            }
            if (string.equalsIgnoreCase("true")) {
                this.cnf_flags |= 0x20;
            } else if (string.equalsIgnoreCase("false")) {
                this.cnf_flags &= 0xFFFFFFDF;
            } else {
                throw SqlExFactory.get(ERR_GC4010_PARAM_VALUE);
            }
        }
    }

    private void connect(boolean bl) throws SQLException {
        int n;
        byte[][] byArrayArray = new byte[1][];
        boolean bl2 = false;
        int n2 = 3;
        n2 += 2 + this.session_mask.length;
        if (bl) {
            n2 += 2;
        }
        byArrayArray[0] = new byte[n2];
        n2 = 0;
        byArrayArray[0][n2++] = 1;
        byArrayArray[0][n2++] = 1;
        byArrayArray[0][n2++] = 7;
        byArrayArray[0][n2++] = 3;
        byArrayArray[0][n2++] = (byte)this.session_mask.length;
        for (n = 0; n < this.session_mask.length; ++n) {
            byArrayArray[0][n2++] = this.session_mask[n];
        }
        if (bl) {
            byArrayArray[0][n2++] = 2;
            byArrayArray[0][n2++] = 0;
        }
        if (this.trace.enabled(2)) {
            this.trace.write(this.tr_id + ": Connecting to server: " + this.host);
        }
        this.msg = new MsgConn(this.host, byArrayArray, this.trace.getTraceLog());
        this.tr_id = this.tr_id + "[" + this.msg.connID() + "]";
        try {
            n = 0;
            block8: while (n < byArrayArray[0].length - 1) {
                byte by = byArrayArray[0][n++];
                byte by2 = byArrayArray[0][n++];
                switch (by) {
                    case 1: {
                        if (by2 != 1 || n >= byArrayArray[0].length) {
                            if (this.trace.enabled(1)) {
                                this.trace.write(this.tr_id + ": Invalid PROTO param length: " + by2 + "," + (byArrayArray[0].length - n));
                            }
                            throw SqlExFactory.get(ERR_GC4002_PROTOCOL_ERR);
                        }
                        this.msg_protocol_level = byArrayArray[0][n++];
                        this.msg.setProtocolLevel(this.msg_protocol_level);
                        continue block8;
                    }
                    case 2: {
                        if (by2 != 0) {
                            if (this.trace.enabled(1)) {
                                this.trace.write(this.tr_id + ": Invalid DTMC param length: " + by2);
                            }
                            throw SqlExFactory.get(ERR_GC4002_PROTOCOL_ERR);
                        }
                        this.is_dtmc = true;
                        continue block8;
                    }
                    case 3: {
                        if (by2 != this.session_mask.length) {
                            if (this.trace.enabled(1)) {
                                this.trace.write(this.tr_id + ": Invalid mask param length: " + by2);
                            }
                            throw SqlExFactory.get(ERR_GC4002_PROTOCOL_ERR);
                        }
                        int n3 = 0;
                        while (n3 < this.session_mask.length) {
                            int n4 = n3++;
                            this.session_mask[n4] = (byte)(this.session_mask[n4] ^ byArrayArray[0][n]);
                            ++n;
                        }
                        bl2 = true;
                        continue block8;
                    }
                }
                if (this.trace.enabled(1)) {
                    this.trace.write(this.tr_id + ": Invalid param ID: " + by);
                }
                throw SqlExFactory.get(ERR_GC4002_PROTOCOL_ERR);
            }
            if (this.msg_protocol_level < 1 || this.msg_protocol_level > 7) {
                if (this.trace.enabled(1)) {
                    this.trace.write(this.tr_id + ": Invalid MSG protocol: " + this.msg_protocol_level);
                }
                throw SqlExFactory.get(ERR_GC4002_PROTOCOL_ERR);
            }
            if (!bl2) {
                this.session_mask = null;
            }
            if (this.is_dtmc) {
                if (!bl) {
                    if (this.trace.enabled(1)) {
                        this.trace.write(this.tr_id + ": DTM connection not requested!");
                    }
                    throw SqlExFactory.get(ERR_GC4001_CONNECT_ERR);
                }
                if (this.msg_protocol_level < 2) {
                    if (this.trace.enabled(1)) {
                        this.trace.write(this.tr_id + ": 2PC not supported");
                    }
                    throw SqlExFactory.get(ERR_GC4019_UNSUPPORTED);
                }
                this.autoCommit = false;
            } else if (bl) {
                if (this.trace.enabled(1)) {
                    this.trace.write(this.tr_id + ": Could not establish DTM connection!");
                }
                throw SqlExFactory.get(ERR_GC4019_UNSUPPORTED);
            }
        }
        catch (SQLException sQLException) {
            this.msg.close();
            throw sQLException;
        }
        if (this.msg_protocol_level < 6) {
            this.cnf_flags &= 0xFFFFFFF8;
        }
        if (this.trace.enabled(2)) {
            this.trace.write(this.tr_id + ": connected to server");
            if (this.trace.enabled(3)) {
                this.trace.write(this.tr_id + ": messaging protocol initialized:");
                this.trace.write("    MSG protocol: " + this.msg_protocol_level);
                if (this.is_dtmc) {
                    this.trace.write("    DTM Connection");
                }
                if (this.session_mask != null) {
                    this.trace.write("    Session mask: " + this.session_mask.length + " bytes");
                }
            }
        }
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    public void close() {
        if (!this.msg.isClosed()) {
            if (this.trace.enabled(2)) {
                this.trace.write(this.tr_id + ": Disconnecting from server ");
            }
            this.msg.close();
            if (this.trace.enabled(2)) {
                this.trace.write(this.tr_id + ": disconnected from server");
            }
        }
    }

    protected boolean timeValuesInGMT() {
        return !this.osql_dates || !this.is_gmt;
    }

    protected boolean timeLiteralsInGMT() {
        return !this.osql_dates && this.is_gmt;
    }

    public synchronized void endXact() {
        if (this.trace.enabled(4)) {
            this.trace.write(this.tr_id + ": end of transaction");
        }
        ++this.tran_id;
        this.obj_id = 0;
        this.clearPrepStmts();
    }

    public int getXactID() {
        return this.tran_id;
    }

    public synchronized String getUniqueID(String string) {
        return string + Integer.toHexString(this.tran_id) + "_" + Integer.toHexString(this.obj_id++);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DrvPrep createPrepStmt(String string) throws SQLException {
        DrvPrep drvPrep;
        Hashtable hashtable = this.prepStmts;
        synchronized (hashtable) {
            drvPrep = (DrvPrep)this.prepStmts.get(string);
            if (drvPrep != null) {
                drvPrep.prepare();
            } else {
                drvPrep = (DrvPrep)this.activeStmts.get(string);
                if (drvPrep == null) {
                    String string2 = null;
                    if (this.stmtNames.empty()) {
                        string2 = this.getUniqueID(STMT_PREFIX);
                    } else {
                        try {
                            string2 = (String)this.stmtNames.pop();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    drvPrep = new DrvPrep(this, string, string2);
                    this.activeStmts.put(string, drvPrep);
                }
                drvPrep.prepare();
                this.prepStmts.put(string, drvPrep);
            }
            drvPrep.attach();
        }
        return drvPrep;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DrvPrep findPrepStmt(String string) throws SQLException {
        DrvPrep drvPrep;
        Hashtable hashtable = this.prepStmts;
        synchronized (hashtable) {
            drvPrep = (DrvPrep)this.prepStmts.get(string);
            if (drvPrep == null) {
                drvPrep = (DrvPrep)this.activeStmts.get(string);
                if (drvPrep == null) {
                    throw SqlExFactory.get(ERR_GC4019_UNSUPPORTED);
                }
                drvPrep.prepare();
                this.prepStmts.put(string, drvPrep);
            }
        }
        return drvPrep;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dropPrepStmt(String string) throws SQLException {
        Hashtable hashtable = this.prepStmts;
        synchronized (hashtable) {
            DrvPrep drvPrep = (DrvPrep)this.activeStmts.get(string);
            if (drvPrep == null) {
                throw SqlExFactory.get(ERR_GC4019_UNSUPPORTED);
            }
            drvPrep.detach();
            if (!drvPrep.isActive()) {
                this.prepStmts.remove(string);
                this.activeStmts.remove(string);
                this.stmtNames.push(drvPrep.getStmtName());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearPrepStmts() {
        Hashtable hashtable = this.prepStmts;
        synchronized (hashtable) {
            this.prepStmts.clear();
            this.stmtNames.clear();
        }
    }

    public void loadDbCaps() throws SQLException {
        this.dbInfo = new DbInfo(this);
        this.dbCaps = new DbCaps(this);
        this.dbCaps.loadDbCaps();
        String string = this.dbCaps.getDbCap(this.msg_protocol_level < 3 ? "JDBC_CONNECT_LEVEL" : "DBMS_CONNECT_LEVEL");
        if (string != null) {
            try {
                this.db_protocol_level = Byte.parseByte(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.db_protocol_level < 5) {
            this.cnf_flags &= 0xFFFFFFF8;
        }
        if ((string = this.dbCaps.getDbCap("DBMS_TYPE")) != null) {
            this.is_ingres = string.equalsIgnoreCase("INGRES");
        }
        if ((string = this.dbCaps.getDbCap("INGRES/SQL_LEVEL")) != null) {
            try {
                this.sqlLevel = Integer.parseInt(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((string = this.dbCaps.getDbCap("OPEN_SQL_DATES")) != null) {
            this.osql_dates = true;
        }
        if ((string = this.dbCaps.getDbCap("NATIONAL_CHARACTER_SET")) != null && string.length() >= 1) {
            boolean bl = this.ucs2_supported = string.charAt(0) == 'Y' || string.charAt(0) == 'y';
        }
        if ((string = this.dbCaps.getDbCap("SQL_MAX_CHAR_COLUMN_LEN")) != null) {
            try {
                this.max_char_len = Integer.parseInt(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((string = this.dbCaps.getDbCap("SQL_MAX_VCHR_COLUMN_LEN")) != null) {
            try {
                this.max_vchr_len = Integer.parseInt(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((string = this.dbCaps.getDbCap("SQL_MAX_BYTE_COLUMN_LEN")) != null) {
            try {
                this.max_byte_len = Integer.parseInt(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((string = this.dbCaps.getDbCap("SQL_MAX_VBYT_COLUMN_LEN")) != null) {
            try {
                this.max_vbyt_len = Integer.parseInt(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((string = this.dbCaps.getDbCap("SQL_MAX_NCHAR_COLUMN_LEN")) == null) {
            this.max_nchr_len = this.max_char_len / 2;
        } else {
            try {
                this.max_nchr_len = Integer.parseInt(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        string = this.dbCaps.getDbCap("SQL_MAX_NVCHR_COLUMN_LEN");
        if (string == null) {
            this.max_nvch_len = this.max_vchr_len / 2;
        } else {
            try {
                this.max_nvch_len = Integer.parseInt(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        string = this.dbCaps.getDbCap("SQL_MAX_DECIMAL_PRECISION");
        if (string != null) {
            try {
                this.max_dec_prec = Integer.parseInt(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    static class DbInfo
    extends DrvObj
    implements DrvConst,
    MsgConst {
        private JdbcRSMD rsmd = null;
        private String request_result;

        public DbInfo(DrvConn drvConn) {
            super(drvConn);
            this.title = this.trace.getTraceName() + "-DbInfo[" + this.msg.connID() + "]";
            this.tr_id = "DbInfo[" + this.msg.connID() + "]";
        }

        public String getDbmsInfo(String string) throws SQLException {
            String string2 = this.conn.msg_protocol_level >= 2 ? this.requestDbInfo(string) : this.selectDbInfo(string);
            return string2;
        }

        private String selectDbInfo(String string) throws SQLException {
            String string2 = null;
            JdbcStmt jdbcStmt = null;
            ResultSet resultSet = null;
            try {
                jdbcStmt = new JdbcStmt(this.conn, 1003, 0, 2);
                String string3 = "select dbmsinfo('" + string + "')";
                if (!this.conn.is_ingres) {
                    string3 = string3 + " from iidbconstants";
                }
                if ((resultSet = jdbcStmt.executeQuery(string3)).next()) {
                    string2 = resultSet.getString(1);
                }
            }
            catch (SQLException sQLException) {
                if (this.trace.enabled(1)) {
                    this.trace.write(this.tr_id + ": error retrieving dbmsinfo()");
                }
                throw sQLException;
            }
            finally {
                if (resultSet != null) {
                    try {
                        resultSet.close();
                    }
                    catch (SQLException sQLException) {}
                }
                if (jdbcStmt != null) {
                    try {
                        jdbcStmt.close();
                    }
                    catch (SQLException sQLException) {}
                }
            }
            return string2;
        }

        private String requestDbInfo(String string) throws SQLException {
            String string2;
            this.msg.lock();
            this.request_result = null;
            try {
                this.msg.begin((byte)10);
                this.msg.write((short)3);
                this.msg.write((short)3);
                this.msg.write(string);
                this.msg.done(true);
                this.readResults();
            }
            catch (SQLException sQLException) {
                if (this.trace.enabled(1)) {
                    this.trace.write(this.tr_id + ": error requesting dbmsinfo()");
                }
                throw sQLException;
            }
            finally {
                String string3 = this.request_result;
                this.msg.unlock();
            }
            return string2;
        }

        @Override
        protected JdbcRSMD readDesc() throws SQLException {
            if (this.rsmd == null) {
                this.rsmd = JdbcRSMD.load(this.conn);
            } else {
                this.rsmd.reload(this.conn);
            }
            return this.rsmd;
        }

        @Override
        protected boolean readData() throws SQLException {
            if (this.msg.moreData()) {
                this.msg.readByte();
                this.request_result = this.msg.readString();
            }
            return false;
        }
    }

    static class DbCaps
    extends DrvObj {
        private JdbcRSMD rsmd = null;
        private Hashtable caps = new Hashtable();

        public DbCaps(DrvConn drvConn) throws SQLException {
            super(drvConn);
            this.title = this.trace.getTraceName() + "-DbCaps[" + this.msg.connID() + "]";
            this.tr_id = "DbCap[" + this.msg.connID() + "]";
        }

        public String getDbCap(String string) {
            return (String)this.caps.get(string);
        }

        public void loadDbCaps() throws SQLException {
            this.msg.lock();
            try {
                this.msg.begin((byte)10);
                this.msg.write((short)1);
                this.msg.done(true);
                this.readResults();
            }
            catch (SQLException sQLException) {
                if (this.trace.enabled(1)) {
                    this.trace.log(this.title + ": error loading DBMS capabilities");
                }
                throw sQLException;
            }
            finally {
                this.msg.unlock();
            }
        }

        @Override
        protected JdbcRSMD readDesc() throws SQLException {
            if (this.rsmd == null) {
                this.rsmd = JdbcRSMD.load(this.conn);
            } else {
                this.rsmd.reload(this.conn);
            }
            return this.rsmd;
        }

        @Override
        protected boolean readData() throws SQLException {
            while (this.msg.moreData()) {
                this.msg.readByte();
                String string = this.msg.readString();
                this.msg.readByte();
                String string2 = this.msg.readString();
                if (this.trace.enabled(4)) {
                    this.trace.write(this.tr_id + ": '" + string + "' = '" + string2 + "'");
                }
                this.caps.put(string, string2);
            }
            return false;
        }
    }
}

