/*
 * Decompiled with CFR 0.152.
 */
package com.ingres.gcf.dam;

import com.ingres.gcf.dam.MsgConst;
import com.ingres.gcf.dam.TlConst;
import com.ingres.gcf.util.CharSet;
import com.ingres.gcf.util.GcfErr;
import com.ingres.gcf.util.IdMap;
import com.ingres.gcf.util.SqlExFactory;
import com.ingres.gcf.util.TraceLog;
import com.ingres.gcf.util.Tracing;
import java.net.InetAddress;
import java.net.Socket;
import java.sql.SQLException;

class MsgIo
implements GcfErr,
TlConst,
MsgConst {
    public static final String DAM_ML_TRACE_ID = "msg";
    protected Socket socket = null;
    protected CharSet char_set = null;
    protected byte msg_proto_lvl = 1;
    protected byte tl_proto_lvl = 1;
    protected String title = null;
    protected Tracing trace;
    protected static IdMap[] msgMap = new IdMap[]{new IdMap(1, "CONNECT"), new IdMap(2, "DISCONN"), new IdMap(3, "XACT"), new IdMap(4, "QUERY"), new IdMap(5, "CURSOR"), new IdMap(6, "DESC"), new IdMap(7, "DATA"), new IdMap(8, "ERROR"), new IdMap(9, "RESULT"), new IdMap(10, "REQUEST"), new IdMap(11, "INFO"), new IdMap(12, "BATCH")};
    private int conn_id = connections++;
    private static int connections = 0;

    protected MsgIo(TraceLog traceLog) throws SQLException {
        this.trace = new Tracing(traceLog, DAM_ML_TRACE_ID);
        this.title = "MsgIo[" + this.conn_id + "]";
    }

    protected void connect(String string, String string2) throws SQLException {
        InetAddress[] inetAddressArray;
        Exception exception = null;
        if (this.trace.enabled(2)) {
            this.trace.write(this.title + ": opening network connection '" + string + "', '" + string2 + "'");
        }
        try {
            inetAddressArray = InetAddress.getAllByName(string);
        }
        catch (Exception exception2) {
            if (this.trace.enabled(1)) {
                this.trace.write(this.title + ": Error resolving host address - " + exception2.getMessage());
            }
            throw SqlExFactory.get(ERR_GC4001_CONNECT_ERR, exception2);
        }
        int n = this.translatePortID(string2);
        for (int i = 0; i < inetAddressArray.length; ++i) {
            String string3 = inetAddressArray[i].getHostAddress();
            if (this.trace.enabled(5) && !string.equalsIgnoreCase(string3)) {
                this.trace.write(this.title + ": " + string + " => " + string3);
            }
            try {
                this.socket = new Socket(inetAddressArray[i], n);
                if (this.trace.enabled(3)) {
                    this.trace.write(this.title + ": connected to " + string3 + "," + n);
                }
                return;
            }
            catch (Exception exception3) {
                if (this.trace.enabled(1)) {
                    this.trace.write(this.title + ": connection failed to " + string3 + "," + n + " - " + exception3.getMessage());
                }
                exception = exception3;
                continue;
            }
        }
        this.trace.write(this.title + ": all addresses have failed");
        throw SqlExFactory.get(ERR_GC4001_CONNECT_ERR, exception);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void close() {
        if (this.socket != null) {
            if (this.trace.enabled(2)) {
                this.trace.write(this.title + ": closing network connection");
            }
            try {
                this.socket.close();
            }
            catch (Exception exception) {
            }
            finally {
                this.socket = null;
            }
        }
    }

    protected void disconnect() {
        this.close();
    }

    public void abort() {
        this.close();
    }

    public boolean isClosed() {
        return this.socket == null;
    }

    public boolean isLocal() {
        return this.socket == null ? false : this.socket.getInetAddress().equals(this.socket.getLocalAddress());
    }

    public int connID() {
        return this.conn_id;
    }

    public String getRemoteHost() {
        String string;
        try {
            string = this.socket.getInetAddress().getHostName();
        }
        catch (Exception exception) {
            string = null;
        }
        return string;
    }

    public String getRemoteAddr() {
        return this.socket.getInetAddress().getHostAddress();
    }

    public String getLocalHost() {
        String string;
        try {
            string = InetAddress.getLocalHost().getHostName();
        }
        catch (Exception exception) {
            string = null;
        }
        return string;
    }

    public String getLocalAddr() {
        String string;
        try {
            string = InetAddress.getLocalHost().getHostAddress();
        }
        catch (Exception exception) {
            string = null;
        }
        return string;
    }

    public byte setProtocolLevel(byte by) {
        byte by2 = this.msg_proto_lvl;
        this.msg_proto_lvl = by;
        return by2;
    }

    public CharSet getCharSet() {
        return this.char_set;
    }

    public void setCharSet(CharSet charSet) {
        this.char_set = charSet;
    }

    private int translatePortID(String string) throws SQLException {
        int n;
        int n2 = 0;
        switch (string.length()) {
            case 4: {
                char c2 = string.charAt(2);
                if (!Character.isDigit(c2)) break;
                n2 = Character.digit(c2, 10) * 10;
            }
            case 3: {
                char c2 = string.charAt(string.length() - 1);
                if (!Character.isDigit(c2) || (n2 += Character.digit(c2, 10)) > 15) break;
            }
            case 2: {
                char c;
                char c2 = string.charAt(0);
                if (!Character.isLetter(c2) || !Character.isLetterOrDigit(c = string.charAt(1))) break;
                c2 = Character.toUpperCase(c2);
                c = Character.toUpperCase(c);
                int n3 = (n2 > 7 ? 2 : 1) << 14 | (c2 & 0x1F) << 9 | (c & 0x3F) << 3 | n2 & 7;
                if (this.trace.enabled(5)) {
                    this.trace.write(this.title + ": " + string + " => " + n3);
                }
                return n3;
            }
        }
        try {
            n = Integer.parseInt(string);
        }
        catch (Exception exception) {
            if (this.trace.enabled(1)) {
                this.trace.write(this.title + ": invalid port ID '" + string + "'");
            }
            throw SqlExFactory.get(ERR_GC4000_BAD_URL);
        }
        return n;
    }
}

