/*
 * Decompiled with CFR 0.152.
 */
package org.freecompany.redline.header;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import org.freecompany.redline.Util;
import org.freecompany.redline.header.Architecture;
import org.freecompany.redline.header.Os;
import org.freecompany.redline.header.RpmType;

public class Lead {
    public static final int LEAD_SIZE = 96;
    private static final int MAGIC = -307499301;
    protected byte major = (byte)3;
    protected byte minor;
    protected RpmType type = RpmType.BINARY;
    protected Architecture arch = Architecture.NOARCH;
    protected String name;
    protected Os os = Os.LINUX;
    protected short sigtype = (short)5;

    public CharSequence getName() {
        return this.name;
    }

    public Architecture getArch() {
        return this.arch;
    }

    public void setMajor(byte major) {
        this.major = major;
    }

    public void setMinor(byte minor) {
        this.minor = minor;
    }

    public void setType(RpmType type) {
        this.type = type;
    }

    public void setArch(Architecture arch) {
        this.arch = arch;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setOs(Os os) {
        this.os = os;
    }

    public void setSigtype(short sigtype) {
        this.sigtype = sigtype;
    }

    public void read(ReadableByteChannel channel) throws IOException {
        byte b;
        ByteBuffer lead = Util.fill(channel, 96);
        Util.check(-307499301, lead.getInt());
        this.major = lead.get();
        this.minor = lead.get();
        this.type = RpmType.values()[lead.getShort()];
        short tmp = lead.getShort();
        if (tmp < Architecture.values().length) {
            this.arch = Architecture.values()[tmp];
        }
        ByteBuffer data = ByteBuffer.allocate(66);
        lead.get(data.array());
        StringBuilder builder = new StringBuilder();
        while ((b = data.get()) != 0) {
            builder.append((char)b);
        }
        this.name = builder.toString();
        this.os = Os.values()[lead.getShort()];
        this.sigtype = lead.getShort();
        if (lead.remaining() != 16) {
            throw new IllegalStateException("Expected 16 remaining, found '" + lead.remaining() + "'.");
        }
    }

    public void write(WritableByteChannel channel) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(96);
        buffer.putInt(-307499301);
        buffer.put(this.major);
        buffer.put(this.minor);
        buffer.putShort((short)this.type.ordinal());
        buffer.putShort((short)this.arch.ordinal());
        byte[] data = new byte[66];
        byte[] encoded = this.name.getBytes("UTF-8");
        System.arraycopy(encoded, 0, data, 0, encoded.length);
        buffer.put(data);
        buffer.putShort((short)this.os.ordinal());
        buffer.putShort(this.sigtype);
        buffer.position(buffer.position() + 16);
        buffer.flip();
        if (buffer.remaining() != 96) {
            throw new IllegalStateException("Invalid lead size generated with '" + buffer.remaining() + "' bytes.");
        }
        Util.empty(channel, buffer);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Version: ").append(this.major).append(".").append(this.minor).append("\n");
        builder.append("Type: ").append((Object)this.type).append("\n");
        builder.append("Arch: ").append((Object)this.arch).append("\n");
        builder.append("Name: ").append(this.name).append("\n");
        builder.append("OS: ").append((Object)this.os).append("\n");
        builder.append("Sig type: ").append(this.sigtype).append("\n");
        return builder.toString();
    }
}

