/*
 * Decompiled with CFR 0.152.
 */
package org.freecompany.redline.ant;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.ZipFileSet;
import org.freecompany.redline.Builder;
import org.freecompany.redline.Util;
import org.freecompany.redline.ant.Depends;
import org.freecompany.redline.ant.Link;
import org.freecompany.redline.header.Architecture;
import org.freecompany.redline.header.Os;
import org.freecompany.redline.header.RpmType;

public class RedlineTask
extends Task {
    public static final String NAMESPACE = "http://freecompany.org/namespace/redline";
    protected String name;
    protected String version;
    protected String group;
    protected String release = "1";
    protected String host;
    protected String summary = "";
    protected String description = "";
    protected String license = "";
    protected String packager = System.getProperty("user.name", "");
    protected String distribution = "";
    protected String vendor = "";
    protected String url = "";
    protected String provides;
    protected RpmType type = RpmType.BINARY;
    protected Architecture architecture = Architecture.NOARCH;
    protected Os os = Os.LINUX;
    protected File destination;
    protected List<ZipFileSet> filesets = new ArrayList<ZipFileSet>();
    protected List<Link> links = new ArrayList<Link>();
    protected List<Depends> depends = new ArrayList<Depends>();
    protected File preInstallScript;
    protected File postInstallScript;
    protected File preUninstallScript;
    protected File postUninstallScript;

    public RedlineTask() {
        try {
            this.host = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            this.host = "";
        }
    }

    public void execute() throws BuildException {
        if (this.name == null) {
            throw new BuildException("Attribute 'name' is required.");
        }
        if (this.version == null) {
            throw new BuildException("Attribute 'version' is required.");
        }
        if (this.group == null) {
            throw new BuildException("Attribute 'group' is required.");
        }
        Builder builder = new Builder();
        builder.setPackage(this.name, this.version, this.release);
        builder.setType(this.type);
        builder.setPlatform(this.architecture, this.os);
        builder.setGroup(this.group);
        builder.setBuildHost(this.host);
        builder.setSummary(this.summary);
        builder.setDescription(this.description);
        builder.setLicense(this.license);
        builder.setPackager(this.packager);
        builder.setDistribution(this.distribution);
        builder.setVendor(this.vendor);
        builder.setUrl(this.url);
        builder.setProvides(this.provides == null ? this.name : this.provides);
        try {
            builder.setPreInstallScript(this.preInstallScript);
            builder.setPostInstallScript(this.postInstallScript);
            builder.setPreUninstallScript(this.preUninstallScript);
            builder.setPostUninstallScript(this.postUninstallScript);
            for (ZipFileSet fileset : this.filesets) {
                File zip = fileset.getSrc(this.getProject());
                String prefix = Util.normalizePath(fileset.getPrefix(this.getProject()));
                if (!prefix.endsWith("/")) {
                    prefix = prefix + "/";
                }
                DirectoryScanner scanner = fileset.getDirectoryScanner(this.getProject());
                int dirmode = fileset.getDirMode(this.getProject()) & 0xFFF;
                for (String entry : scanner.getIncludedFiles()) {
                    if (zip != null) {
                        URL url = new URL("jar:" + zip.toURL() + "!/" + entry);
                        builder.addURL(prefix + entry, url, fileset.getFileMode(this.getProject()) & 0xFFF, dirmode);
                        continue;
                    }
                    File file = new File(scanner.getBasedir(), entry);
                    builder.addFile(prefix + entry, file, fileset.getFileMode(this.getProject()) & 0xFFF, dirmode);
                }
            }
            for (Link link : this.links) {
                builder.addLink(link.getPath(), link.getTarget(), link.getPermissions());
            }
            for (Depends dependency : this.depends) {
                builder.addDependencyMore(dependency.getName(), dependency.getVersion());
            }
            this.log("Created rpm: " + builder.build(this.destination));
        }
        catch (IOException e) {
            throw new BuildException("Error packaging distribution files.", (Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new BuildException("This system does not support MD5 digests.", (Throwable)e);
        }
    }

    public void restrict(String name) {
        Iterator<Depends> i = this.depends.iterator();
        while (i.hasNext()) {
            Depends dependency = i.next();
            if (!dependency.getName().equals(name)) continue;
            i.remove();
        }
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setType(String type) {
        this.type = RpmType.valueOf(type);
    }

    public void setArchitecture(String architecture) {
        this.architecture = Architecture.valueOf(architecture);
    }

    public void setOs(String os) {
        this.os = Os.valueOf(os);
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setRelease(String release) {
        this.release = release;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setSummary(String summary) {
        this.summary = summary;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setLicense(String license) {
        this.license = license;
    }

    public void setPackager(String packager) {
        this.packager = packager;
    }

    public void setDistribution(String distribution) {
        this.distribution = distribution;
    }

    public void setVendor(String vendor) {
        this.vendor = vendor;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setProvides(String provides) {
        this.provides = provides;
    }

    public void setDestination(File destination) {
        this.destination = destination;
    }

    public void addZipfileset(ZipFileSet fileset) {
        this.filesets.add(fileset);
    }

    public void addLink(Link link) {
        this.links.add(link);
    }

    public void addDepends(Depends dependency) {
        this.depends.add(dependency);
    }

    public void setPreInstallScript(File preInstallScript) {
        this.preInstallScript = preInstallScript;
    }

    public void setPostInstallScript(File postInstallScript) {
        this.postInstallScript = postInstallScript;
    }

    public void setPreUninstallScript(File preUninstallScript) {
        this.preUninstallScript = preUninstallScript;
    }

    public void setPostUninstallScript(File postUninstallScript) {
        this.postUninstallScript = postUninstallScript;
    }
}

