/*
 * Decompiled with CFR 0.152.
 */
package org.joone.util;

import java.util.ArrayList;
import java.util.List;
import org.joone.engine.Pattern;
import org.joone.log.ILogger;
import org.joone.log.LoggerFactory;
import org.joone.util.ConverterPlugIn;

public class ToBinaryPlugin
extends ConverterPlugIn {
    private static final ILogger log = LoggerFactory.getLogger(ToBinaryPlugin.class);
    private List theConvertedSeries = new ArrayList();
    private double upperBit = 1.0;
    private double lowerBit = 0.0;

    public ToBinaryPlugin() {
    }

    public ToBinaryPlugin(String anAdvancedSerieSelector) {
        super(anAdvancedSerieSelector);
    }

    protected boolean convert(int serie) {
        double[] myArray;
        boolean retValue = false;
        int mySerie = serie;
        boolean myHasPositiveValues = false;
        boolean myHasNegativeValues = false;
        int i = 0;
        while (i < this.theConvertedSeries.size()) {
            if (((int[])this.theConvertedSeries.get(i))[0] < serie) {
                mySerie += ((int[])this.theConvertedSeries.get(i))[1];
            }
            ++i;
        }
        int mySize = 0;
        double[][] myBinaries = new double[this.getInputVector().size()][];
        int i2 = 0;
        while (i2 < this.getInputVector().size()) {
            myArray = ((Pattern)this.getInputVector().get(i2)).getArray();
            myBinaries[i2] = this.getBinary(myArray[mySerie]);
            if (myBinaries[i2].length > mySize) {
                mySize = myBinaries[i2].length;
            }
            if (myArray[mySerie] > 0.0) {
                myHasPositiveValues = true;
            } else if (myArray[mySerie] < 0.0) {
                myHasNegativeValues = true;
            }
            ++i2;
        }
        int mySignBitLenght = myHasPositiveValues && myHasNegativeValues ? 1 : 0;
        i2 = 0;
        while (i2 < this.getInputVector().size()) {
            myArray = ((Pattern)this.getInputVector().get(i2)).getArray();
            double[] myNewArray = new double[myArray.length - 1 + mySize + mySignBitLenght];
            int j = 0;
            while (j < myArray.length) {
                if (j < mySerie) {
                    myNewArray[j] = myArray[j];
                } else if (j > mySerie) {
                    myNewArray[j + mySize + mySignBitLenght - 1] = myArray[j];
                }
                ++j;
            }
            j = 0;
            while (j < mySize + mySignBitLenght) {
                if (j >= myBinaries[i2].length) {
                    myNewArray[mySerie + j] = this.getLowerBit();
                    if (j == mySize && myArray[mySerie] < 0.0) {
                        myNewArray[mySerie + j] = this.getUpperBit();
                    }
                } else {
                    myNewArray[mySerie + j] = myBinaries[i2][j];
                }
                ++j;
            }
            ((Pattern)this.getInputVector().get(i2)).setArray(myNewArray);
            retValue = true;
            ++i2;
        }
        this.theConvertedSeries.add(new int[]{serie, mySize + mySignBitLenght - 1});
        return retValue;
    }

    protected boolean apply() {
        this.theConvertedSeries = new ArrayList();
        return super.apply();
    }

    protected double[] getBinary(double aNumber) {
        aNumber = Math.floor(aNumber);
        double myTemp = aNumber = Math.abs(aNumber);
        int mySize = 0;
        while (myTemp > 0.0) {
            ++mySize;
            myTemp /= 2.0;
            myTemp = Math.floor(myTemp);
        }
        double[] myBinary = new double[mySize];
        int i = 0;
        while (i < mySize) {
            myTemp = aNumber / 2.0;
            myBinary[i] = myTemp > (aNumber = Math.floor(myTemp)) ? this.getUpperBit() : this.getLowerBit();
            ++i;
        }
        return myBinary;
    }

    public void setUpperBit(double aValue) {
        this.upperBit = aValue;
    }

    public double getUpperBit() {
        return this.upperBit;
    }

    public void setLowerBit(double aValue) {
        this.lowerBit = aValue;
    }

    public double getLowerBit() {
        return this.lowerBit;
    }
}

