/*
 * Decompiled with CFR 0.152.
 */
package org.joone.util;

import java.util.Random;
import java.util.Vector;
import org.joone.engine.Pattern;
import org.joone.engine.RbfGaussianLayer;
import org.joone.engine.RbfGaussianParameters;
import org.joone.log.ILogger;
import org.joone.log.LoggerFactory;
import org.joone.util.ConverterPlugIn;

public class RbfRandomCenterSelector
extends ConverterPlugIn {
    private static final ILogger log = LoggerFactory.getLogger(RbfRandomCenterSelector.class);
    private RbfGaussianLayer theRbfGaussianLayer;
    private Vector thePatterns = null;
    private Random random = new Random(1997L);

    public RbfRandomCenterSelector(RbfGaussianLayer aRbfGaussianLayer) {
        this.theRbfGaussianLayer = aRbfGaussianLayer;
        this.setAdvancedSerieSelector("1");
    }

    protected boolean convert(int serie) {
        if (this.thePatterns == null) {
            this.thePatterns = this.getInputVector();
        }
        return false;
    }

    public RbfGaussianParameters[] getGaussianParameters() {
        if (this.thePatterns.size() < this.theRbfGaussianLayer.getRows()) {
            log.warn("There are more neurons in RBF layer than training patterns -> not all nodes in RBF layer will be assigned a unique center.");
        }
        int[] myCenters = new int[this.theRbfGaussianLayer.getRows()];
        int i = 0;
        while (i < this.theRbfGaussianLayer.getRows()) {
            int myCenter = (int)(this.random.nextDouble() * (double)this.thePatterns.size());
            if (i < this.thePatterns.size()) {
                boolean myNonSelected = true;
                do {
                    if (!myNonSelected) {
                        myCenter = (int)(this.random.nextDouble() * (double)this.thePatterns.size());
                        myNonSelected = true;
                    }
                    int j = 0;
                    while (j < i) {
                        if (myCenters[j] == myCenter) {
                            myNonSelected = false;
                        }
                        ++j;
                    }
                } while (!myNonSelected);
            }
            myCenters[i] = myCenter;
            ++i;
        }
        double myD = this.getMaxDistance(this.thePatterns, myCenters);
        double myStdDeviation = myD / Math.sqrt(2 * this.theRbfGaussianLayer.getRows());
        RbfGaussianParameters[] myParameters = new RbfGaussianParameters[this.theRbfGaussianLayer.getRows()];
        int i2 = 0;
        while (i2 < this.theRbfGaussianLayer.getRows()) {
            double[] myCenter = (double[])((Pattern)this.thePatterns.get(myCenters[i2])).getArray().clone();
            myParameters[i2] = new RbfGaussianParameters(myCenter, myStdDeviation);
            ++i2;
        }
        return myParameters;
    }

    protected double getMaxDistance(Vector aPatterns, int[] anIndexes) {
        double myMax = -1.0;
        int i = 0;
        while (i < anIndexes.length - 1) {
            int j = i + 1;
            while (j < anIndexes.length) {
                double myDistance = this.getDistance((Pattern)aPatterns.get(anIndexes[i]), (Pattern)aPatterns.get(anIndexes[j]));
                if (myDistance > myMax) {
                    myMax = myDistance;
                }
                ++j;
            }
            ++i;
        }
        return myMax;
    }

    protected double getDistance(Pattern aCenter1, Pattern aCenter2) {
        double myDistance = 0.0;
        int i = 0;
        while (i < aCenter1.getArray().length) {
            double myDiff = aCenter1.getArray()[i] - aCenter2.getArray()[i];
            myDistance += myDiff * myDiff;
            ++i;
        }
        return Math.sqrt(myDistance);
    }
}

