/*
 * Decompiled with CFR 0.152.
 */
package org.joone.util;

import org.joone.engine.Pattern;
import org.joone.util.CSVParser;
import org.joone.util.ConverterPlugIn;

public class MovingAveragePlugIn
extends ConverterPlugIn {
    static final long serialVersionUID = -5679399800426091523L;
    private String AdvancedMovAvgSpec = new String("");

    public MovingAveragePlugIn() {
    }

    public MovingAveragePlugIn(String newAdvSerieSel, String newMovAvgSpec) {
        this.setAdvancedMovAvgSpec(newMovAvgSpec);
        this.setAdvancedSerieSelector(newAdvSerieSel);
    }

    protected boolean convert(int serie) {
        boolean retValue = false;
        int s = this.getInputVector().size();
        double CurrentMovingAvgerage = 0.0;
        double Sum = 0.0;
        int MovingAverageSpec = 0;
        boolean CurrentItem = false;
        CSVParser MovParse = new CSVParser(this.AdvancedMovAvgSpec, false);
        int[] MovAvgArray = MovParse.parseInt();
        int index = this.getSerieIndexNumber(serie);
        if (index > -1 && index < MovAvgArray.length) {
            MovingAverageSpec = MovAvgArray[index];
        }
        if (MovingAverageSpec > 0 && this.getInputVector().size() > MovingAverageSpec) {
            Sum = 0.0;
            CurrentMovingAvgerage = 0.0;
            int i = this.getInputVector().size() - 1;
            while (i > -1) {
                Pattern currPE = (Pattern)this.getInputVector().elementAt(i);
                if (i < MovingAverageSpec - 1) {
                    CurrentMovingAvgerage = 0.0;
                } else {
                    Sum = 0.0;
                    int j = i;
                    while (j > i - MovingAverageSpec) {
                        Sum += this.getValuePoint(j, serie);
                        --j;
                    }
                    CurrentMovingAvgerage = Sum / (double)MovingAverageSpec;
                }
                currPE.setValue(serie, CurrentMovingAvgerage);
                retValue = true;
                --i;
            }
        }
        return retValue;
    }

    public String getAdvancedMovAvgSpec() {
        return this.AdvancedMovAvgSpec;
    }

    public void setAdvancedMovAvgSpec(String newAdvancedMovAvgSpec) {
        if (this.AdvancedMovAvgSpec.compareTo(newAdvancedMovAvgSpec) != 0) {
            this.AdvancedMovAvgSpec = newAdvancedMovAvgSpec;
            this.fireDataChanged();
        }
    }
}

