/*
 * Decompiled with CFR 0.152.
 */
package org.joone.net;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.TreeSet;
import java.util.Vector;
import org.joone.engine.InputPatternListener;
import org.joone.engine.Layer;
import org.joone.engine.LinearLayer;
import org.joone.engine.Matrix;
import org.joone.engine.Monitor;
import org.joone.engine.NeuralLayer;
import org.joone.engine.OutputPatternListener;
import org.joone.engine.Pattern;
import org.joone.io.StreamInputSynapse;
import org.joone.io.StreamOutputSynapse;
import org.joone.log.ILogger;
import org.joone.log.LoggerFactory;
import org.joone.net.NetCheck;
import org.joone.net.NeuralNet;

public class NestedNeuralLayer
extends Layer {
    private static final ILogger log = LoggerFactory.getLogger(NestedNeuralLayer.class);
    static final long serialVersionUID = -3697306754884303651L;
    private String sNeuralNet;
    private NeuralNet NestedNeuralNet = new NeuralNet();
    private LinearLayer lin = new LinearLayer();
    private transient File embeddedNet = null;

    public NestedNeuralLayer() {
        this("");
    }

    public NestedNeuralLayer(String ElemName) {
        this.lin.setLayerName("Nested LinearLayer");
        this.NestedNeuralNet.addLayer(this.lin, 0);
        this.sNeuralNet = new String();
        this.setLayerName(ElemName);
    }

    protected void setDimensions() {
    }

    protected void forward(double[] pattern) {
    }

    protected void backward(double[] pattern) {
    }

    public String getNeuralNet() {
        return this.sNeuralNet;
    }

    public void setNeuralNet(String NNFile) {
        this.sNeuralNet = NNFile;
        try {
            NeuralNet newNeuralNet = this.readNeuralNet();
            if (newNeuralNet != null) {
                this.setNestedNeuralNet(newNeuralNet);
            }
        }
        catch (Exception e) {
            log.warn("Exception thrown. Message is : " + e.getMessage(), e);
        }
    }

    public void start() {
        this.NestedNeuralNet.start();
    }

    public void stop() {
        this.NestedNeuralNet.stop();
    }

    public int getRows() {
        return this.NestedNeuralNet.getRows();
    }

    public void setRows(int p1) {
        this.NestedNeuralNet.setRows(p1);
    }

    public void addNoise(double p1) {
        if (this.isLearning()) {
            this.NestedNeuralNet.addNoise(p1);
        }
    }

    public void randomize(double amplitude) {
        if (this.isLearning()) {
            this.NestedNeuralNet.randomize(amplitude);
        }
    }

    public Matrix getBias() {
        return this.NestedNeuralNet.getBias();
    }

    public Vector getAllOutputs() {
        return this.NestedNeuralNet.getAllOutputs();
    }

    public String getLayerName() {
        return this.NestedNeuralNet.getLayerName();
    }

    public void removeOutputSynapse(OutputPatternListener p1) {
        this.NestedNeuralNet.removeOutputSynapse(p1);
    }

    public void setAllInputs(Vector p1) {
        this.NestedNeuralNet.setAllInputs(p1);
    }

    public void removeAllOutputs() {
        this.NestedNeuralNet.removeAllOutputs();
    }

    public Vector getAllInputs() {
        return this.NestedNeuralNet.getAllInputs();
    }

    public boolean addOutputSynapse(OutputPatternListener p1) {
        return this.NestedNeuralNet.addOutputSynapse(p1);
    }

    public void setBias(Matrix p1) {
        this.NestedNeuralNet.setBias(p1);
    }

    public void removeInputSynapse(InputPatternListener p1) {
        this.NestedNeuralNet.removeInputSynapse(p1);
    }

    public void setLayerName(String p1) {
        this.NestedNeuralNet.setLayerName(p1);
    }

    public boolean addInputSynapse(InputPatternListener p1) {
        return this.NestedNeuralNet.addInputSynapse(p1);
    }

    public void setAllOutputs(Vector p1) {
        this.NestedNeuralNet.setAllOutputs(p1);
    }

    public void setMonitor(Monitor p1) {
        this.getMonitor().setParent(p1);
    }

    public Monitor getMonitor() {
        return this.NestedNeuralNet.getMonitor();
    }

    public void removeAllInputs() {
        this.NestedNeuralNet.removeAllInputs();
    }

    public NeuralLayer copyInto(NeuralLayer p1) {
        return this.NestedNeuralNet.copyInto(p1);
    }

    private NeuralNet readNeuralNet() throws IOException, ClassNotFoundException {
        if (this.sNeuralNet == null) {
            return null;
        }
        if (this.sNeuralNet.equals(new String(""))) {
            return null;
        }
        File NNFile = new File(this.sNeuralNet);
        FileInputStream fin = new FileInputStream(NNFile);
        ObjectInputStream oin = new ObjectInputStream(fin);
        NeuralNet newNeuralNet = (NeuralNet)oin.readObject();
        oin.close();
        fin.close();
        return newNeuralNet;
    }

    public boolean isRunning() {
        if (this.NestedNeuralNet == null) {
            return false;
        }
        return this.NestedNeuralNet.isRunning();
    }

    public NeuralNet getNestedNeuralNet() {
        return this.NestedNeuralNet;
    }

    public void setNestedNeuralNet(NeuralNet newNeuralNet) {
        newNeuralNet.removeAllListeners();
        newNeuralNet.setLayerName(this.NestedNeuralNet.getLayerName());
        newNeuralNet.setTeacher(null);
        newNeuralNet.setAllInputs(this.NestedNeuralNet.getAllInputs());
        newNeuralNet.setAllOutputs(this.NestedNeuralNet.getAllOutputs());
        Monitor extMonitor = this.getMonitor();
        this.lin = null;
        this.NestedNeuralNet = newNeuralNet;
        this.NestedNeuralNet.setMonitor(new Monitor());
        this.setMonitor(extMonitor);
    }

    public boolean isLearning() {
        return this.NestedNeuralNet.getMonitor().isLearning();
    }

    public void setLearning(boolean learning) {
        this.NestedNeuralNet.getMonitor().setLearning(learning);
    }

    public TreeSet check() {
        return this.setErrorSource(this.NestedNeuralNet.check());
    }

    public File getEmbeddedNet() {
        return this.embeddedNet;
    }

    public void setEmbeddedNet(File embeddedNet) {
        if (embeddedNet != null) {
            if (!this.sNeuralNet.equals(embeddedNet.getAbsolutePath())) {
                this.embeddedNet = embeddedNet;
                this.setNeuralNet(embeddedNet.getAbsolutePath());
            }
        } else {
            this.embeddedNet = embeddedNet;
            this.sNeuralNet = "";
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.embeddedNet = new File(this.sNeuralNet);
    }

    private TreeSet setErrorSource(TreeSet errors) {
        if (!errors.isEmpty()) {
            for (NetCheck nc : errors) {
                if (nc.getSource() instanceof Monitor || nc.getSource() instanceof StreamInputSynapse || nc.getSource() instanceof StreamOutputSynapse) continue;
                nc.setSource(this);
            }
        }
        return errors;
    }

    public void fwdRun(Pattern pattIn) {
        this.NestedNeuralNet.singleStepForward(pattIn);
    }

    public void revRun(Pattern pattIn) {
        this.NestedNeuralNet.singleStepBackward(pattIn);
    }
}

