/*
 * Decompiled with CFR 0.152.
 */
package org.joone.io;

import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.TreeSet;
import java.util.Vector;
import org.joone.engine.Monitor;
import org.joone.engine.Pattern;
import org.joone.io.InputConnector;
import org.joone.io.StreamInputSynapse;
import org.joone.util.ConverterPlugIn;
import org.joone.util.PlugInEvent;

public class InputSwitchSynapse
extends StreamInputSynapse
implements Serializable {
    protected Vector inputs;
    private StreamInputSynapse activeSynapse;
    private StreamInputSynapse defaultSynapse;
    private String name;
    private Monitor mon;
    private int outputDimension;
    private static final long serialVersionUID = 9025876263540714672L;

    public InputSwitchSynapse() {
        this.initSwitch();
        this.mon = null;
        this.outputDimension = 0;
    }

    protected void initSwitch() {
        this.inputs = new Vector();
        this.defaultSynapse = null;
        this.activeSynapse = null;
    }

    public void init() {
        super.init();
        int i = 0;
        while (i < this.inputs.size()) {
            StreamInputSynapse inp = (StreamInputSynapse)this.inputs.elementAt(i);
            inp.init();
            ++i;
        }
    }

    public void resetSwitch() {
        this.setActiveSynapse(this.getDefaultSynapse());
    }

    public void reset() {
        int i = 0;
        while (i < this.inputs.size()) {
            StreamInputSynapse inp = (StreamInputSynapse)this.inputs.elementAt(i);
            inp.reset();
            ++i;
        }
    }

    public boolean removeInputSynapse(String inputName) {
        boolean retValue = false;
        StreamInputSynapse sis = this.getInputSynapse(inputName);
        if (sis != null) {
            this.inputs.removeElement(sis);
            sis.setInputFull(false);
            if (this.inputs.size() > 0) {
                if (this.getActiveInput().equalsIgnoreCase(inputName)) {
                    this.setActiveSynapse((StreamInputSynapse)this.inputs.elementAt(0));
                }
                if (this.getDefaultInput().equalsIgnoreCase(inputName)) {
                    this.setDefaultSynapse((StreamInputSynapse)this.inputs.elementAt(0));
                }
            } else {
                this.setActiveInput("");
                this.setDefaultInput("");
            }
            retValue = true;
        }
        return retValue;
    }

    protected StreamInputSynapse getInputSynapse(String inputName) {
        StreamInputSynapse inp = null;
        int i = 0;
        while (i < this.inputs.size()) {
            inp = (StreamInputSynapse)this.inputs.elementAt(i);
            if (inp.getName().equalsIgnoreCase(inputName)) {
                return inp;
            }
            ++i;
        }
        return null;
    }

    public boolean addInputSynapse(StreamInputSynapse newInput) {
        boolean retValue = false;
        if (!this.inputs.contains(newInput) && !newInput.isInputFull()) {
            this.inputs.addElement(newInput);
            newInput.setOutputDimension(this.outputDimension);
            newInput.setMonitor(this.mon);
            newInput.setStepCounter(super.isStepCounter());
            newInput.setInputFull(true);
            if (this.inputs.size() == 1) {
                this.setDefaultInput(newInput.getName());
                this.setActiveInput(newInput.getName());
            }
            retValue = true;
        }
        return retValue;
    }

    public String getActiveInput() {
        if (this.activeSynapse != null) {
            return this.activeSynapse.getName();
        }
        return "";
    }

    public void setActiveInput(String newActiveInput) {
        StreamInputSynapse inp;
        this.activeSynapse = inp = this.getInputSynapse(newActiveInput);
    }

    public String getDefaultInput() {
        if (this.defaultSynapse != null) {
            return this.defaultSynapse.getName();
        }
        return "";
    }

    public void setDefaultInput(String newDefaultInput) {
        StreamInputSynapse inp;
        this.defaultSynapse = inp = this.getInputSynapse(newDefaultInput);
    }

    protected StreamInputSynapse getActiveSynapse() {
        return this.activeSynapse;
    }

    protected void setActiveSynapse(StreamInputSynapse activeSynapse) {
        this.activeSynapse = activeSynapse;
    }

    protected StreamInputSynapse getDefaultSynapse() {
        return this.defaultSynapse;
    }

    protected void setDefaultSynapse(StreamInputSynapse defaultSynapse) {
        this.defaultSynapse = defaultSynapse;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setOutputDimension(int newOutputDimension) {
        this.outputDimension = newOutputDimension;
        int i = 0;
        while (i < this.inputs.size()) {
            StreamInputSynapse inp = (StreamInputSynapse)this.inputs.elementAt(i);
            inp.setOutputDimension(newOutputDimension);
            ++i;
        }
    }

    public void revPut(Pattern pattern) {
        if (this.activeSynapse != null) {
            this.activeSynapse.revPut(pattern);
        }
    }

    public Pattern fwdGet() {
        if (this.activeSynapse != null) {
            return this.activeSynapse.fwdGet();
        }
        return null;
    }

    public Pattern fwdGet(InputConnector conn) {
        if (this.activeSynapse != null) {
            return this.activeSynapse.fwdGet(conn);
        }
        return null;
    }

    public int getOutputDimension() {
        return this.outputDimension;
    }

    public Monitor getMonitor() {
        return this.mon;
    }

    public void setMonitor(Monitor newMonitor) {
        this.mon = newMonitor;
        int i = 0;
        while (i < this.inputs.size()) {
            StreamInputSynapse inp = (StreamInputSynapse)this.inputs.elementAt(i);
            inp.setMonitor(newMonitor);
            ++i;
        }
    }

    protected void backward(double[] pattern) {
    }

    protected void forward(double[] pattern) {
    }

    public Vector getAllInputs() {
        return this.inputs;
    }

    public void setAllInputs(Vector inps) {
        this.inputs = inps;
        if (this.inputs != null) {
            int i = 0;
            while (i < this.inputs.size()) {
                StreamInputSynapse inp = (StreamInputSynapse)this.inputs.elementAt(i);
                inp.setInputFull(true);
                ++i;
            }
        }
    }

    public void resetInput() {
        int i = 0;
        while (i < this.inputs.size()) {
            StreamInputSynapse inp = (StreamInputSynapse)this.inputs.elementAt(i);
            inp.resetInput();
            ++i;
        }
        this.reset();
    }

    protected void initInputStream() {
    }

    public void setStepCounter(boolean newStepCounter) {
        super.setStepCounter(newStepCounter);
        int i = 0;
        while (i < this.inputs.size()) {
            StreamInputSynapse inp = (StreamInputSynapse)this.inputs.elementAt(i);
            inp.setStepCounter(newStepCounter);
            ++i;
        }
    }

    public void gotoLine(int numLine) throws IOException {
        if (this.activeSynapse != null) {
            this.activeSynapse.gotoLine(numLine);
        }
    }

    public void dataChanged(PlugInEvent data) {
    }

    public void setDecimalPoint(char dp) {
        if (this.activeSynapse != null) {
            this.activeSynapse.setDecimalPoint(dp);
        }
    }

    public boolean isEOF() {
        if (this.activeSynapse != null) {
            return this.activeSynapse.isEOF();
        }
        return false;
    }

    public void readAll() {
        if (this.activeSynapse != null) {
            this.activeSynapse.readAll();
        }
    }

    public void setBuffered(boolean newBuffered) {
        if (this.activeSynapse != null) {
            this.activeSynapse.setBuffered(newBuffered);
        }
    }

    public boolean isBuffered() {
        if (this.activeSynapse != null) {
            return this.activeSynapse.isBuffered();
        }
        return false;
    }

    public ConverterPlugIn getPlugIn() {
        if (this.activeSynapse != null) {
            return this.activeSynapse.getPlugIn();
        }
        return null;
    }

    public boolean isStepCounter() {
        if (this.activeSynapse != null) {
            return this.activeSynapse.isStepCounter();
        }
        return false;
    }

    public void gotoFirstLine() throws IOException {
        if (this.activeSynapse != null) {
            this.activeSynapse.gotoFirstLine();
        }
    }

    public void removeAllInputs() {
        int i = 0;
        while (i < this.inputs.size()) {
            StreamInputSynapse inp = (StreamInputSynapse)this.inputs.elementAt(i);
            inp.setInputFull(false);
            ++i;
        }
        this.initSwitch();
    }

    public TreeSet check() {
        TreeSet checks = new TreeSet();
        int i = 0;
        while (i < this.inputs.size()) {
            StreamInputSynapse inp = (StreamInputSynapse)this.inputs.elementAt(i);
            checks.addAll(inp.check());
            ++i;
        }
        return checks;
    }

    public int getFirstRow() {
        if (this.activeSynapse != null) {
            return this.activeSynapse.getFirstRow();
        }
        return 0;
    }

    public int getLastRow() {
        if (this.activeSynapse != null) {
            return this.activeSynapse.getLastRow();
        }
        return 0;
    }

    public Collection getInspections() {
        if (this.activeSynapse != null) {
            return this.activeSynapse.Inspections();
        }
        return null;
    }

    public int numColumns() {
        if (this.activeSynapse != null) {
            return this.activeSynapse.numColumns();
        }
        return 0;
    }

    public String getAdvancedColumnSelector() {
        if (this.activeSynapse != null) {
            return this.activeSynapse.getAdvancedColumnSelector();
        }
        return "";
    }
}

