/*
 * Decompiled with CFR 0.152.
 */
package org.joone.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.TreeSet;
import org.joone.engine.NetErrorManager;
import org.joone.exception.JooneRuntimeException;
import org.joone.io.StreamInputSynapse;
import org.joone.io.StreamInputTokenizer;
import org.joone.log.ILogger;
import org.joone.log.LoggerFactory;
import org.joone.net.NetCheck;

public class FileInputSynapse
extends StreamInputSynapse {
    private static final ILogger log = LoggerFactory.getLogger(FileInputSynapse.class);
    private static final long serialVersionUID = 7456627292136514416L;
    private String fileName = "";
    private transient File inputFile;

    public String getFileName() {
        return this.fileName;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        super.readObjectBase(in);
        if (in.getClass().getName().indexOf("xstream") == -1) {
            this.fileName = (String)in.readObject();
        }
        if (this.fileName != null && this.fileName.length() > 0) {
            this.inputFile = new File(this.fileName);
        }
    }

    public void setFileName(String newFileName) {
        if (!this.fileName.equals(newFileName)) {
            this.fileName = newFileName;
            this.resetInput();
            super.setTokens(null);
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        super.writeObjectBase(out);
        if (out.getClass().getName().indexOf("xstream") == -1) {
            out.writeObject(this.fileName);
        }
    }

    protected void initInputStream() throws JooneRuntimeException {
        block3: {
            if (this.fileName != null && !this.fileName.equals(new String(""))) {
                try {
                    this.inputFile = new File(this.fileName);
                    FileInputStream fis = new FileInputStream(this.inputFile);
                    StreamInputTokenizer sit = this.getMaxBufSize() > 0 ? new StreamInputTokenizer(new InputStreamReader(fis), this.getMaxBufSize()) : new StreamInputTokenizer(new InputStreamReader(fis));
                    super.setTokens(sit);
                }
                catch (IOException ioe) {
                    String error = "IOException in " + this.getName() + ". Message is : ";
                    log.warn(String.valueOf(error) + ioe.getMessage());
                    if (this.getMonitor() == null) break block3;
                    new NetErrorManager(this.getMonitor(), String.valueOf(error) + ioe.getMessage());
                }
            }
        }
    }

    public TreeSet check() {
        TreeSet checks = super.check();
        if (this.fileName == null || this.fileName.trim().equals("")) {
            checks.add(new NetCheck(0, "File Name not set.", this));
        } else if (!this.getInputFile().exists()) {
            NetCheck error = new NetCheck(1, "Input File doesn't exist.", this);
            if (this.getInputPatterns().isEmpty()) {
                error.setSeverity(0);
            }
            checks.add(error);
        }
        return checks;
    }

    public File getInputFile() {
        return this.inputFile;
    }

    public void setInputFile(File inputFile) {
        if (inputFile != null) {
            if (!this.fileName.equals(inputFile.getAbsolutePath())) {
                this.inputFile = inputFile;
                this.fileName = inputFile.getAbsolutePath();
                this.resetInput();
                super.setTokens(null);
            }
        } else {
            this.inputFile = inputFile;
            this.fileName = "";
            this.resetInput();
            super.setTokens(null);
        }
    }
}

