/*
 * Decompiled with CFR 0.152.
 */
package org.joone.inspection.implementations;

import org.joone.engine.Matrix;
import org.joone.inspection.Inspection;

public class BiasInspection
implements Inspection {
    private Matrix bias;

    public BiasInspection(Matrix biasArg) {
        this.bias = biasArg;
    }

    public Object[][] getComponent() {
        if (this.bias == null) {
            return null;
        }
        double[][] values = this.bias.getValue();
        if (values.length > 0 && values[0].length > 0) {
            Object[][] bigValues = new Object[values.length][values[0].length];
            int i = 0;
            while (i < values[0].length) {
                int j = 0;
                while (j < values.length) {
                    bigValues[j][i] = new Double(values[j][i]);
                    ++j;
                }
                ++i;
            }
            return bigValues;
        }
        return null;
    }

    public Object[] getNames() {
        if (this.bias == null) {
            return null;
        }
        double[][] values = this.bias.getValue();
        if (values.length > 0 && values[0].length > 0) {
            Object[] names = new String[values[0].length];
            int i = 0;
            while (i < values[0].length) {
                names[i] = "Column " + i;
                ++i;
            }
            return names;
        }
        return null;
    }

    public String getTitle() {
        return "Bias";
    }

    public boolean rowNumbers() {
        return false;
    }

    public void setComponent(Object[][] newValues) {
        double[][] values = this.bias.getValue();
        int x = 0;
        while (x < values.length && x < newValues.length) {
            int y = 0;
            while (y < values[0].length && y < newValues[0].length) {
                values[x][y] = (Double)newValues[x][y];
                ++y;
            }
            ++x;
        }
    }
}

