/*
 * Decompiled with CFR 0.152.
 */
package org.joone.helpers.structure;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.joone.engine.InputPatternListener;
import org.joone.engine.Layer;
import org.joone.engine.Monitor;
import org.joone.engine.OutputPatternListener;
import org.joone.engine.Synapse;
import org.joone.helpers.structure.Connection;
import org.joone.net.NeuralNet;

public class NeuralNetMatrix {
    private ArrayList layers;
    private ArrayList connectionSet;
    private Monitor monitor;
    private Layer inputLayer = null;
    private Layer outputLayer = null;
    private int inputLayerInd = -1;
    private int outputLayerInd = -1;
    transient Hashtable synTemp;
    int[] translation = null;

    public NeuralNetMatrix() {
    }

    public NeuralNetMatrix(NeuralNet net) {
        this.setNeuralNet(net);
    }

    public void setNeuralNet(NeuralNet net) {
        int n = net.getLayers().size();
        this.inputLayer = net.findInputLayer();
        this.outputLayer = net.findOutputLayer();
        this.monitor = net.getMonitor();
        this.layers = new ArrayList(net.getLayers());
        this.synTemp = new Hashtable();
        int i = 0;
        while (i < n) {
            Layer ly = (Layer)this.layers.get(i);
            this.checkInputs(i, ly);
            this.checkOutputs(i, ly);
            ++i;
        }
        Enumeration enumerat = this.synTemp.keys();
        this.connectionSet = new ArrayList();
        while (enumerat.hasMoreElements()) {
            int y;
            Object key = enumerat.nextElement();
            Connection tsyn = (Connection)this.synTemp.get(key);
            int x = tsyn.getInput();
            if (x * (y = tsyn.getOutput()) <= 0) continue;
            this.connectionSet.add(tsyn);
        }
    }

    public Synapse[][] getConnectionMatrix() {
        Synapse[][] connectionMatrix = new Synapse[this.layers.size()][this.layers.size()];
        int n = 0;
        while (n < this.connectionSet.size()) {
            Connection tsyn = (Connection)this.connectionSet.get(n);
            int x = tsyn.getInput();
            int y = tsyn.getOutput();
            connectionMatrix[x - 1][y - 1] = tsyn.getSynapse();
            ++n;
        }
        return connectionMatrix;
    }

    public boolean isThereAnyPath(Layer fromLayer, Layer toLayer) {
        boolean retValue = false;
        int iFrom = this.getLayerInd(fromLayer);
        int iTo = this.getLayerInd(toLayer);
        retValue = this.isThereAnyPath(iFrom, iTo, this.getConnectionMatrix());
        return retValue;
    }

    private boolean isThereAnyPath(int iFrom, int iTo, Synapse[][] matrix) {
        boolean retValue = false;
        int t = 0;
        while (t < this.layers.size() && !retValue) {
            Synapse conn = matrix[iFrom][t];
            if (conn != null && !conn.isLoopBack()) {
                retValue = t == iTo ? true : this.isThereAnyPath(t, iTo, matrix);
            }
            ++t;
        }
        return retValue;
    }

    public Synapse[][] getOrderedConnectionMatrix() {
        this.getOrderedLayers();
        Synapse[][] connectionMatrix = new Synapse[this.layers.size()][this.layers.size()];
        int n = 0;
        while (n < this.connectionSet.size()) {
            Connection tsyn = (Connection)this.connectionSet.get(n);
            int x = tsyn.getInput();
            int y = tsyn.getOutput();
            connectionMatrix[this.translation[x - 1]][this.translation[y - 1]] = tsyn.getSynapse();
            ++n;
        }
        return connectionMatrix;
    }

    public boolean[][] getBinaryOrderedConnectionMatrix() {
        this.getOrderedLayers();
        boolean[][] booleanConnectionMatrix = new boolean[this.layers.size()][this.layers.size()];
        int n = 0;
        while (n < this.connectionSet.size()) {
            Connection tsyn = (Connection)this.connectionSet.get(n);
            int x = tsyn.getInput();
            int y = tsyn.getOutput();
            booleanConnectionMatrix[this.translation[x - 1]][this.translation[y - 1]] = true;
            ++n;
        }
        return booleanConnectionMatrix;
    }

    public Layer[] getOrderedLayers() {
        Synapse[][] connMatrix = this.getConnectionMatrix();
        if (connMatrix == null) {
            return null;
        }
        int[] ord = new int[this.layers.size()];
        ArrayList inputLayers = this.getInputLayers(connMatrix);
        int i = 0;
        while (i < inputLayers.size()) {
            int ind = (Integer)inputLayers.get(i);
            ord[ind] = 1;
            ++i;
        }
        boolean changed = this.assignOrderToLayers(ord, connMatrix);
        while (changed) {
            changed = this.assignOrderToLayers(ord, connMatrix);
        }
        this.translation = new int[this.layers.size()];
        Layer[] ordLayers = new Layer[this.layers.size()];
        int n = 1;
        int d = 0;
        while (d < this.layers.size()) {
            int x = 0;
            while (x < ord.length) {
                if (ord[x] == n) {
                    ordLayers[d] = (Layer)this.layers.get(x);
                    this.translation[x] = d++;
                }
                ++x;
            }
            ++n;
        }
        return ordLayers;
    }

    private boolean assignOrderToLayers(int[] ord, Synapse[][] connMatrix) {
        boolean changed = false;
        int x = 0;
        while (x < ord.length) {
            int currLayer = ord[x];
            if (currLayer > 0) {
                int y = 0;
                while (y < connMatrix[x].length) {
                    if (connMatrix[x][y] != null && !connMatrix[x][y].isLoopBack() && currLayer >= ord[y]) {
                        ord[y] = currLayer + 1;
                        changed = true;
                    }
                    ++y;
                }
            }
            ++x;
        }
        return changed;
    }

    public ArrayList getInputLayers(Synapse[][] connMatrix) {
        ArrayList<Integer> inputs = new ArrayList<Integer>();
        int y = 0;
        while (y < connMatrix.length) {
            boolean found = false;
            int x = 0;
            while (x < connMatrix[y].length) {
                if (connMatrix[x][y] != null && !connMatrix[x][y].isLoopBack()) {
                    found = true;
                    break;
                }
                ++x;
            }
            if (!found) {
                inputs.add(new Integer(y));
            }
            ++y;
        }
        return inputs;
    }

    public Serializable cloneElement(Serializable element) {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(bos);
            out.writeObject(element);
            out.close();
            byte[] buf = bos.toByteArray();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buf));
            Object theCLone = in.readObject();
            in.close();
            return (Serializable)theCLone;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        return null;
    }

    private void checkInputs(int n, Layer ly) {
        Vector inps = ly.getAllInputs();
        if (inps == null) {
            return;
        }
        int i = 0;
        while (i < inps.size()) {
            InputPatternListener ipl = (InputPatternListener)inps.elementAt(i);
            if (ipl != null && ipl instanceof Synapse) {
                Connection temp = this.getSynapse((Synapse)ipl);
                temp.setOutput(n + 1);
                temp.setOutIndex(i);
            }
            ++i;
        }
    }

    private void checkOutputs(int n, Layer ly) {
        Vector outs = ly.getAllOutputs();
        if (outs == null) {
            return;
        }
        int i = 0;
        while (i < outs.size()) {
            OutputPatternListener opl = (OutputPatternListener)outs.elementAt(i);
            if (opl != null && opl instanceof Synapse) {
                Connection temp = this.getSynapse((Synapse)opl);
                temp.setInput(n + 1);
                temp.setInpIndex(i);
            }
            ++i;
        }
    }

    private Connection getSynapse(Synapse s) {
        Connection temp = (Connection)this.synTemp.get(s);
        if (temp == null) {
            temp = new Connection();
            temp.setSynapse(s);
            this.synTemp.put(s, temp);
        }
        return temp;
    }

    public ArrayList getLayers() {
        return this.layers;
    }

    public void setLayers(ArrayList layers) {
        this.layers = layers;
    }

    public ArrayList getConnectionSet() {
        return this.connectionSet;
    }

    public void setConnectionSet(ArrayList connectionSet) {
        this.connectionSet = connectionSet;
    }

    public Monitor getMonitor() {
        return this.monitor;
    }

    public void setMonitor(Monitor monitor) {
        this.monitor = monitor;
    }

    public Layer getInputLayer() {
        return this.inputLayer;
    }

    public void setInputLayer(Layer inputLayer) {
        this.inputLayer = inputLayer;
    }

    public Layer getOutputLayer() {
        return this.outputLayer;
    }

    public void setOutputLayer(Layer outputLayer) {
        this.outputLayer = outputLayer;
    }

    public int getNumLayers() {
        return this.layers.size();
    }

    public int getInputLayerInd() {
        if (this.inputLayerInd == -1) {
            this.inputLayerInd = this.getLayerInd(this.inputLayer);
        }
        return this.inputLayerInd;
    }

    public int getOutputLayerInd() {
        if (this.outputLayerInd == -1) {
            this.outputLayerInd = this.getLayerInd(this.outputLayer);
        }
        return this.outputLayerInd;
    }

    public int getLayerInd(Layer layer) {
        int layerInd = -1;
        int i = 0;
        while (i < this.layers.size()) {
            Layer ly = (Layer)this.layers.get(i);
            if (ly == layer) {
                layerInd = i;
                break;
            }
            ++i;
        }
        return layerInd;
    }
}

