/*
 * Decompiled with CFR 0.152.
 */
package org.joone.engine.listeners;

import org.joone.engine.Layer;
import org.joone.engine.Matrix;
import org.joone.engine.Monitor;
import org.joone.engine.Synapse;
import org.joone.engine.listeners.ConvergenceObserver;
import org.joone.net.NeuralNet;

public class DeltaBasedConvergenceObserver
extends ConvergenceObserver {
    private double size = 0.0;
    private int cycles = 5;
    private int cycleCounter = 0;
    private NeuralNet net;

    public void setSize(double aSize) {
        this.size = aSize;
    }

    public double getSize() {
        return this.size;
    }

    public void setCycles(int aCylces) {
        this.cycles = aCylces;
    }

    public int getCycles() {
        return this.cycles;
    }

    public void setNeuralNet(NeuralNet aNet) {
        this.net = aNet;
    }

    public NeuralNet getNeuralNet() {
        return this.net;
    }

    protected void manageStop(Monitor mon) {
    }

    protected void manageCycle(Monitor mon) {
    }

    protected void manageStart(Monitor mon) {
    }

    protected void manageError(Monitor mon) {
        if (this.cycles <= 0) {
            return;
        }
        int i = 0;
        while (i < this.net.getLayers().size()) {
            Layer myLayer = (Layer)this.net.getLayers().get(i);
            Matrix myBiases = myLayer.getBias();
            int b = 0;
            while (b < myBiases.getM_rows()) {
                if (myBiases != null && !this.isConvergence(myBiases)) {
                    this.cycleCounter = 0;
                    this.disableCurrentConvergence = false;
                    return;
                }
                ++b;
            }
            int s = 0;
            while (s < myLayer.getAllOutputs().size()) {
                Matrix myWeights;
                if (myLayer.getAllOutputs().get(s) instanceof Synapse && (myWeights = ((Synapse)myLayer.getAllOutputs().get(s)).getWeights()) != null && !this.isConvergence(myWeights)) {
                    this.cycleCounter = 0;
                    this.disableCurrentConvergence = false;
                    return;
                }
                ++s;
            }
            ++i;
        }
        ++this.cycleCounter;
        if (this.cycleCounter == this.cycles) {
            if (!this.disableCurrentConvergence) {
                this.fireNetConverged(mon);
            }
            this.cycleCounter = 0;
        }
    }

    protected boolean isConvergence(Matrix aMatrix) {
        int r = 0;
        while (r < aMatrix.getM_rows()) {
            int c = 0;
            while (c < aMatrix.getM_cols()) {
                if (Math.abs(aMatrix.delta[r][c]) > this.size) {
                    return false;
                }
                ++c;
            }
            ++r;
        }
        return true;
    }

    protected void manageStopError(Monitor mon, String msgErr) {
    }
}

