/*
 * Decompiled with CFR 0.152.
 */
package org.joone.engine.extenders;

import org.joone.engine.Matrix;
import org.joone.engine.extenders.UpdateWeightExtender;

public class BatchModeExtender
extends UpdateWeightExtender {
    private int theBatchSize = -1;
    private int theRows = -1;
    private int theColumns = -1;
    private Matrix theMatrix;
    private int theCounter = 0;

    public void postBiasUpdate(double[] currentGradientOuts) {
        if (this.storeWeightsBiases()) {
            int x = 0;
            while (x < this.theRows) {
                double[] dArray = this.theMatrix.value[x];
                dArray[0] = dArray[0] + this.theMatrix.delta[x][0];
                ++x;
            }
            this.getLearner().getLayer().setBias((Matrix)this.theMatrix.clone());
            this.resetDelta(this.theMatrix);
            this.theCounter = 0;
        }
    }

    public void postWeightUpdate(double[] currentPattern, double[] currentInps) {
        if (this.storeWeightsBiases()) {
            int x = 0;
            while (x < this.theRows) {
                int y = 0;
                while (y < this.theColumns) {
                    double[] dArray = this.theMatrix.value[x];
                    int n = y;
                    dArray[n] = dArray[n] + this.theMatrix.delta[x][y];
                    ++y;
                }
                ++x;
            }
            this.getLearner().getSynapse().setWeights((Matrix)this.theMatrix.clone());
            this.resetDelta(this.theMatrix);
            this.theCounter = 0;
        }
    }

    public void preBiasUpdate(double[] currentGradientOuts) {
        if (this.theRows != this.getLearner().getLayer().getRows()) {
            this.initiateNewBatch();
        }
        ++this.theCounter;
    }

    public void preWeightUpdate(double[] currentPattern, double[] currentInps) {
        if (this.theRows != this.getLearner().getSynapse().getInputDimension() || this.theColumns != this.getLearner().getSynapse().getOutputDimension()) {
            this.initiateNewBatch();
        }
        ++this.theCounter;
    }

    public void updateBias(int i, double aDelta) {
        double[] dArray = this.theMatrix.delta[i];
        dArray[0] = dArray[0] + aDelta;
    }

    public void updateWeight(int j, int k, double aDelta) {
        double[] dArray = this.theMatrix.delta[j];
        int n = k;
        dArray[n] = dArray[n] + aDelta;
    }

    protected void resetDelta(Matrix aMatrix) {
        int r = 0;
        while (r < aMatrix.delta.length) {
            int c = 0;
            while (c < aMatrix.delta[0].length) {
                aMatrix.delta[r][c] = 0.0;
                ++c;
            }
            ++r;
        }
    }

    protected void initiateNewBatch() {
        if (this.getLearner().getLayer() != null) {
            this.theRows = this.getLearner().getLayer().getRows();
            this.theMatrix = (Matrix)this.getLearner().getLayer().getBias().clone();
        } else if (this.getLearner().getSynapse() != null) {
            this.theRows = this.getLearner().getSynapse().getInputDimension();
            this.theColumns = this.getLearner().getSynapse().getOutputDimension();
            this.theMatrix = (Matrix)this.getLearner().getSynapse().getWeights().clone();
        }
        this.resetDelta(this.theMatrix);
        this.theCounter = 0;
    }

    public void setBatchSize(int aBatchSize) {
        this.theBatchSize = aBatchSize;
    }

    public int getBatchSize() {
        if (this.theBatchSize < 0) {
            return this.getLearner().getMonitor().getBatchSize();
        }
        return this.theBatchSize;
    }

    public boolean storeWeightsBiases() {
        return this.theCounter >= this.getBatchSize();
    }
}

