/*
 * Decompiled with CFR 0.152.
 */
package org.joone.engine;

import org.joone.engine.LearnableLayer;
import org.joone.engine.Learner;
import org.joone.engine.SimpleLayer;
import org.joone.exception.JooneRuntimeException;
import org.joone.log.ILogger;
import org.joone.log.LoggerFactory;

public class SigmoidLayer
extends SimpleLayer
implements LearnableLayer {
    private static final ILogger log = LoggerFactory.getLogger(SigmoidLayer.class);
    private static final long serialVersionUID = -8700747963164046048L;
    private double flatSpotConstant = 0.0;

    public SigmoidLayer() {
        this.learnable = true;
    }

    public SigmoidLayer(String ElemName) {
        this();
        this.setLayerName(ElemName);
    }

    public void backward(double[] pattern) throws JooneRuntimeException {
        super.backward(pattern);
        int n = this.getRows();
        int x = 0;
        while (x < n) {
            this.gradientOuts[x] = pattern[x] * (this.outs[x] * (1.0 - this.outs[x]) + this.getFlatSpotConstant());
            ++x;
        }
        this.myLearner.requestBiasUpdate(this.gradientOuts);
    }

    public void forward(double[] pattern) throws JooneRuntimeException {
        int x = 0;
        int n = this.getRows();
        try {
            x = 0;
            while (x < n) {
                double in = pattern[x] + this.bias.value[x][0];
                this.outs[x] = 1.0 / (1.0 + Math.exp(-in));
                ++x;
            }
        }
        catch (Exception aioobe) {
            String msg = "Exception thrown while processing the element " + x + " of the array. Value is : " + pattern[x] + " Exception thrown is " + aioobe.getClass().getName() + ". Message is " + aioobe.getMessage();
            log.error(msg);
            throw new JooneRuntimeException(msg, aioobe);
        }
    }

    public Learner getLearner() {
        this.learnable = true;
        return super.getLearner();
    }

    public void setFlatSpotConstant(double aConstant) {
        this.flatSpotConstant = aConstant;
    }

    public double getFlatSpotConstant() {
        return this.flatSpotConstant;
    }
}

