/*
 * Decompiled with CFR 0.152.
 */
package org.joone.engine;

import java.util.ArrayList;
import java.util.Collection;
import org.joone.engine.RbfGaussianParameters;
import org.joone.engine.RbfLayer;
import org.joone.exception.JooneRuntimeException;
import org.joone.inspection.implementations.BiasInspection;
import org.joone.io.StreamInputSynapse;
import org.joone.log.ILogger;
import org.joone.log.LoggerFactory;
import org.joone.util.ConverterPlugIn;
import org.joone.util.RbfRandomCenterSelector;

public class RbfGaussianLayer
extends RbfLayer {
    private static final ILogger log = LoggerFactory.getLogger(RbfGaussianLayer.class);
    private RbfGaussianParameters[] theGaussianParameters;
    private boolean theUseRandomSelector = true;
    private RbfRandomCenterSelector theRandomSelector;

    protected void backward(double[] pattern) throws JooneRuntimeException {
        int i = 0;
        while (i < this.gradientInps.length) {
            this.gradientOuts[i] = this.gradientInps[i];
            ++i;
        }
    }

    protected void forward(double[] pattern) throws JooneRuntimeException {
        if (this.theUseRandomSelector && this.theGaussianParameters == null) {
            this.setGaussianParameters(this.theRandomSelector.getGaussianParameters());
        }
        int i = 0;
        try {
            i = 0;
            while (i < this.getRows()) {
                double mySquaredEuclDist = 0.0;
                int j = 0;
                while (j < pattern.length) {
                    double myTemp = pattern[j] - this.theGaussianParameters[i].getMean()[j];
                    mySquaredEuclDist += myTemp * myTemp;
                    ++j;
                }
                this.outs[i] = Math.exp(mySquaredEuclDist / (-2.0 * this.theGaussianParameters[i].getStdDeviation() * this.theGaussianParameters[i].getStdDeviation()));
                ++i;
            }
        }
        catch (Exception aioobe) {
            aioobe.printStackTrace();
            String msg = "Exception thrown while processing the element " + i + " of the array. Value is : " + pattern[i] + " Exception thrown is " + aioobe.getClass().getName() + ". Message is " + aioobe.getMessage();
            log.error(msg);
            throw new JooneRuntimeException(msg, aioobe);
        }
    }

    protected void setDimensions() {
        super.setDimensions();
        this.gradientOuts = new double[this.gradientInps.length];
    }

    public RbfGaussianParameters[] getGaussianParameters() {
        return this.theGaussianParameters;
    }

    public void setGaussianParameters(RbfGaussianParameters[] aGaussianParameters) {
        if (aGaussianParameters.length != this.getRows()) {
            this.setRows(aGaussianParameters.length);
            log.warn("Setting new RBF Gaussian parameters -> # neurons changed.");
        }
        this.theGaussianParameters = aGaussianParameters;
    }

    public void useRandomCenter(StreamInputSynapse aStreamInput) {
        this.theUseRandomSelector = true;
        this.theRandomSelector = new RbfRandomCenterSelector(this);
        if (aStreamInput.getPlugIn() == null) {
            aStreamInput.setPlugIn(this.theRandomSelector);
        } else {
            ConverterPlugIn myPlugin = aStreamInput.getPlugIn();
            myPlugin.addPlugIn(this.theRandomSelector);
        }
    }

    public Collection Inspections() {
        ArrayList<BiasInspection> col = new ArrayList<BiasInspection>();
        col.add(new BiasInspection(null));
        return col;
    }
}

