/*
 * Decompiled with CFR 0.152.
 */
package org.joone.engine;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.TreeSet;
import org.joone.engine.Layer;
import org.joone.engine.OutputPatternListener;

public abstract class MemoryLayer
extends Layer {
    protected double[] memory;
    protected double[] backmemory;
    private int taps = 0;
    private static final long serialVersionUID = 5447777678414684948L;

    public MemoryLayer() {
    }

    public MemoryLayer(String ElemName) {
        super(ElemName);
    }

    public int getDimension() {
        return this.getRows() * (this.getTaps() + 1);
    }

    public int getTaps() {
        return this.taps;
    }

    protected void setDimensions() {
        this.inps = new double[this.getRows()];
        this.outs = new double[this.getRows() * (this.getTaps() + 1)];
        this.gradientInps = new double[this.getRows() * (this.getTaps() + 1)];
        this.gradientOuts = new double[this.getRows()];
        this.memory = new double[this.getRows() * (this.getTaps() + 1)];
        this.backmemory = new double[this.getRows() * (this.getTaps() + 1)];
    }

    protected void setOutputDimension(OutputPatternListener syn) {
        int n = this.getRows() * (this.getTaps() + 1);
        if (syn.getInputDimension() != n) {
            syn.setInputDimension(n);
        }
    }

    public void setTaps(int newTaps) {
        this.taps = newTaps;
        this.setDimensions();
        this.setConnDimensions();
    }

    protected void sumBackInput(double[] pattern) {
        int length = this.getRows() * (this.getTaps() + 1);
        int x = 0;
        while (x < length) {
            int n = x;
            this.gradientInps[n] = this.gradientInps[n] + pattern[x];
            ++x;
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.setDimensions();
    }

    protected void backward(double[] pattern) {
    }

    protected void forward(double[] pattern) {
    }

    public TreeSet check() {
        return super.check();
    }
}

