/*
 * Decompiled with CFR 0.152.
 */
package org.joone.engine;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Random;
import org.joone.engine.weights.RandomWeightInitializer;
import org.joone.engine.weights.WeightInitializer;
import org.joone.log.ILogger;
import org.joone.log.LoggerFactory;

public class Matrix
implements Serializable,
Cloneable {
    private static final ILogger log = LoggerFactory.getLogger(Matrix.class);
    public static final double DEFAULT_INITIAL = 0.2;
    private static final long serialVersionUID = -1392966842649908366L;
    public double[][] value;
    public double[][] delta;
    public boolean[][] enabled;
    public boolean[][] fixed;
    protected int m_rows;
    protected int m_cols;
    private Random random = new Random(1998L);
    protected WeightInitializer weightInitializer;

    public Matrix() {
    }

    public Matrix(int aRows, int aColumns) {
        this(aRows, aColumns, 0.2);
    }

    public Matrix(int aRows, int aColumns, double anInitial) {
        this.value = new double[aRows][aColumns];
        this.delta = new double[aRows][aColumns];
        this.enabled = new boolean[aRows][aColumns];
        this.fixed = new boolean[aRows][aColumns];
        this.m_rows = aRows;
        this.m_cols = aColumns;
        if (anInitial == 0.0) {
            this.enableAll();
            this.unfixAll();
            this.setWeightInitializer(new RandomWeightInitializer(0.0), false);
            this.clear();
        } else {
            this.enableAll();
            this.unfixAll();
            this.setWeightInitializer(new RandomWeightInitializer(anInitial));
        }
    }

    public void initialize() {
        this.getWeightInitializer().initialize(this);
    }

    public void setWeightInitializer(WeightInitializer aWeightInitializer) {
        this.setWeightInitializer(aWeightInitializer, true);
    }

    public void setWeightInitializer(WeightInitializer aWeightInitializer, boolean anInitialize) {
        this.weightInitializer = aWeightInitializer;
        if (anInitialize) {
            this.getWeightInitializer().initialize(this);
        }
    }

    public WeightInitializer getWeightInitializer() {
        if (this.weightInitializer == null) {
            this.weightInitializer = new RandomWeightInitializer(0.2);
        }
        return this.weightInitializer;
    }

    public Object clone() {
        Matrix o = null;
        try {
            o = (Matrix)super.clone();
        }
        catch (CloneNotSupportedException e) {
            log.error("Matrix can't clone", e);
        }
        o.value = (double[][])o.value.clone();
        o.delta = (double[][])o.delta.clone();
        o.enabled = (boolean[][])o.enabled.clone();
        o.fixed = (boolean[][])o.fixed.clone();
        int x = 0;
        while (x < this.m_rows) {
            o.value[x] = (double[])o.value[x].clone();
            o.delta[x] = (double[])o.delta[x].clone();
            o.enabled[x] = (boolean[])o.enabled[x].clone();
            o.fixed[x] = (boolean[])o.fixed[x].clone();
            ++x;
        }
        return o;
    }

    public void addNoise(double amplitude) {
        int x = 0;
        while (x < this.m_rows) {
            int y = 0;
            while (y < this.m_cols) {
                if (this.enabled[x][y] && !this.fixed[x][y]) {
                    double[] dArray = this.value[x];
                    int n = y;
                    dArray[n] = dArray[n] + (-amplitude + this.random.nextDouble() * (2.0 * amplitude));
                }
                ++y;
            }
            ++x;
        }
    }

    public void removeRow(int aRow) {
        double[][] myValue = new double[this.m_rows - 1][];
        double[][] myDelta = new double[this.m_rows - 1][];
        boolean[][] myEnabled = new boolean[this.m_rows - 1][];
        boolean[][] myFixed = new boolean[this.m_rows - 1][];
        int x = 0;
        while (x < this.m_rows) {
            if (x < aRow) {
                myValue[x] = (double[])this.value[x].clone();
                myDelta[x] = (double[])this.delta[x].clone();
                myEnabled[x] = (boolean[])this.enabled[x].clone();
                myFixed[x] = (boolean[])this.fixed[x].clone();
            } else if (x > aRow) {
                myValue[x - 1] = (double[])this.value[x].clone();
                myDelta[x - 1] = (double[])this.delta[x].clone();
                myEnabled[x - 1] = (boolean[])this.enabled[x].clone();
                myFixed[x - 1] = (boolean[])this.fixed[x].clone();
            }
            ++x;
        }
        this.value = myValue;
        this.delta = myDelta;
        this.enabled = myEnabled;
        this.fixed = myFixed;
        --this.m_rows;
    }

    public void removeColumn(int aColumn) {
        double[][] myValue = new double[this.m_rows][this.m_cols - 1];
        double[][] myDelta = new double[this.m_rows][this.m_cols - 1];
        boolean[][] myEnabled = new boolean[this.m_rows][this.m_cols - 1];
        boolean[][] myFixed = new boolean[this.m_rows][this.m_cols - 1];
        int x = 0;
        while (x < this.m_rows) {
            int y = 0;
            while (y < this.m_cols) {
                if (y < aColumn) {
                    myValue[x][y] = this.value[x][y];
                    myDelta[x][y] = this.delta[x][y];
                    myEnabled[x][y] = this.enabled[x][y];
                    myFixed[x][y] = this.fixed[x][y];
                } else if (y > aColumn) {
                    myValue[x][y - 1] = this.value[x][y];
                    myDelta[x][y - 1] = this.delta[x][y];
                    myEnabled[x][y - 1] = this.enabled[x][y];
                    myFixed[x][y - 1] = this.fixed[x][y];
                }
                ++y;
            }
            ++x;
        }
        this.value = myValue;
        this.delta = myDelta;
        this.enabled = myEnabled;
        this.fixed = myFixed;
        --this.m_cols;
    }

    public void clear() {
        int x = 0;
        while (x < this.m_rows) {
            int y = 0;
            while (y < this.m_cols) {
                if (this.enabled[x][y] || !this.fixed[x][y]) {
                    this.value[x][y] = 0.0;
                    this.delta[x][y] = 0.0;
                }
                ++y;
            }
            ++x;
        }
    }

    public void enableAll() {
        int x = 0;
        while (x < this.m_rows) {
            int y = 0;
            while (y < this.m_cols) {
                this.enabled[x][y] = true;
                ++y;
            }
            ++x;
        }
    }

    public void disableAll() {
        int x = 0;
        while (x < this.m_rows) {
            int y = 0;
            while (y < this.m_cols) {
                this.enabled[x][y] = false;
                ++y;
            }
            ++x;
        }
    }

    public void fixAll() {
        int x = 0;
        while (x < this.m_rows) {
            int y = 0;
            while (y < this.m_cols) {
                this.fixed[x][y] = true;
                ++y;
            }
            ++x;
        }
    }

    public void unfixAll() {
        int x = 0;
        while (x < this.m_rows) {
            int y = 0;
            while (y < this.m_cols) {
                this.fixed[x][y] = false;
                ++y;
            }
            ++x;
        }
    }

    public int getM_rows() {
        return this.m_rows;
    }

    public void setM_rows(int newm_rows) {
        this.m_rows = newm_rows;
    }

    public int getM_cols() {
        return this.m_cols;
    }

    public void setM_cols(int newm_cols) {
        this.m_cols = newm_cols;
    }

    public double[][] getDelta() {
        return this.delta;
    }

    public void setDelta(double[][] newdelta) {
        this.delta = newdelta;
    }

    public double[][] getValue() {
        return this.value;
    }

    public void setValue(double[][] newvalue) {
        this.value = newvalue;
    }

    public boolean[][] getFixed() {
        return this.fixed;
    }

    public void setFixed(boolean[][] newfixed) {
        this.fixed = newfixed;
    }

    public boolean[][] getEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean[][] newenabled) {
        this.enabled = newenabled;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.enabled == null) {
            this.enabled = new boolean[this.m_rows][this.m_cols];
            this.enableAll();
        }
        if (this.fixed == null) {
            this.fixed = new boolean[this.m_rows][this.m_cols];
            this.unfixAll();
        }
    }
}

