/*
 * Decompiled with CFR 0.152.
 */
package org.joone.engine;

import java.util.ArrayList;
import java.util.Collection;
import java.util.TreeSet;
import org.joone.engine.GaussianSpatialMap;
import org.joone.engine.NeuralNetEvent;
import org.joone.engine.NeuralNetListener;
import org.joone.engine.SimpleLayer;
import org.joone.engine.SpatialMap;
import org.joone.exception.JooneRuntimeException;
import org.joone.inspection.implementations.BiasInspection;
import org.joone.log.ILogger;
import org.joone.log.LoggerFactory;
import org.joone.net.NetCheck;

public class GaussianLayer
extends SimpleLayer
implements NeuralNetListener {
    private static final ILogger log = LoggerFactory.getLogger(GaussianLayer.class);
    private static final long serialVersionUID = -941653911909171430L;
    private int LayerWidth = 1;
    private int LayerHeight = 1;
    private int LayerDepth = 1;
    private SpatialMap space_map;
    private double timeConstant = 200.0;
    private int orderingPhase = 1000;
    private double initialGaussianSize = 10.0;

    public GaussianLayer() {
    }

    public GaussianLayer(String ElemName) {
        super(ElemName);
    }

    public void backward(double[] pattern) throws JooneRuntimeException {
    }

    public void forward(double[] pattern) throws JooneRuntimeException {
        try {
            this.getSpace_map().ApplyNeighborhoodFunction(pattern, this.outs, this.getMonitor().isLearning());
        }
        catch (Exception aioobe) {
            String msg = "Exception thrown while processing the pattern " + pattern.toString() + " Exception thrown is " + aioobe.getClass().getName() + ". Message is " + aioobe.getMessage();
            log.error(msg);
            throw new JooneRuntimeException(msg, aioobe);
        }
    }

    public int getLayerDepth() {
        return this.LayerDepth;
    }

    public void setLayerDepth(int layerDepth) {
        if (layerDepth != this.getLayerDepth()) {
            this.LayerDepth = layerDepth;
            this.setRows(this.getLayerWidth() * this.getLayerHeight() * this.getLayerDepth());
            this.setDimensions();
            this.setConnDimensions();
            this.getSpace_map().setMapDepth(layerDepth);
        }
    }

    public int getLayerHeight() {
        return this.LayerHeight;
    }

    public void setLayerHeight(int LayerHeight) {
        if (LayerHeight != this.getLayerHeight()) {
            this.LayerHeight = LayerHeight;
            this.setRows(this.getLayerWidth() * this.getLayerHeight() * this.getLayerDepth());
            this.setDimensions();
            this.setConnDimensions();
            this.getSpace_map().setMapHeight(LayerHeight);
        }
    }

    public int getLayerWidth() {
        return this.LayerWidth;
    }

    public void setLayerWidth(int LayerWidth) {
        if (LayerWidth != this.getLayerWidth()) {
            this.LayerWidth = LayerWidth;
            this.setRows(this.getLayerWidth() * this.getLayerHeight() * this.getLayerDepth());
            this.setDimensions();
            this.setConnDimensions();
            this.getSpace_map().setMapWidth(LayerWidth);
        }
    }

    public int getLargestDimension() {
        int max = 1;
        if (this.getLayerWidth() > max) {
            max = this.getLayerWidth();
        }
        if (this.getLayerHeight() > max) {
            max = this.getLayerHeight();
        }
        if (this.getLayerDepth() > max) {
            max = this.getLayerDepth();
        }
        return max;
    }

    public TreeSet check() {
        TreeSet checks = super.check();
        if (this.getLayerWidth() < 1) {
            checks.add(new NetCheck(0, "Layer width should be greater than or equal to 1.", this));
        }
        if (this.getLayerHeight() < 1) {
            checks.add(new NetCheck(0, "Layer height should be greater than or equal to 1.", this));
        }
        if (this.getLayerDepth() < 1) {
            checks.add(new NetCheck(0, "Layer depth should be greater than or equal to 1.", this));
        }
        if (this.getOrderingPhase() > this.getMonitor().getTotCicles()) {
            checks.add(new NetCheck(1, "Ordering phase should be lesser than or equal to the number of epochs", this));
        }
        return checks;
    }

    public void start() {
        if (this.getMonitor() != null) {
            this.getMonitor().addNeuralNetListener(this, false);
        }
        super.start();
    }

    public void netStarted(NeuralNetEvent e) {
        this.getSpace_map().init(this.getMonitor().getTotCicles());
        this.space_map.setInitialGaussianSize(this.getLargestDimension());
    }

    public void cicleTerminated(NeuralNetEvent e) {
        if (this.getMonitor().isLearning()) {
            this.getSpace_map().updateCurrentGaussianSize(this.getMonitor().getTotCicles() - this.getMonitor().getCurrentCicle());
        }
    }

    public int getOrderingPhase() {
        return this.orderingPhase;
    }

    public void setOrderingPhase(int orderingPhase) {
        this.orderingPhase = orderingPhase;
        this.getSpace_map().setOrderingPhase(orderingPhase);
    }

    public double getTimeConstant() {
        return this.timeConstant;
    }

    public void setTimeConstant(double timeConstant) {
        this.timeConstant = timeConstant;
        this.getSpace_map().setTimeConstant(timeConstant);
    }

    protected SpatialMap getSpace_map() {
        if (this.space_map == null) {
            this.space_map = new GaussianSpatialMap();
            this.space_map.setMapDepth(this.getLayerDepth());
            this.space_map.setMapHeight(this.getLayerHeight());
            this.space_map.setMapWidth(this.getLayerWidth());
            this.space_map.setInitialGaussianSize(this.getInitialGaussianSize());
            this.space_map.setOrderingPhase(this.getOrderingPhase());
            this.space_map.setTimeConstant(this.getTimeConstant());
        }
        return this.space_map;
    }

    public double getInitialGaussianSize() {
        return this.initialGaussianSize;
    }

    public void setInitialGaussianSize(double initialGaussianSize) {
        this.initialGaussianSize = initialGaussianSize;
        this.getSpace_map().setInitialGaussianSize(initialGaussianSize);
    }

    public Collection Inspections() {
        ArrayList<BiasInspection> col = new ArrayList<BiasInspection>();
        col.add(new BiasInspection(null));
        return col;
    }

    public void netStoppedError(NeuralNetEvent e, String error) {
    }

    public void errorChanged(NeuralNetEvent e) {
    }

    public void netStopped(NeuralNetEvent e) {
    }
}

