/*
 * Decompiled with CFR 0.152.
 */
package org.joone.engine;

import org.joone.engine.LearnableSynapse;
import org.joone.engine.Learner;
import org.joone.engine.Matrix;
import org.joone.engine.Synapse;

public class FullSynapse
extends Synapse
implements LearnableSynapse {
    private static final long serialVersionUID = 5518898101307425554L;

    public FullSynapse() {
        this.learnable = true;
    }

    protected void backward(double[] pattern) {
        int m_rows = this.getInputDimension();
        int m_cols = this.getOutputDimension();
        this.setLearningRate(this.getMonitor().getLearningRate());
        int x = 0;
        while (x < m_rows) {
            double s = 0.0;
            int y = 0;
            while (y < m_cols) {
                s += pattern[y] * this.array.value[x][y];
                ++y;
            }
            this.bouts[x] = s;
            ++x;
        }
        this.myLearner.requestWeightUpdate(pattern, this.inps);
    }

    protected void forward(double[] pattern) {
        int m_rows = this.getInputDimension();
        int m_cols = this.getOutputDimension();
        int y = 0;
        while (y < m_cols) {
            double s = 0.0;
            int x = 0;
            while (x < m_rows) {
                s += pattern[x] * this.array.value[x][y];
                ++x;
            }
            this.outs[y] = s;
            ++y;
        }
    }

    protected void setArrays(int rows, int cols) {
        this.inps = new double[rows];
        this.outs = new double[cols];
        this.bouts = new double[rows];
    }

    protected void setDimensions(int rows, int cols) {
        int m_rows = this.getInputDimension();
        int m_cols = this.getOutputDimension();
        int irows = rows == -1 ? m_rows : rows;
        int icols = cols == -1 ? m_cols : cols;
        this.array = new Matrix(irows, icols);
        this.setArrays(irows, icols);
    }

    public Learner getLearner() {
        this.learnable = true;
        return super.getLearner();
    }
}

