/*
 * Decompiled with CFR 0.152.
 */
package org.joone.engine;

import org.joone.engine.LearnableLayer;
import org.joone.engine.Learner;
import org.joone.engine.SimpleLayer;

public class BiasedLinearLayer
extends SimpleLayer
implements LearnableLayer {
    public BiasedLinearLayer() {
    }

    public BiasedLinearLayer(String anElemName) {
        super(anElemName);
    }

    public void backward(double[] pattern) {
        int n = this.getRows();
        int x = 0;
        while (x < n) {
            this.gradientOuts[x] = pattern[x];
            ++x;
        }
        this.myLearner.requestBiasUpdate(this.gradientOuts);
    }

    public void forward(double[] pattern) {
        int n = this.getRows();
        int x = 0;
        while (x < n) {
            this.outs[x] = pattern[x] + this.bias.value[x][0];
            ++x;
        }
    }

    public Learner getLearner() {
        this.learnable = true;
        return super.getLearner();
    }
}

