/*
 * Decompiled with CFR 0.152.
 */
package com.vlsolutions.swing.toolbars;

import com.vlsolutions.swing.toolbars.BackgroundPainter;
import com.vlsolutions.swing.toolbars.ToolBarConstraints;
import com.vlsolutions.swing.toolbars.ToolBarPanelLayout;
import com.vlsolutions.swing.toolbars.VLToolBar;
import java.awt.Component;
import java.awt.Graphics;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JToolBar;

public class ToolBarPanel
extends JPanel {
    private int orientation = 0;
    private BackgroundPainter painter;

    public ToolBarPanel() {
        this(3);
    }

    public ToolBarPanel(int align) {
        this(align, null);
    }

    public ToolBarPanel(int align, BackgroundPainter painter) {
        this.setLayout(new ToolBarPanelLayout(this, align));
        this.painter = painter;
    }

    public void add(JToolBar toolbar) {
        this.add(toolbar, 0);
        this.setVisible(true);
    }

    public void add(JToolBar toolbar, int major) {
        toolbar.setOrientation(this.orientation);
        VLToolBar[] bars = this.getVLToolBarsFromJToolBar(toolbar);
        int i = 0;
        while (i < bars.length) {
            ToolBarConstraints toolBarConstraints = new ToolBarConstraints(major, i);
            this.add(bars[i], toolBarConstraints);
            ++i;
        }
    }

    private VLToolBar[] getVLToolBarsFromJToolBar(JToolBar bar) {
        ArrayList<VLToolBar> vlBars = new ArrayList<VLToolBar>();
        Component[] components = bar.getComponents();
        VLToolBar current = new VLToolBar();
        int i = 0;
        while (i < components.length) {
            if (components[i] instanceof JButton) {
                JButton button = (JButton)components[i];
                if (button.getIcon() != null) {
                    button.setText(null);
                }
                current.add(button);
            } else if (components[i] instanceof JToolBar.Separator) {
                vlBars.add(current);
                current = new VLToolBar();
            } else {
                System.err.println("Don't know how to handle this component " + components[i].getClass());
            }
            ++i;
        }
        vlBars.add(current);
        return vlBars.toArray(new VLToolBar[vlBars.size()]);
    }

    public void add(VLToolBar toolbar, ToolBarConstraints constraints) {
        toolbar.setOrientation(this.orientation);
        super.add((Component)toolbar, constraints);
        this.setVisible(true);
    }

    @Override
    public void remove(Component comp) {
        super.remove(comp);
        if (this.getComponentCount() == 0) {
            this.setVisible(false);
        }
    }

    public void setOrientation(int orientation) {
        if (this.orientation != orientation) {
            this.orientation = orientation;
            this.updateOrientation();
            this.revalidate();
        }
    }

    public int getOrientation() {
        return this.orientation;
    }

    private void updateOrientation() {
        int i = 0;
        while (i < this.getComponentCount()) {
            VLToolBar tb = (VLToolBar)this.getComponent(i);
            tb.setOrientation(this.orientation);
            ++i;
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        if (this.painter != null) {
            this.painter.paintBackground(this, g);
        }
        super.paintComponent(g);
    }

    public BackgroundPainter getBackgroundPainter() {
        return this.painter;
    }

    public void setPainter(BackgroundPainter painter) {
        this.painter = painter;
    }
}

