/*
 * Decompiled with CFR 0.152.
 */
package com.vlsolutions.swing.tabbedpane;

import com.vlsolutions.swing.tabbedpane.JTabbedPaneSmartIcon;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.Icon;
import javax.swing.JTabbedPane;

public class JTabbedPaneSmartIconManager
implements MouseListener,
MouseMotionListener {
    private JTabbedPane tabbedPane;
    private JTabbedPaneSmartIcon pressedIcon;
    private int pressedTab;
    private JTabbedPaneSmartIcon movedIcon;
    private int movedTab;

    public JTabbedPaneSmartIconManager(JTabbedPane tabbedPane) {
        this.tabbedPane = tabbedPane;
        tabbedPane.addMouseListener(this);
        tabbedPane.addMouseMotionListener(this);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.checkTabCount();
        if (this.pressedIcon != null) {
            Point p = e.getPoint();
            Rectangle r = this.tabbedPane.getBoundsAt(this.pressedTab);
            Point iPoint = this.convertPointToIcon(r, p, this.pressedIcon);
            MouseEvent eSmart = new MouseEvent((Component)e.getSource(), e.getID(), e.getWhen(), e.getModifiers(), iPoint.x, iPoint.y, e.getClickCount(), e.isPopupTrigger(), e.getButton());
            try {
                if (this.pressedIcon.onMouseReleased(eSmart)) {
                    this.tabbedPane.repaint(r.x, r.y, r.width, r.height);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.pressedIcon = null;
        }
    }

    private Point convertPointToIcon(Rectangle r, Point p, Icon icon) {
        int x = p.x - (r.x + r.width / 2 - icon.getIconWidth() / 2);
        int y = p.y - (r.y + r.height / 2 - icon.getIconHeight() / 2);
        return new Point(x, y);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        Icon icon;
        Point p = e.getPoint();
        this.pressedIcon = null;
        int targetTab = this.findTabAt(p);
        if (targetTab != -1 && (icon = this.tabbedPane.getIconAt(targetTab)) instanceof JTabbedPaneSmartIcon) {
            JTabbedPaneSmartIcon smartIcon = (JTabbedPaneSmartIcon)icon;
            Rectangle r = this.tabbedPane.getBoundsAt(targetTab);
            int x = p.x - (r.x + r.width / 2 - icon.getIconWidth() / 2);
            int y = p.y - (r.y + r.height / 2 - icon.getIconHeight() / 2);
            if (x >= 0 && y >= 0 && x < icon.getIconWidth() && y < icon.getIconHeight()) {
                MouseEvent eSmart = new MouseEvent((Component)e.getSource(), e.getID(), e.getWhen(), e.getModifiers(), x, y, e.getClickCount(), e.isPopupTrigger(), e.getButton());
                if (smartIcon.onMousePressed(eSmart)) {
                    this.tabbedPane.repaint(r.x, r.y, r.width, r.height);
                }
                this.pressedIcon = smartIcon;
                this.pressedTab = targetTab;
            }
        }
    }

    private void checkTabCount() {
        if (this.movedTab >= this.tabbedPane.getTabCount()) {
            this.movedTab = -1;
            this.movedIcon = null;
        }
        if (this.pressedTab >= this.tabbedPane.getTabCount()) {
            this.pressedTab = -1;
            this.pressedIcon = null;
        }
    }

    private int findTabAt(Point p) {
        int x = p.x;
        int y = p.y;
        int i = 0;
        while (i < this.tabbedPane.getTabCount()) {
            if (this.tabbedPane.getBoundsAt(i).contains(x, y)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.checkTabCount();
        Point p = e.getPoint();
        int targetTab = this.findTabAt(p);
        if (targetTab != -1) {
            Icon icon = this.tabbedPane.getIconAt(targetTab);
            if (icon instanceof JTabbedPaneSmartIcon) {
                String tip;
                MouseEvent eSmart;
                Point iPoint;
                JTabbedPaneSmartIcon smartIcon = (JTabbedPaneSmartIcon)icon;
                if (this.movedIcon != null && this.movedIcon != smartIcon) {
                    Rectangle prevRect = this.tabbedPane.getBoundsAt(this.movedTab);
                    iPoint = this.convertPointToIcon(prevRect, p, this.movedIcon);
                    eSmart = new MouseEvent((Component)e.getSource(), 505, e.getWhen(), e.getModifiers(), iPoint.x, iPoint.y, e.getClickCount(), e.isPopupTrigger(), e.getButton());
                    if (this.movedIcon.onMouseExited(eSmart)) {
                        tip = this.movedIcon.getLocalTooltipText();
                        if (tip != null && !tip.equals(this.tabbedPane.getToolTipTextAt(targetTab))) {
                            this.tabbedPane.setToolTipTextAt(targetTab, tip);
                        }
                        this.tabbedPane.revalidate();
                        this.tabbedPane.repaint();
                    }
                    this.movedIcon = null;
                    this.movedTab = -1;
                }
                Rectangle r = this.tabbedPane.getBoundsAt(targetTab);
                iPoint = this.convertPointToIcon(r, p, icon);
                if (iPoint.x >= 0 && iPoint.y >= 0 && iPoint.x < icon.getIconWidth() && iPoint.y < icon.getIconHeight()) {
                    eSmart = new MouseEvent((Component)e.getSource(), e.getID(), e.getWhen(), e.getModifiers(), iPoint.x, iPoint.y, e.getClickCount(), e.isPopupTrigger(), e.getButton());
                    if (smartIcon.onMouseMoved(eSmart)) {
                        tip = smartIcon.getLocalTooltipText();
                        if (tip != null && !tip.equals(this.tabbedPane.getToolTipTextAt(targetTab))) {
                            this.tabbedPane.setToolTipTextAt(targetTab, tip);
                        }
                        this.tabbedPane.revalidate();
                        this.tabbedPane.repaint();
                    }
                    this.movedIcon = smartIcon;
                    this.movedTab = targetTab;
                } else {
                    if (this.movedIcon != null) {
                        Rectangle prevRect = this.tabbedPane.getBoundsAt(this.movedTab);
                        iPoint = this.convertPointToIcon(prevRect, p, this.movedIcon);
                        MouseEvent eSmart2 = new MouseEvent((Component)e.getSource(), 505, e.getWhen(), e.getModifiers(), iPoint.x, iPoint.y, e.getClickCount(), e.isPopupTrigger(), e.getButton());
                        if (this.movedIcon.onMouseExited(eSmart2)) {
                            String tip2 = this.movedIcon.getLocalTooltipText();
                            if (tip2 != null && !tip2.equals(this.tabbedPane.getToolTipTextAt(targetTab))) {
                                this.tabbedPane.setToolTipTextAt(targetTab, tip2);
                            }
                            this.tabbedPane.revalidate();
                            this.tabbedPane.repaint();
                        }
                    }
                    this.movedIcon = null;
                    this.movedTab = -1;
                }
            } else if (this.movedIcon != null) {
                Rectangle prevRect = this.tabbedPane.getBoundsAt(this.movedTab);
                Point iPoint = this.convertPointToIcon(prevRect, p, this.movedIcon);
                MouseEvent eSmart = new MouseEvent((Component)e.getSource(), 505, e.getWhen(), e.getModifiers(), iPoint.x, iPoint.y, e.getClickCount(), e.isPopupTrigger(), e.getButton());
                if (this.movedIcon.onMouseExited(eSmart)) {
                    String tip = this.movedIcon.getLocalTooltipText();
                    if (tip != null && !tip.equals(this.tabbedPane.getToolTipTextAt(targetTab))) {
                        this.tabbedPane.setToolTipTextAt(targetTab, tip);
                    }
                    this.tabbedPane.revalidate();
                    this.tabbedPane.repaint();
                }
                this.movedIcon = null;
                this.movedTab = -1;
            }
        } else if (this.movedIcon != null) {
            Rectangle prevRect = this.tabbedPane.getBoundsAt(this.movedTab);
            Point iPoint = this.convertPointToIcon(prevRect, p, this.movedIcon);
            MouseEvent eSmart = new MouseEvent((Component)e.getSource(), 505, e.getWhen(), e.getModifiers(), iPoint.x, iPoint.y, e.getClickCount(), e.isPopupTrigger(), e.getButton());
            if (this.movedIcon.onMouseExited(eSmart)) {
                String tip = this.movedIcon.getLocalTooltipText();
                if (tip != null && !tip.equals(this.tabbedPane.getToolTipTextAt(this.movedTab))) {
                    this.tabbedPane.setToolTipTextAt(this.movedTab, tip);
                }
                this.tabbedPane.revalidate();
                this.tabbedPane.repaint();
            }
            this.movedIcon = null;
            this.movedTab = -1;
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.checkTabCount();
        if (this.movedIcon != null) {
            Point p = e.getPoint();
            Rectangle prevRect = this.tabbedPane.getBoundsAt(this.movedTab);
            Point iPoint = this.convertPointToIcon(prevRect, p, this.movedIcon);
            MouseEvent eSmart = new MouseEvent((Component)e.getSource(), 505, e.getWhen(), e.getModifiers(), iPoint.x, iPoint.y, e.getClickCount(), e.isPopupTrigger(), e.getButton());
            if (this.movedIcon.onMouseExited(eSmart)) {
                String tip = this.movedIcon.getLocalTooltipText();
                if (tip != null && !tip.equals(this.tabbedPane.getToolTipTextAt(this.movedTab))) {
                    this.tabbedPane.setToolTipTextAt(this.movedTab, tip);
                }
                this.tabbedPane.repaint(prevRect.x, prevRect.y, prevRect.width, prevRect.height);
            }
            this.movedIcon = null;
            this.movedTab = -1;
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }
}

