/*
 * Decompiled with CFR 0.152.
 */
package com.vlsolutions.swing.docking;

import com.vlsolutions.swing.docking.Dockable;
import com.vlsolutions.swing.docking.DockingDesktop;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.KeyStroke;
import javax.swing.UIManager;

public class TabbedContainerActions {
    private static final String CLOSE_TEXT = UIManager.getString("DockTabbedPane.closeButtonText");
    private static final String ICONIFY_TEXT = UIManager.getString("DockTabbedPane.minimizeButtonText");
    private static final String RESTORE_TEXT = UIManager.getString("DockTabbedPane.restoreButtonText");
    private static final String MAXIMIZE_TEXT = UIManager.getString("DockTabbedPane.maximizeButtonText");
    private static final String FLOAT_TEXT = UIManager.getString("DockTabbedPane.floatButtonText");
    private static final String ATTACH_TEXT = UIManager.getString("DockTabbedPane.attachButtonText");
    private static final Icon CLOSE_ICON = UIManager.getIcon("DockTabbedPane.menu.close");
    private static final Icon CLOSE_ALL_ICON = UIManager.getIcon("DockTabbedPane.closeAll");
    private static final Icon CLOSE_OTHER_ICON = UIManager.getIcon("DockTabbedPane.closeAllOther");
    private static final Icon ICONIFY_ICON = UIManager.getIcon("DockTabbedPane.menu.hide");
    private static final Icon MAXIMIZE_ICON = UIManager.getIcon("DockTabbedPane.menu.maximize");
    private static final Icon FLOAT_ICON = UIManager.getIcon("DockTabbedPane.menu.float");
    private static final Icon ATTACH_ICON = UIManager.getIcon("DockTabbedPane.menu.attach");

    private TabbedContainerActions() {
    }

    public static Action createCloseAction(final Dockable dockable, final DockingDesktop desktop) {
        AbstractAction action = new AbstractAction(CLOSE_TEXT){

            @Override
            public void actionPerformed(ActionEvent e) {
                desktop.close(dockable);
            }
        };
        action.putValue("SmallIcon", CLOSE_ICON);
        KeyStroke ks = (KeyStroke)UIManager.get("DockingDesktop.closeActionAccelerator");
        if (ks != null) {
            action.putValue("AcceleratorKey", ks);
        }
        return action;
    }

    public static Action createCloseAllAction(final Dockable base, final DockingDesktop desktop) {
        AbstractAction action = new AbstractAction("Close all documents"){

            @Override
            public void actionPerformed(ActionEvent e) {
                desktop.closeAllDockablesInTab(base);
            }
        };
        action.putValue("SmallIcon", CLOSE_ALL_ICON);
        return action;
    }

    public static Action createCloseAllOtherAction(final Dockable exception, final DockingDesktop desktop) {
        AbstractAction action = new AbstractAction("Close all other documents"){

            @Override
            public void actionPerformed(ActionEvent e) {
                desktop.closeAllOtherDockablesInTab(exception);
            }
        };
        action.putValue("SmallIcon", CLOSE_OTHER_ICON);
        return action;
    }

    public static Action createMaximizeTabAction(final Dockable dockable, final DockingDesktop desktop) {
        AbstractAction action = new AbstractAction(MAXIMIZE_TEXT){

            @Override
            public void actionPerformed(ActionEvent e) {
                desktop.maximize(dockable);
            }
        };
        action.putValue("SmallIcon", MAXIMIZE_ICON);
        KeyStroke ks = (KeyStroke)UIManager.get("DockingDesktop.maximizeActionAccelerator");
        if (ks != null) {
            action.putValue("AcceleratorKey", ks);
        }
        return action;
    }

    public static Action createHideTabAction(final Dockable dockable, final DockingDesktop desktop) {
        AbstractAction action = new AbstractAction(ICONIFY_TEXT){

            @Override
            public void actionPerformed(ActionEvent e) {
                desktop.setAutoHide(dockable, true);
            }
        };
        action.putValue("SmallIcon", ICONIFY_ICON);
        KeyStroke ks = (KeyStroke)UIManager.get("DockingDesktop.dockActionAccelerator");
        if (ks != null) {
            action.putValue("AcceleratorKey", ks);
        }
        return action;
    }

    public static Action createFloatTabAction(final Dockable dockable, final DockingDesktop desktop) {
        AbstractAction action = new AbstractAction(FLOAT_TEXT){

            @Override
            public void actionPerformed(ActionEvent e) {
                desktop.setFloating(dockable, true);
            }
        };
        action.putValue("SmallIcon", FLOAT_ICON);
        KeyStroke ks = (KeyStroke)UIManager.get("DockingDesktop.floatActionAccelerator");
        if (ks != null) {
            action.putValue("AcceleratorKey", ks);
        }
        return action;
    }

    public static Action createAttachTabAction(final Dockable dockable, final DockingDesktop desktop) {
        AbstractAction action = new AbstractAction(ATTACH_TEXT){

            @Override
            public void actionPerformed(ActionEvent e) {
                desktop.setFloating(dockable, false);
            }
        };
        action.putValue("SmallIcon", ATTACH_ICON);
        KeyStroke ks = (KeyStroke)UIManager.get("DockingDesktop.floatActionAccelerator");
        if (ks != null) {
            action.putValue("AcceleratorKey", ks);
        }
        return action;
    }
}

