/*
 * Decompiled with CFR 0.152.
 */
package com.vlsolutions.swing.docking;

import com.vlsolutions.swing.docking.DragControler;
import com.vlsolutions.swing.docking.ShapeOutlinePainter;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseMotionAdapter;
import java.awt.geom.AffineTransform;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class DragControlerGlassPane
extends JComponent {
    Cursor stopDragCursor;
    Cursor dragCursor;
    Cursor floatCursor;
    Cursor swapDragCursor;
    Color innerColor = new Color(64, 64, 64, 64);
    Color textColor = Color.WHITE;
    Color textFillColor = new Color(32, 32, 32, 128);
    Color textBorderColor = new Color(64, 64, 64);
    boolean paintShapes = true;
    ShapeLabelPainter labelPainter = new ShapeLabelPainter();
    ShapeOutlinePainter outlinePainer = new ShapeOutlinePainter();
    private DragControler controler;

    DragControlerGlassPane(DragControler controler) {
        this.controler = controler;
        this.addMouseListener(new MouseAdapter(){});
        this.addMouseMotionListener(new MouseMotionAdapter(){});
        this.showDragCursor();
    }

    public void setPaintShapes(boolean paintShapes) {
        this.paintShapes = paintShapes;
    }

    @Override
    public void paintComponent(Graphics g) {
        if (this.paintShapes) {
            Graphics2D g2 = (Graphics2D)g;
            if (this.controler.getDropShape() != null) {
                Shape s = this.controler.getDropShape();
                Point p = SwingUtilities.convertPoint((Component)((Object)this.controler.getDropReceiver()), 0, 0, this);
                Shape s2 = AffineTransform.getTranslateInstance(p.x, p.y).createTransformedShape(s);
                this.outlinePainer.paintShape(g2, s2);
                this.labelPainter.paintLabel(g2, s2, this.controler.getDockable().getDockKey().getName());
            }
        }
    }

    public void showStopDragCursor() {
        if (this.stopDragCursor == null) {
            Image stopDragImage = (Image)UIManager.get("DragControler.stopDragCursor");
            this.stopDragCursor = Toolkit.getDefaultToolkit().createCustomCursor(stopDragImage, new Point(16, 16), "stopdragcursor");
        }
        this.setCursor(this.stopDragCursor);
    }

    public void showSwapDragCursor() {
        if (this.swapDragCursor == null) {
            Image swapDragImage = (Image)UIManager.get("DragControler.swapDragCursor");
            this.swapDragCursor = Toolkit.getDefaultToolkit().createCustomCursor(swapDragImage, new Point(16, 16), "swapdragcursor");
        }
        this.setCursor(this.swapDragCursor);
    }

    public void showFloatCursor() {
        if (this.floatCursor == null) {
            Image floatImage = (Image)UIManager.get("DragControler.detachCursor");
            this.floatCursor = Toolkit.getDefaultToolkit().createCustomCursor(floatImage, new Point(16, 16), "floatcursor");
        }
        this.setCursor(this.floatCursor);
    }

    public void showDragCursor() {
        if (this.dragCursor == null) {
            Image dragImage = (Image)UIManager.get("DragControler.dragCursor");
            this.dragCursor = Toolkit.getDefaultToolkit().createCustomCursor(dragImage, new Point(16, 16), "dragcursor");
        }
        this.setCursor(this.dragCursor);
    }

    class ShapeLabelPainter {
        private Color textColor = Color.WHITE;
        private Color textFillColor = new Color(32, 32, 32, 128);
        private Color textBorderColor = new Color(64, 64, 64);

        ShapeLabelPainter() {
        }

        public void paintLabel(Graphics2D g2, Shape s, String name) {
            int by;
            int bx;
            Rectangle bounds = s.getBounds();
            FontMetrics fm = g2.getFontMetrics();
            int w = fm.stringWidth(name);
            g2.setColor(this.textFillColor);
            if (DragControlerGlassPane.this.controler.isFloatingShape()) {
                bx = bounds.x + bounds.width / 2 - w / 2;
                by = bounds.y + bounds.height / 2 - fm.getHeight() / 2;
            } else {
                bx = 4 * ((bounds.x + bounds.width / 2 - w / 2) / 4);
                by = 4 * ((bounds.y + bounds.height / 2 - fm.getHeight() / 2) / 4);
            }
            g2.fillRect(bx - 5, by, w + 10, fm.getHeight());
            g2.setStroke(new BasicStroke(1.0f));
            g2.setColor(this.textBorderColor);
            g2.drawRect(bx - 5, by, w + 10, fm.getHeight());
            g2.setColor(this.textColor);
            g2.drawString(name, bx, by + fm.getAscent());
        }
    }
}

