/*
 * Decompiled with CFR 0.152.
 */
package com.vlsolutions.swing.docking;

import com.vlsolutions.swing.docking.Dockable;
import com.vlsolutions.swing.docking.DockableResolver;
import com.vlsolutions.swing.docking.DockableState;
import com.vlsolutions.swing.docking.DockingDesktop;
import com.vlsolutions.swing.docking.event.DockableSelectionEvent;
import com.vlsolutions.swing.docking.event.DockableSelectionListener;
import com.vlsolutions.swing.docking.event.DockableStateChangeEvent;
import com.vlsolutions.swing.docking.event.DockableStateChangeListener;
import com.vlsolutions.swing.docking.event.DockableStateWillChangeEvent;
import com.vlsolutions.swing.docking.event.DockableStateWillChangeListener;
import com.vlsolutions.swing.docking.event.DockingActionEvent;
import com.vlsolutions.swing.docking.event.DockingActionListener;
import java.awt.Window;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class DockingContext {
    protected ArrayList<Dockable> registeredDockables = new ArrayList();
    protected HashMap<Dockable, DockableState> dockableStates = new HashMap();
    private final ArrayList<DockableStateWillChangeListener> dockableStateWillChangeListeners = new ArrayList();
    private final ArrayList<DockableStateChangeListener> dockableStateChangeListeners = new ArrayList();
    private final ArrayList<DockableSelectionListener> dockableSelectionListeners = new ArrayList();
    private final ArrayList<DockingActionListener> dockingActionListeners = new ArrayList();
    private final ArrayList<DockingDesktop> desktops = new ArrayList();
    private final LinkedList<Window> ownedWindowActivationOrder = new LinkedList();
    private DockableResolver dockableResolver = null;

    public void addDesktop(DockingDesktop desktop) {
        if (!this.desktops.contains(desktop)) {
            this.desktops.add(desktop);
        }
    }

    public void removeDesktop(DockingDesktop desktop) {
        this.desktops.remove(desktop);
        Iterator it = this.ownedWindowActivationOrder.iterator();
        while (it.hasNext()) {
            Window w = (Window)it.next();
            boolean ancestor = false;
            int i = 0;
            while (i < this.desktops.size()) {
                DockingDesktop desk = this.desktops.get(i);
                if (w.isAncestorOf(desk)) {
                    ancestor = true;
                    break;
                }
                ++i;
            }
            if (ancestor) continue;
            it.remove();
        }
    }

    public void registerDockable(Dockable dockable) {
        if (!this.registeredDockables.contains(dockable)) {
            this.registeredDockables.add(dockable);
        }
        if (this.getDockableState(dockable) == null) {
            this.setDockableState(dockable, new DockableState(null, dockable, DockableState.Location.CLOSED));
        }
    }

    public void unregisterDockable(Dockable dockable) {
        this.close(dockable);
        this.registeredDockables.remove(dockable);
        this.dockableStates.remove(dockable);
    }

    public void close(Dockable dockable) {
        DockingDesktop desk;
        DockableState state = this.dockableStates.get(dockable);
        if (state != null && (desk = state.getDesktop()) != null) {
            desk.close(dockable);
        }
    }

    public DockableState getDockableState(Dockable dockable) {
        return this.dockableStates.get(dockable);
    }

    public void setDockableState(Dockable dockable, DockableState state) {
        this.dockableStates.put(dockable, state);
    }

    public void addDockableStateChangeListener(DockableStateChangeListener listener) {
        if (!this.dockableStateChangeListeners.contains(listener)) {
            this.dockableStateChangeListeners.add(listener);
        }
    }

    public void removeDockableStateChangeListener(DockableStateChangeListener listener) {
        this.dockableStateChangeListeners.remove(listener);
    }

    public void addDockableStateWillChangeListener(DockableStateWillChangeListener listener) {
        if (!this.dockableStateWillChangeListeners.contains(listener)) {
            this.dockableStateWillChangeListeners.add(listener);
        }
    }

    public void removeDockableStateWillChangeListener(DockableStateWillChangeListener listener) {
        this.dockableStateWillChangeListeners.remove(listener);
    }

    public DockableState[] getDockables() {
        DockableState[] states = new DockableState[this.registeredDockables.size()];
        int i = 0;
        while (i < states.length) {
            Dockable d = this.registeredDockables.get(i);
            states[i] = this.dockableStates.get(d);
            if (states[i] == null) {
                DockableState closed;
                states[i] = closed = new DockableState(null, d, DockableState.Location.CLOSED);
            }
            ++i;
        }
        return states;
    }

    public void writeXML(OutputStream stream) throws IOException {
        PrintWriter out = new PrintWriter(stream);
        out.println("<?xml version=\"1.0\"?>");
        out.println("<VLDocking version=\"2.1\">");
        int i = 0;
        while (i < this.desktops.size()) {
            DockingDesktop desktop = this.desktops.get(i);
            desktop.writeDesktopNode(out);
            ++i;
        }
        out.println("</VLDocking>");
        out.flush();
    }

    public void readXML(InputStream in) throws ParserConfigurationException, IOException, SAXException {
        int i = 0;
        while (i < this.desktops.size()) {
            DockingDesktop desk = this.desktops.get(i);
            desk.clear();
            ++i;
        }
        this.dockableStates.clear();
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document doc = builder.parse(in);
        Element root = doc.getDocumentElement();
        if (root.getNodeName().equals("DockingDesktop")) {
            DockingDesktop desk = this.getDesktopByName(null);
            desk.readDesktopNode(root);
        } else {
            NodeList desktopChildren = root.getChildNodes();
            int i2 = 0;
            int len = desktopChildren.getLength();
            while (i2 < len) {
                Node node = desktopChildren.item(i2);
                if (node instanceof Element) {
                    Element deskChild = (Element)node;
                    DockingDesktop desk = this.getDesktopByName(deskChild.getAttribute("name"));
                    desk.readDesktopNode(deskChild);
                }
                ++i2;
            }
        }
    }

    private DockingDesktop getDesktopByName(String name) {
        if (this.desktops.size() == 1) {
            DockingDesktop desktop = this.desktops.get(0);
            return desktop;
        }
        int i = 0;
        while (i < this.desktops.size()) {
            DockingDesktop desktop = this.desktops.get(i);
            if (desktop.getDesktopName().equals(name)) {
                return desktop;
            }
            ++i;
        }
        throw new RuntimeException("No desktop found with name : " + name);
    }

    public ArrayList<Dockable> getDockablesByState(DockingDesktop desktop, DockableState.Location state) {
        ArrayList<Dockable> list = new ArrayList<Dockable>();
        int i = 0;
        while (i < this.registeredDockables.size()) {
            Dockable d = this.registeredDockables.get(i);
            DockableState dState = this.dockableStates.get(d);
            if (dState != null && dState.getDesktop() == desktop && dState.getLocation() == state) {
                list.add(d);
            }
            ++i;
        }
        return list;
    }

    public Dockable getDockableByKey(String dockKey) {
        int i = 0;
        while (i < this.registeredDockables.size()) {
            Dockable d = this.registeredDockables.get(i);
            if (d.getDockKey().getKey().equals(dockKey)) {
                return d;
            }
            ++i;
        }
        if (this.dockableResolver != null) {
            Dockable d = this.dockableResolver.resolveDockable(dockKey);
            if (d != null) {
                this.registerDockable(d);
            }
            return d;
        }
        return null;
    }

    void fireDockableStateChange(DockableStateChangeEvent e) {
        int i = 0;
        while (i < this.dockableStateChangeListeners.size()) {
            DockableStateChangeListener listener = this.dockableStateChangeListeners.get(i);
            listener.dockableStateChanged(e);
            ++i;
        }
    }

    boolean fireDockableStateWillChange(DockableStateWillChangeEvent e) {
        DockingDesktop desk = e.getFutureState().getDesktop();
        if (desk.getMaximizedDockable() != null && desk.getMaximizedDockable() != e.getCurrentState().getDockable() && e.getFutureState().isDocked()) {
            if (e.getCurrentState().isHidden()) {
                return false;
            }
            if (e.getCurrentState().isFloating()) {
                return false;
            }
        }
        int i = 0;
        while (i < this.dockableStateWillChangeListeners.size()) {
            DockableStateWillChangeListener listener = this.dockableStateWillChangeListeners.get(i);
            listener.dockableStateWillChange(e);
            if (!e.isAccepted()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void addDockableSelectionListener(DockableSelectionListener listener) {
        if (!this.dockableSelectionListeners.contains(listener)) {
            this.dockableSelectionListeners.add(listener);
        }
    }

    public void removeDockableSelectionListener(DockableSelectionListener listener) {
        this.dockableSelectionListeners.remove(listener);
    }

    void fireDockableSelectionChange(DockableSelectionEvent e) {
        int i = 0;
        while (i < this.dockableSelectionListeners.size()) {
            DockableSelectionListener listener = this.dockableSelectionListeners.get(i);
            listener.selectionChanged(e);
            ++i;
        }
    }

    public void addDockingActionListener(DockingActionListener listener) {
        if (!this.dockingActionListeners.contains(listener)) {
            this.dockingActionListeners.add(listener);
        }
    }

    public void removeDockingActionListener(DockingActionListener listener) {
        this.dockingActionListeners.remove(listener);
    }

    boolean fireAcceptDockingAction(DockingActionEvent e) {
        int i = 0;
        while (i < this.dockingActionListeners.size()) {
            DockingActionListener listener = this.dockingActionListeners.get(i);
            if (!listener.acceptDockingAction(e)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    void fireDockingActionPerformed(DockingActionEvent e) {
        int i = 0;
        while (i < this.dockingActionListeners.size()) {
            DockingActionListener listener = this.dockingActionListeners.get(i);
            listener.dockingActionPerformed(e);
            ++i;
        }
    }

    public ArrayList<DockingDesktop> getDesktopList() {
        return this.desktops;
    }

    void windowActivated(WindowEvent e) {
        Window w = e.getWindow();
        if (this.ownedWindowActivationOrder.size() > 0 && this.ownedWindowActivationOrder.getFirst() != w) {
            this.ownedWindowActivationOrder.remove(w);
            this.ownedWindowActivationOrder.addFirst(w);
        }
    }

    LinkedList<Window> getOwnedWindowActionOrder() {
        return this.ownedWindowActivationOrder;
    }

    void registerWindow(Window w) {
        this.ownedWindowActivationOrder.addLast(w);
    }

    public DockableResolver getDockableResolver() {
        return this.dockableResolver;
    }

    public void setDockableResolver(DockableResolver dockableResolver) {
        this.dockableResolver = dockableResolver;
    }
}

