/*
 * Decompiled with CFR 0.152.
 */
package com.vlsolutions.swing.docking;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;

public class DockingBorderLayout
implements LayoutManager2 {
    Component topComp;
    Component leftComp;
    Component bottomComp;
    Component rightComp;
    Component centerComp;

    @Override
    public float getLayoutAlignmentX(Container target) {
        return 0.5f;
    }

    @Override
    public float getLayoutAlignmentY(Container target) {
        return 0.5f;
    }

    @Override
    public void invalidateLayout(Container target) {
    }

    @Override
    public Dimension maximumLayoutSize(Container target) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    @Override
    public void addLayoutComponent(Component comp, Object constraints) {
        this.addLayoutComponent((String)constraints, comp);
    }

    @Override
    public void removeLayoutComponent(Component comp) {
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
        if (name.equals("North")) {
            this.topComp = comp;
        } else if (name.equals("East")) {
            this.rightComp = comp;
        } else if (name.equals("South")) {
            this.bottomComp = comp;
        } else if (name.equals("West")) {
            this.leftComp = comp;
        } else if (name.equals("Center")) {
            this.centerComp = comp;
        } else {
            throw new IllegalArgumentException("wrong constraint");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension minimumLayoutSize(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            Dimension d;
            Dimension dim = new Dimension(0, 0);
            if (this.leftComp != null && this.leftComp.isVisible()) {
                d = this.leftComp.getMinimumSize();
                dim.width += d.width;
                dim.height = Math.max(d.height, dim.height);
            }
            if (this.rightComp != null && this.rightComp.isVisible()) {
                d = this.rightComp.getMinimumSize();
                dim.width += d.width;
                dim.height = Math.max(d.height, dim.height);
            }
            if (this.centerComp != null && this.centerComp.isVisible()) {
                d = this.centerComp.getMinimumSize();
                dim.width += d.width;
                dim.height = Math.max(d.height, dim.height);
            }
            if (this.topComp != null && this.topComp.isVisible()) {
                d = this.topComp.getMinimumSize();
                dim.width = Math.max(d.width, dim.width);
                dim.height += d.height;
            }
            if (this.bottomComp != null && this.bottomComp.isVisible()) {
                d = this.bottomComp.getMinimumSize();
                dim.width = Math.max(d.width, dim.width);
                dim.height += d.height;
            }
            Insets insets = parent.getInsets();
            dim.width += insets.left + insets.right;
            dim.height += insets.top + insets.bottom;
            return dim;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension preferredLayoutSize(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            Dimension d;
            Dimension dim = new Dimension(0, 0);
            if (this.leftComp != null && this.leftComp.isVisible()) {
                d = this.leftComp.getPreferredSize();
                dim.width += d.width;
                dim.height = Math.max(d.height, dim.height);
            }
            if (this.rightComp != null && this.rightComp.isVisible()) {
                d = this.rightComp.getPreferredSize();
                dim.width += d.width;
                dim.height = Math.max(d.height, dim.height);
            }
            if (this.centerComp != null && this.centerComp.isVisible()) {
                d = this.centerComp.getPreferredSize();
                dim.width += d.width;
                dim.height = Math.max(d.height, dim.height);
            }
            if (this.topComp != null && this.topComp.isVisible()) {
                d = this.topComp.getPreferredSize();
                dim.width = Math.max(d.width, dim.width);
                dim.height += d.height;
            }
            if (this.bottomComp != null && this.bottomComp.isVisible()) {
                d = this.bottomComp.getPreferredSize();
                dim.width = Math.max(d.width, dim.width);
                dim.height += d.height;
            }
            Insets insets = parent.getInsets();
            dim.width += insets.left + insets.right;
            dim.height += insets.top + insets.bottom;
            return dim;
        }
    }

    private int getSideWidth(Component comp) {
        if (comp == null) {
            return 0;
        }
        if (comp.isVisible()) {
            return comp.getPreferredSize().width;
        }
        return 0;
    }

    private int getSideHeight(Component comp) {
        if (comp == null) {
            return 0;
        }
        if (comp.isVisible()) {
            return comp.getPreferredSize().height;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void layoutContainer(Container target) {
        Object object = target.getTreeLock();
        synchronized (object) {
            Dimension d;
            Insets insets = target.getInsets();
            int top = insets.top;
            int bottom = target.getHeight() - insets.bottom;
            int left = insets.left;
            int right = target.getWidth() - insets.right;
            int lw = this.getSideWidth(this.leftComp);
            int rw = this.getSideWidth(this.rightComp);
            int th = this.getSideHeight(this.topComp);
            int bh = this.getSideHeight(this.bottomComp);
            if (this.topComp != null && this.topComp.isVisible()) {
                this.topComp.setSize(right - left - lw - rw, this.topComp.getHeight());
                d = this.topComp.getPreferredSize();
                this.topComp.setBounds(left + lw, top, right - left - lw - rw, d.height);
            }
            if (this.bottomComp != null && this.bottomComp.isVisible()) {
                this.bottomComp.setSize(right - left - lw - rw, this.bottomComp.getHeight());
                d = this.bottomComp.getPreferredSize();
                this.bottomComp.setBounds(left + lw, bottom - d.height, right - left - lw - rw, d.height);
            }
            if (this.rightComp != null && this.rightComp.isVisible()) {
                this.rightComp.setSize(this.rightComp.getWidth(), bottom - top - th - bh);
                d = this.rightComp.getPreferredSize();
                this.rightComp.setBounds(right - d.width, top + th, d.width, bottom - top - th - bh);
            }
            if (this.leftComp != null && this.leftComp.isVisible()) {
                this.leftComp.setSize(this.leftComp.getWidth(), bottom - top);
                d = this.leftComp.getPreferredSize();
                this.leftComp.setBounds(left, top + th, d.width, bottom - top - th - bh);
            }
            if (this.centerComp != null && this.centerComp.isVisible()) {
                this.centerComp.setBounds(left + lw, top + th, right - left - lw - rw, bottom - top - th - bh);
            }
        }
    }
}

