/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.krimp.gui;

import com.rapidminer.gui.tools.ExtendedJScrollPane;
import com.rapidminer.gui.tools.ExtendedJTable;
import com.rapidminer.krimp.CodeTable;
import com.rapidminer.krimp.gui.CodeTableModel;
import com.rapidminer.krimp.gui.STCodeTableModel;
import com.rapidminer.tools.Tools;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EtchedBorder;
import javax.swing.table.TableModel;

public class CodeTableVisualization
extends JPanel {
    private static final long serialVersionUID = -4353590225271845908L;
    private final CodeTableModel modelCT;
    private final STCodeTableModel modelST;
    private final JLabel totalSizeLabel = new JLabel();
    private final JLabel compressedSizeLabel = new JLabel();
    private final JLabel standardCTLabel = new JLabel();

    public CodeTableVisualization(CodeTable codeTable) {
        this.modelST = new STCodeTableModel(codeTable.getStandardCodeTable());
        codeTable.cleanUp();
        this.modelCT = new CodeTableModel(codeTable);
        this.setLayout(new BorderLayout());
        JPanel mainPanel = new JPanel();
        mainPanel.setBorder(BorderFactory.createEtchedBorder(0));
        this.add((Component)mainPanel, "Center");
        GridBagLayout mainPanelGBL = new GridBagLayout();
        mainPanelGBL.columnWidths = new int[]{20, 0, 0};
        mainPanelGBL.rowHeights = new int[]{0, 0};
        mainPanelGBL.columnWeights = new double[]{0.0, 1.0, Double.MIN_VALUE};
        mainPanelGBL.rowWeights = new double[]{1.0, Double.MIN_VALUE};
        mainPanel.setLayout(mainPanelGBL);
        Component horStrut = Box.createHorizontalStrut(20);
        GridBagConstraints horStrutGBC = new GridBagConstraints();
        horStrutGBC.anchor = 17;
        horStrutGBC.fill = 3;
        horStrutGBC.insets = new Insets(0, 0, 0, 5);
        horStrutGBC.gridx = 0;
        horStrutGBC.gridy = 0;
        mainPanel.add(horStrut, horStrutGBC);
        ExtendedJTable table = new ExtendedJTable((TableModel)this.modelCT, true, true, false);
        table.setBorder(BorderFactory.createEtchedBorder(0));
        ExtendedJScrollPane tablePane = new ExtendedJScrollPane((Component)table);
        GridBagConstraints tablePaneGBC = new GridBagConstraints();
        tablePaneGBC.fill = 1;
        tablePaneGBC.gridx = 1;
        tablePaneGBC.gridy = 0;
        mainPanel.add((Component)tablePane, tablePaneGBC);
        JPanel leftPanel = new JPanel();
        leftPanel.setBorder(new EtchedBorder(0));
        GridBagLayout layout = new GridBagLayout();
        layout.columnWidths = new int[]{0, 0};
        layout.rowHeights = new int[]{20, 20, 20, 20, 0, 0};
        layout.columnWeights = new double[]{1.0, Double.MIN_VALUE};
        layout.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 1.0, Double.MIN_VALUE};
        leftPanel.setLayout(layout);
        this.totalSizeLabel.setText("No. of Sets: " + codeTable.getNumberOfEntrys());
        GridBagConstraints gbcTotSizeLbl = new GridBagConstraints();
        gbcTotSizeLbl.fill = 1;
        gbcTotSizeLbl.gridx = 0;
        gbcTotSizeLbl.gridy = 0;
        leftPanel.add((Component)this.totalSizeLabel, gbcTotSizeLbl);
        this.compressedSizeLabel.setText("Compressed size L(CT,D): " + Tools.formatNumber((double)codeTable.getCompressedSize()));
        GridBagConstraints gbcComprSize = new GridBagConstraints();
        gbcComprSize.fill = 1;
        gbcComprSize.gridx = 0;
        gbcComprSize.gridy = 1;
        leftPanel.add((Component)this.compressedSizeLabel, gbcComprSize);
        this.standardCTLabel.setText("Standard Code Table:");
        GridBagConstraints gbcStCT = new GridBagConstraints();
        gbcStCT.fill = 1;
        gbcStCT.gridx = 0;
        gbcStCT.gridy = 3;
        leftPanel.add((Component)this.standardCTLabel, gbcStCT);
        ExtendedJTable table2 = new ExtendedJTable((TableModel)this.modelST, true, true, false);
        ExtendedJScrollPane tablePane2 = new ExtendedJScrollPane((Component)table2);
        tablePane2.setPreferredSize(new Dimension(245, 401));
        GridBagConstraints gbcTable = new GridBagConstraints();
        gbcTable.fill = 1;
        gbcTable.gridx = 0;
        gbcTable.gridy = 4;
        leftPanel.add((Component)tablePane2, gbcTable);
        this.add((Component)leftPanel, "West");
    }
}

