/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.krimp;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.learner.associations.BooleanAttributeItem;
import com.rapidminer.operator.learner.associations.FrequentItemSet;
import com.rapidminer.operator.learner.associations.Item;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class Database
implements Iterable<Set<Item>> {
    private final Map<Attribute, Item> itemMap = new HashMap<Attribute, Item>();
    private final Map<Set<Item>, Integer> transactionFreqMap = new HashMap<Set<Item>, Integer>();
    private int numberOfStoredItems = 0;
    private final int numberOfTransactions;

    public Database(ExampleSet exampleSet) {
        this.numberOfTransactions = exampleSet.size();
        for (Attribute attribute : exampleSet.getAttributes()) {
            this.itemMap.put(attribute, (Item)new BooleanAttributeItem(attribute));
        }
        for (Example example : exampleSet) {
            for (Attribute attribute : exampleSet.getAttributes()) {
                if (example.getValue(attribute) != (double)attribute.getMapping().getPositiveIndex()) continue;
                this.itemMap.get(attribute).increaseFrequency();
                ++this.numberOfStoredItems;
            }
        }
        for (Example example : exampleSet) {
            HashSet<Item> transaction = new HashSet<Item>();
            for (Attribute attribute : exampleSet.getAttributes()) {
                if (example.getValue(attribute) != (double)attribute.getMapping().getPositiveIndex()) continue;
                transaction.add(this.itemMap.get(attribute));
            }
            if (transaction.isEmpty()) continue;
            if (this.transactionFreqMap.get(transaction) == null) {
                this.transactionFreqMap.put(transaction, 1);
                continue;
            }
            this.transactionFreqMap.put(transaction, this.transactionFreqMap.get(transaction) + 1);
        }
    }

    public int getNumberOfStoredItems() {
        return this.numberOfStoredItems;
    }

    public Set<Item> getItems() {
        return new HashSet<Item>(this.itemMap.values());
    }

    public FrequentItemSet getThisItems(FrequentItemSet freqItemSet) {
        ArrayList<Item> thisItemSet = new ArrayList<Item>();
        for (Item item : this.itemMap.values()) {
            if (!freqItemSet.getItems().contains(item)) continue;
            thisItemSet.add(item);
        }
        return new FrequentItemSet(thisItemSet, freqItemSet.getFrequency());
    }

    @Override
    public Iterator<Set<Item>> iterator() {
        return this.transactionFreqMap.keySet().iterator();
    }

    public int getNumberOfTransactions() {
        return this.numberOfTransactions;
    }

    public int getFrequency(Set<Item> transaction) {
        if (this.transactionFreqMap.get(transaction) != null) {
            return this.transactionFreqMap.get(transaction);
        }
        return -1;
    }

    public String toString() {
        String s = "";
        for (Set<Item> transaction : this.transactionFreqMap.keySet()) {
            s = s + transaction.toString() + ": " + this.transactionFreqMap.get(transaction) + "\n";
        }
        return s;
    }
}

