/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.krimp;

import com.rapidminer.krimp.Database;
import com.rapidminer.krimp.comparators.StandardCoverComparator;
import com.rapidminer.operator.ResultObjectAdapter;
import com.rapidminer.operator.learner.associations.FrequentItemSet;
import com.rapidminer.operator.learner.associations.Item;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.Tools;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.logging.Level;

public class CodeTable
extends ResultObjectAdapter
implements Iterable<FrequentItemSet>,
Cloneable {
    private static final long serialVersionUID = -2576984284405664369L;
    private final SortedMap<FrequentItemSet, Integer> usage;
    private final int usageSum;
    private final int suppSum;
    private final double compressedSize;

    private CodeTable(SortedMap<FrequentItemSet, Integer> usage, int usageSum, int suppSum, double compressedSize) {
        this.usage = usage;
        this.suppSum = suppSum;
        this.usageSum = usageSum;
        this.compressedSize = compressedSize;
    }

    public static CodeTable getStandardCodeTable(Database db) {
        int usageSum = db.getNumberOfStoredItems();
        double compressedSize = 0.0;
        TreeMap<FrequentItemSet, Integer> usage = new TreeMap<FrequentItemSet, Integer>(new StandardCoverComparator());
        for (Item item : db.getItems()) {
            if (item.getFrequency() <= 0) continue;
            FrequentItemSet itemSet = new FrequentItemSet();
            itemSet.addItem(item, item.getFrequency());
            usage.put(itemSet, item.getFrequency());
        }
        compressedSize = CodeTable.compressedSize(usage, usageSum, usageSum);
        return new CodeTable(usage, usageSum, usageSum, compressedSize);
    }

    public CodeTable getStandardCodeTable() {
        TreeMap<FrequentItemSet, Integer> usageST = new TreeMap<FrequentItemSet, Integer>();
        FrequentItemSet singleton = this.usage.lastKey();
        while (singleton != null && singleton.getNumberOfItems() == 1) {
            usageST.put(singleton, singleton.getFrequency());
            singleton = ((TreeMap)this.usage).lowerKey(singleton);
        }
        return new CodeTable(usageST, this.suppSum, this.suppSum, CodeTable.compressedSize(usageST, this.suppSum, this.suppSum));
    }

    public CodeTable addToCodingSet(FrequentItemSet newItemSet, Database db) {
        if (this.usage.keySet().contains(newItemSet)) {
            return this;
        }
        TreeMap<FrequentItemSet, Integer> newUsage = new TreeMap<FrequentItemSet, Integer>(new StandardCoverComparator());
        newUsage.putAll(this.usage);
        newUsage.put(newItemSet, 0);
        int newUsageSum = this.usageSum;
        for (Set<Item> transaction : db) {
            if (!transaction.containsAll(newItemSet.getItems())) continue;
            Set<FrequentItemSet> oldCover = this.cover(new HashSet<Item>(transaction), this.usage);
            Set<FrequentItemSet> newCover = this.cover(new HashSet<Item>(transaction), newUsage);
            for (FrequentItemSet x : oldCover) {
                newUsage.put(x, (Integer)newUsage.get(x) - db.getFrequency(transaction));
                newUsageSum -= db.getFrequency(transaction);
            }
            for (FrequentItemSet x : newCover) {
                newUsage.put(x, (Integer)newUsage.get(x) + db.getFrequency(transaction));
                newUsageSum += db.getFrequency(transaction);
            }
        }
        double newCompressedSize = CodeTable.compressedSize(newUsage, newUsageSum, this.suppSum);
        return new CodeTable(newUsage, newUsageSum, this.suppSum, newCompressedSize);
    }

    public CodeTable removeFromCodingSet(FrequentItemSet delItemSet) {
        if (!this.usage.keySet().contains(delItemSet)) {
            return this;
        }
        TreeMap<FrequentItemSet, Integer> newUsage = new TreeMap<FrequentItemSet, Integer>(new StandardCoverComparator());
        newUsage.putAll(this.usage);
        newUsage.remove(delItemSet);
        int newUsageSum = this.usageSum - (Integer)this.usage.get(delItemSet);
        Set<FrequentItemSet> delItemSetCover = this.cover(new HashSet<Item>(delItemSet.getItems()), newUsage);
        for (FrequentItemSet x : delItemSetCover) {
            newUsage.put(x, (Integer)newUsage.get(x) + (Integer)this.usage.get(delItemSet));
            newUsageSum += ((Integer)this.usage.get(delItemSet)).intValue();
        }
        double newCompressedSize = CodeTable.compressedSize(newUsage, newUsageSum, this.suppSum);
        return new CodeTable(newUsage, newUsageSum, this.suppSum, newCompressedSize);
    }

    private Set<FrequentItemSet> cover(Set<Item> transaction, SortedMap<FrequentItemSet, Integer> usage) {
        HashSet<FrequentItemSet> res = new HashSet<FrequentItemSet>();
        Iterator<FrequentItemSet> it = usage.keySet().iterator();
        while (it.hasNext() && !transaction.isEmpty()) {
            FrequentItemSet s = it.next();
            if (!transaction.containsAll(s.getItems())) continue;
            res.add(s);
            transaction.removeAll(s.getItems());
        }
        return res;
    }

    private static double compressedSize(SortedMap<FrequentItemSet, Integer> usage, int usageSum, int suppSum) {
        double size = 0.0;
        for (FrequentItemSet cItemSet : usage.keySet()) {
            if ((Integer)usage.get(cItemSet) == 0) continue;
            size += (double)((Integer)usage.get(cItemSet) + 1) * Math.log((double)usageSum / (double)((Integer)usage.get(cItemSet)).intValue());
            for (Item item : cItemSet.getItems()) {
                size += Math.log((double)suppSum / (double)item.getFrequency());
            }
        }
        return size / Math.log(2.0);
    }

    public double getCompressedSize() {
        return this.compressedSize;
    }

    public SortedSet<FrequentItemSet> getItemSets() {
        TreeSet<FrequentItemSet> returnSet = new TreeSet<FrequentItemSet>(new StandardCoverComparator());
        returnSet.addAll(this.usage.keySet());
        return returnSet;
    }

    public double getCodeLengthLeft(FrequentItemSet itemSet) {
        double size = 0.0;
        for (Item item : itemSet.getItems()) {
            size += Math.log((double)this.suppSum / (double)item.getFrequency());
        }
        return size / Math.log(2.0);
    }

    public double getCodeLengthRight(FrequentItemSet itemSet) {
        if (this.usage.get(itemSet) != null) {
            if ((Integer)this.usage.get(itemSet) == 0) {
                return 0.0;
            }
            return Math.log((double)this.usageSum / (double)((Integer)this.usage.get(itemSet)).intValue()) / Math.log(2.0);
        }
        return -1.0;
    }

    public int getNumberOfEntrys() {
        return this.usage.keySet().size();
    }

    public int getUsage(FrequentItemSet itemSet) {
        if (this.usage.get(itemSet) != null) {
            return (Integer)this.usage.get(itemSet);
        }
        LogService.getRoot().log(Level.WARNING, "The usage of itemsets that are not contained inside the code table is not defined, return -1.");
        return -1;
    }

    @Override
    public Iterator<FrequentItemSet> iterator() {
        return this.usage.keySet().iterator();
    }

    public String toString() {
        StringBuffer output = new StringBuffer("Code Table (" + this.usage.keySet().size() + "):" + Tools.getLineSeparator());
        for (FrequentItemSet set : this.usage.keySet()) {
            output.append(set.getItemsAsString());
            output.append(" / ");
            output.append(Tools.formatNumber((double)set.getFrequency()));
            output.append(" / ");
            output.append(Tools.formatNumber((double)((Integer)this.usage.get(set)).intValue()));
            output.append(Tools.getLineSeparator());
        }
        return output.toString();
    }

    public String toResultString() {
        return this.toString();
    }

    public Object clone() {
        return new CodeTable((SortedMap)((TreeMap)this.usage).clone(), this.usageSum, this.suppSum, this.compressedSize);
    }

    public void cleanUp() {
        for (FrequentItemSet itemSet : new HashSet<FrequentItemSet>(this.usage.keySet())) {
            if ((Integer)this.usage.get(itemSet) != 0) continue;
            this.usage.remove(itemSet);
        }
    }
}

