package com.rapidminer;

import javax.swing.JMenu;

import com.rapidminer.gui.MainFrame;
import com.rapidminer.gui.tools.ResourceMenu;
import com.rapidminer.repository.Repository;
import com.rapidminer.repository.RepositoryManager;
import com.rapidminer.repository.resource.ResourceRepository;
import com.rapidminer.tools.Tools;

/**
 * Die Initialisierungsklasse von RapidMiner fuer jede Extension. Die Methode werden
 * waehrend der Initialisierung von RapidMiner aufgerufen, um Konfiguration fuer das
 * Plugin vorzunehmen und z.B. neue GUI-Elemente hinzuzufuegen.
 */
public class PluginInitMDL {
	
	/**
	 * This method will be called directly after the extension is initialized.
	 * This is the first hook during start up. No initialization of the operators
	 * or renderers has taken place when this is called.
	 */
	public static void initPlugin() {}
	
	/**
	 * This method is called during start up as the second hook. It is 
	 * called before the gui of the mainframe is created. The Mainframe is 
	 * given to adapt the gui.
	 * The operators and renderers have been registered in the meanwhile.
	 */
	public static void initGui(MainFrame mainFrame) {
	}
	
	/**
	 * The last hook before the splash screen is closed. Third in the row.
	 */
	public static void initFinalChecks() {
	}

	/**
	 * Will be called as fourth method, directly before the UpdateManager is used
	 * for checking updates. Location for exchanging the UpdateManager. 
	 * The name of this method unfortunately is a result of a historical typo, so it's
	 * a little bit misleading.
	 */
	public static void initPluginManager() {}
}
