package com.rapidminer;

import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import com.rapidminer.gui.MainFrame;
import com.rapidminer.gui.tools.ResourceAction;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;

public class ExecuteTestAction extends ResourceAction {
	private static final long serialVersionUID = -2836978556530957075L;
	private final MainFrame mainFrame;

	public ExecuteTestAction(MainFrame mainFrame) {
		super("test.execute");
		this.mainFrame = mainFrame;

		setCondition(PROCESS_RUNNING, DISALLOWED);
		setCondition(EDIT_IN_PROGRESS, DISALLOWED);
	}

	@Override
	public void actionPerformed(ActionEvent e) {
		mainFrame.getProcess().getRootOperator()
				.addProcessListener(new ProcessListener() {
					@Override
					public void processStarts(Process process) {
					}

					@Override
					public void processStartedOperator(Process process,
							Operator op) {
					}

					@Override
					public void processFinishedOperator(Process process,
							Operator op) {
					}

					@Override
					public void processEnded(Process process) {
						process.getRootOperator().removeProcessListener(this);

						// Get IOObjects
						List<IOObject> expected;
						List<IOObject> actual;
						try {
							expected = com.rapidminer.test_utils.Util
									.getExpectedResult(process);
							actual = process.getRootOperator().getResults()
									.asList();
							com.rapidminer.test_utils.RapidAssert.assertSize(
									expected, actual);
						} catch (Exception e) {
							SwingTools.showSimpleErrorMessage("test-error", e);
							return;
						}

						Iterator<IOObject> expectedIter = expected.iterator();
						Iterator<IOObject> actualIter = actual.iterator();

						Map<Throwable, Integer> exceptions = new HashMap<Throwable, Integer>();

						int currentPort = 0;
						while (expectedIter.hasNext() && actualIter.hasNext()) {
							IOObject expectedIOO = expectedIter.next();
							IOObject actualIOO = actualIter.next();
							try {
								com.rapidminer.test_utils.RapidAssert
										.assertEquals(expectedIOO, actualIOO);
							} catch (Throwable e) {
								exceptions.put(e, currentPort);
							}
							currentPort++;
						}

						if (exceptions.isEmpty()) {
							SwingTools.showMessageDialog("test-successful");
						} else {
							SwingTools.showSimpleErrorMessage("test-error",
									exceptions.keySet().iterator().next());
						}
					}
				});
		mainFrame.runProcess();
	}

}
