/*
 * Decompiled with CFR 0.152.
 */
package timeseriesclustering.experiments;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import timeseriesclustering.DTW;
import timeseriesclustering.DataLogger;
import timeseriesclustering.DegeneratedClusteringException;
import timeseriesclustering.SakoeChibaBand;
import timeseriesclustering.TimeSeriesClustering;
import timeseriesclustering.averaging.AveragingTechnique;
import timeseriesclustering.averaging.EuclidianAveraging;
import timeseriesclustering.averaging.FastShapeBasedAveraging;
import timeseriesclustering.averaging.FixpointAveraging;
import timeseriesclustering.averaging.MedoidAveraging;
import timeseriesclustering.averaging.ProjectionAveraging;
import timeseriesclustering.dataimport.TimeSeriesLoader;
import timeseriesclustering.experiments.PermutationValidator;

public class HugeExperiment {
    public static void main(String[] args) {
        ArrayList<ArrayList<Double[]>> kMeans = null;
        ArrayList<String> filenames = new ArrayList<String>();
        for (File file : new File("datasets").listFiles()) {
            if (!file.isDirectory()) continue;
            for (File b : file.listFiles()) {
                if (!b.getPath().endsWith("TRAIN")) continue;
                filenames.add(b.getPath());
            }
        }
        Collections.shuffle(filenames);
        System.out.println(filenames.toString());
        AveragingTechnique[] averagingTechniques = new AveragingTechnique[]{new ProjectionAveraging(), new FixpointAveraging(), new FastShapeBasedAveraging(), new EuclidianAveraging(), new MedoidAveraging()};
        System.out.println();
        for (String name : filenames) {
            System.out.println(name);
            TimeSeriesClustering timeSeriesClustering = new TimeSeriesClustering();
            TimeSeriesLoader timeSeriesLoader = new TimeSeriesLoader(timeSeriesClustering, name);
            int averagerName = 0;
            for (AveragingTechnique averager : averagingTechniques) {
                System.out.println(averager.getClass().toString());
                DataLogger logger = new DataLogger();
                for (int i = 0; i < 50; ++i) {
                    DTW.count = 0.0;
                    try {
                        logger.logNewRun();
                        timeSeriesClustering.kMeans(timeSeriesLoader.cluster.keySet().size(), new SakoeChibaBand((int)((double)timeSeriesLoader.classes.keySet().iterator().next().length * 0.1)), 20, true, averager, logger);
                        kMeans = timeSeriesClustering.getClusters();
                        if (kMeans.size() < 10) {
                            double accuracy = new PermutationValidator().validate(timeSeriesLoader, kMeans);
                            System.out.println("Accuracy: " + accuracy);
                            logger.logAccuracy(accuracy);
                        } else {
                            System.out.println("Accuracy geht nicht");
                        }
                        logger.logEndRun();
                        System.gc();
                    }
                    catch (DegeneratedClusteringException ex) {
                        logger.logEndRun();
                        logger.logAccuracy(0.0);
                    }
                    logger.logDTWCount(DTW.count);
                }
                logger.exportCosts(name + averagerName + "costs.dat");
                logger.exportClusterSizes(name + averagerName + "endClusterSizes.dat");
                logger.exportIterations(name + averagerName + "iterations.dat");
                logger.exportFailures(name + averagerName + "failures.dat");
                if (timeSeriesLoader.cluster.keySet().size() <= 10) {
                    logger.exportAccuracy(name + averagerName + "accuracies.dat");
                }
                logger.exportDTWCount(name + averagerName + "dtwcount.dat");
                ++averagerName;
            }
        }
        System.out.println("Fertig");
        System.exit(0);
    }
}

