/*
 * Decompiled with CFR 0.152.
 */
package timeseriesclustering.dataimport;

import java.util.ArrayList;
import java.util.Random;
import timeseriesclustering.DTW;
import timeseriesclustering.GlobalConstraint;
import timeseriesclustering.SakoeChibaBand;
import timeseriesclustering.TimeSeriesClustering;
import timeseriesclustering.averaging.AveragingTechnique;
import timeseriesclustering.averaging.FixpointAveraging;

public class CylinderBellFunnel {
    public static Random r = new Random();
    public static int factor = 4;

    public static Double[] funnel() {
        int length = factor;
        Double[] ret = new Double[128 * length];
        int a = r.nextInt(16 * length) + 16 * length;
        int ba = r.nextInt(64 * length) + 32 * length;
        int b = ba + a;
        double delta = r.nextGaussian();
        for (int i = 0; i < 128 * length; ++i) {
            ret[i] = r.nextGaussian() * 0.25;
            if (a > i || i >= b) continue;
            Double[] doubleArray = ret;
            int n = i;
            Double.valueOf(doubleArray[n] + (6.0 + delta) * (double)(b - i) / (double)ba);
        }
        return ret;
    }

    public static Double[] bell() {
        Double[] ret = new Double[128 * factor];
        int a = r.nextInt(16 * factor) + 16 * factor;
        int ba = r.nextInt(64 * factor) + 32 * factor;
        int b = ba + a;
        double delta = r.nextGaussian();
        for (int i = 0; i < 128 * factor; ++i) {
            ret[i] = r.nextGaussian() * 0.25;
            if (a > i || i >= b) continue;
            Double[] doubleArray = ret;
            int n = i;
            Double.valueOf(doubleArray[n] + (6.0 + delta) * (double)(i - a) / (double)ba);
        }
        return ret;
    }

    public static Double[] cylinder() {
        Double[] ret = new Double[128 * factor];
        int a = r.nextInt(16 * factor) + 16 * factor;
        int ba = r.nextInt(64 * factor) + 32 * factor;
        int b = ba + a;
        double delta = r.nextGaussian();
        for (int i = 0; i < 128 * factor; ++i) {
            ret[i] = r.nextGaussian() * 0.25;
            if (a > i || i >= b) continue;
            Double[] doubleArray = ret;
            int n = i;
            Double.valueOf(doubleArray[n] + (6.0 + delta));
        }
        return ret;
    }

    public static void add(TimeSeriesClustering clusterer, int n) {
        factor = 2;
        ArrayList<Double[]> cluster1 = new ArrayList<Double[]>(n);
        ArrayList<Double[]> cluster2 = new ArrayList<Double[]>(n);
        ArrayList<Double[]> cluster3 = new ArrayList<Double[]>(n);
        for (int i = 0; i < n; ++i) {
            Double[] ts1 = CylinderBellFunnel.funnel();
            Double[] ts2 = CylinderBellFunnel.bell();
            Double[] ts3 = CylinderBellFunnel.cylinder();
            cluster1.add(TimeSeriesClustering.normalize(ts1));
            cluster2.add(TimeSeriesClustering.normalize(ts2));
            cluster3.add(TimeSeriesClustering.normalize(ts3));
            clusterer.addTimeSeries(TimeSeriesClustering.normalize(ts1));
            clusterer.addTimeSeries(TimeSeriesClustering.normalize(ts2));
            clusterer.addTimeSeries(TimeSeriesClustering.normalize(ts3));
        }
        SakoeChibaBand con = new SakoeChibaBand(64);
        int name = 0;
        for (AveragingTechnique t : new AveragingTechnique[]{new FixpointAveraging()}) {
            Double[] ts1 = t.average(cluster1, (Double[])cluster1.get(0), con);
            Double[] ts2 = t.average(cluster2, cluster1.get(0), con);
            Double[] ts3 = t.average(cluster3, cluster1.get(0), con);
            double sum = 0.0;
            for (Double[] a : cluster1) {
                sum += DTW.dtw((Double[])a, (Double[])ts1, (double)Double.POSITIVE_INFINITY, (double)0.0, null, null, (GlobalConstraint)con).distance;
            }
            for (Double[] a : cluster2) {
                sum += DTW.dtw((Double[])a, (Double[])ts2, (double)Double.POSITIVE_INFINITY, (double)0.0, null, null, (GlobalConstraint)con).distance;
            }
            for (Double[] a : cluster3) {
                sum += DTW.dtw((Double[])a, (Double[])ts3, (double)Double.POSITIVE_INFINITY, (double)0.0, null, null, (GlobalConstraint)con).distance;
            }
            System.out.println("Gesamtcluster bei idealer Wahl bez\u00ef\u00bf\u00bd\u00ef\u00bf\u00bdglich der echten Klassen: " + sum);
            ++name;
        }
    }
}

