/*
 * Decompiled with CFR 0.152.
 */
package timeseriesclustering.averaging;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import timeseriesclustering.DTW;
import timeseriesclustering.GlobalConstraint;
import timeseriesclustering.averaging.AveragingTechnique;

public class MedoidAveraging
extends AveragingTechnique {
    public int CACHE_SIZE = 4096;
    protected HashMap<SymmetricPair, Double> cache = new HashMap(this.CACHE_SIZE);

    private Double checkCache(Double[] a, Double[] b, GlobalConstraint con) {
        SymmetricPair lookup = new SymmetricPair(a, b);
        if (this.cache.containsKey(lookup)) {
            return this.cache.get(lookup);
        }
        if (this.cache.size() > this.CACHE_SIZE) {
            Set<SymmetricPair> keySet = this.cache.keySet();
            Iterator<SymmetricPair> iterator = keySet.iterator();
            while (iterator.hasNext()) {
                SymmetricPair p = iterator.next();
                if (!(Math.random() < 0.2)) continue;
                iterator.remove();
            }
        }
        Double dtw = DTW.dtw((Double[])b, (Double[])b, (double)Double.POSITIVE_INFINITY, (double)0.0, null, null, (GlobalConstraint)con).distance;
        this.cache.put(lookup, dtw);
        return dtw;
    }

    @Override
    public Double[] average(List<Double[]> cluster, Double[] oldCenter, GlobalConstraint con) {
        this.CACHE_SIZE = cluster.size() * cluster.size();
        double[][] blub = new double[cluster.size()][cluster.size()];
        double bestSum = Double.POSITIVE_INFINITY;
        int best = -1;
        for (int i = 0; i < cluster.size(); ++i) {
            for (int j = i; j < cluster.size(); ++j) {
                blub[i][j] = this.checkCache(cluster.get(i), cluster.get(j), con);
                blub[j][i] = blub[i][j];
            }
            double sum = 0.0;
            for (int j = 0; j < cluster.size(); ++j) {
                sum += blub[i][j];
            }
            if (!(sum < bestSum)) continue;
            best = i;
            bestSum = sum;
        }
        return (Double[])cluster.get(best).clone();
    }

    @Override
    public AveragingTechnique[] duplicateKTimes(int k) {
        AveragingTechnique[] ret = new AveragingTechnique[k];
        for (int i = 0; i < k; ++i) {
            ret[i] = new MedoidAveraging();
        }
        return ret;
    }

    private class SymmetricPair {
        public Double[] a;
        public Double[] b;

        public SymmetricPair(Double[] a, Double[] b) {
            this.a = a;
            this.b = b;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SymmetricPair other = (SymmetricPair)obj;
            if (this.a == other.a && this.b == other.b) {
                return true;
            }
            return this.a == other.b && this.b == other.a;
        }

        public int hashCode() {
            return this.a.hashCode() + this.b.hashCode();
        }
    }
}

