/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.AttributeRole;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.IOObjectCollection;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.metadata.CollectionMetaData;
import com.rapidminer.operator.ports.metadata.MDTransformationRule;
import com.rapidminer.operator.ports.metadata.MetaData;
import com.rapidminer.operator.valueseries.Feature;
import com.rapidminer.operator.valueseries.ValueSeries;
import com.rapidminer.operator.valueseries.ValueSeriesData;
import com.rapidminer.operator.valueseries.ValueSeriesMetaData;
import com.rapidminer.operator.valueseries.Vector;
import com.rapidminer.tools.Ontology;
import java.util.ArrayList;
import java.util.Iterator;

public class LoadTimeSeriesFromExampleSet
extends Operator {
    private InputPort exampleSetInput = (InputPort)this.getInputPorts().createPort("example set");
    private OutputPort seriesOutput = (OutputPort)this.getOutputPorts().createPort("series");

    public LoadTimeSeriesFromExampleSet(OperatorDescription description) {
        super(description);
        this.getTransformer().addRule(new MDTransformationRule(){

            public void transformMD() {
                LoadTimeSeriesFromExampleSet.this.seriesOutput.deliverMD((MetaData)new CollectionMetaData((MetaData)new ValueSeriesMetaData()));
            }
        });
    }

    public void doWork() throws OperatorException {
        ExampleSet exampleSet = (ExampleSet)this.exampleSetInput.getData();
        if (exampleSet.size() < 1) {
            throw new UserError((Operator)this, 142, new Object[]{"1"});
        }
        IOObjectCollection test = new IOObjectCollection();
        for (Example example : exampleSet) {
            ArrayList<Vector> seriesData = new ArrayList<Vector>();
            Iterator it = exampleSet.getAttributes().iterator();
            ArrayList<Feature> features = new ArrayList<Feature>();
            while (it.hasNext()) {
                Attribute a = (Attribute)it.next();
                if (!Ontology.ATTRIBUTE_BLOCK_TYPE.isA(a.getBlockType(), 1) || !Ontology.ATTRIBUTE_BLOCK_TYPE.isA(a.getValueType(), 4)) continue;
                if (Double.isNaN(example.getValue(a))) {
                    this.log("Ende gefunden");
                    break;
                }
                seriesData.add(new Vector(example.getValue(a)));
            }
            Iterator ite = exampleSet.getAttributes().specialAttributes();
            while (ite.hasNext()) {
                AttributeRole a = (AttributeRole)ite.next();
                features.add(new Feature(a.getSpecialName(), example.getValue(a.getAttribute())));
            }
            ValueSeriesData series = new ValueSeriesData("series" + example.getId(), null, seriesData);
            ValueSeries s = new ValueSeries(series);
            s.addFeatures(features);
            test.add((IOObject)s);
        }
        this.seriesOutput.deliver((IOObject)test);
    }
}

