class RMProcess
  # base_process: the process file which is initially read and then modified by set_parameter
  #  the physical file will not be changed, only its contents in memory.
  #  It can be written to disk via write()
  def initialize base_process
    @base_process = base_process

    file = File.new base_process
    @doc = Document.new file
  end

  attr_reader :base_process

  def filename
    return File.basename(@base_process, ".rmp")
  end

  def path
    return File.path(@base_process) + "/"
  end

  def write filename
    dir = File.dirname(filename)
    system "mkdir -p #{dir}" unless File.exist? dir
    File.open filename, 'w' do |file|
      @doc.write file, 2
    end
  end

  def set_parameter operator_name, parameter_name, value, parameter_prefix = nil
    operators = XPath.match @doc, "//operator[@name='#{operator_name}']"
    raise "no operator named #{operator_name}" unless operators.size == 1

    operator = operators[0]
    if parameter_prefix
#      puts "parameter_prefix is #{parameter_prefix}"
      operator = XPath.match operator, parameter_prefix
      operator = operator[0]
    end
    parameters = XPath.match operator, "parameter[@key='#{parameter_name}']"
    if parameters.size != 1
      puts "Waring: no parameter named '#{parameter_name}' in '#{operator_name}'. Creating..."
      parameter = Element.new("parameter")
      parameter.attributes['key'] = parameter_name
      operator.add parameter
    else
      parameter = parameters[0]
    end
    parameter.attributes['value'] = value
  end
end
