# plot_captions: Hash, values either String oder Proc. If proc, the argument will be the
#   current groups [:parameters] hash. For caption: argument is the current filter_key
#   Allowed keys: title, subtitle, xaxis, yaxis, caption, filename, pdf_title
# plot_configuration: Hash, allowed keys:
#   xlim1, xlim2, ylim1, ylim2, width, height, legend_location, xdata, ydata,
#   gridx_step, gridy_step
#   all but xdata and ydata are Strings again, xdata and ydata are Procs which receive the
#   current key's data and must return an array of numbers.
def generic_plot groups, results_object, plot_captions, plot_configuration, exclude_filter_idx = [], filetype = :pdf
  con = Rserve::Connection.new

  puts "Plotting #{groups.size} graphs..."
  group_idx = 1
  groups.each do |group|
    puts group_idx
#    PP.pp group[:keys]
    group_idx += 1
    filter_keys = group[:keys]


    filename = plot_captions[:filename]
    filename = filename.call group if filename.is_a? Proc
    filename.gsub! /(\ |\.)/, '_'
    pdf_title = plot_captions[:pdf_title]
    pdf_title = pdf_title.call group if pdf_title.is_a? Proc
    title = plot_captions[:title]
    title = title.call group if title.is_a? Proc
    subtitle = plot_captions[:subtitle]
    subtitle = subtitle.call group if subtitle.is_a? Proc
    xaxis = plot_captions[:xaxis]
    xaxis = xaxis.call group if xaxis.is_a? Proc
    yaxis = plot_captions[:yaxis]
    yaxis = yaxis.call group if yaxis.is_a? Proc

    xlim1 = plot_configuration[:xlim1]
    xlim2 = plot_configuration[:xlim2]
    ylim1 = plot_configuration[:ylim1]
    ylim2 = plot_configuration[:ylim2]
    width = plot_configuration[:width] || 8
    height = plot_configuration[:height] || 6
    legend_location = plot_configuration[:legend_location] || 'bottomright'
    gridx_step = plot_configuration[:gridx_step]
    gridy_step = plot_configuration[:gridy_step]

    colors = ["darkgreen", "magenta", "darkorange", "blue", "red"]
    colors += ["green", "gold", "black"]
    colors += colors
    colors += colors


    con.eval "library(gplots)"

    if filetype == :pdf
      con.eval <<EOF
        pdf(file = "#{filename}.pdf",
          width = #{width}, height = #{height}, family = "Helvetica",
          title = "#{pdf_title}", fonts = NULL, version = "1.1",
          paper = "special", pointsize=10)
EOF
    elsif filetype == :png
      con.eval <<EOF
        png(filename = "#{filename}.png", width = 700, height = 700, pointsize = 12)
EOF
    end
    con.eval <<EOF
    plotCI(1,xlim=c(#{xlim1},#{xlim2}),ylim=c(#{ylim1},#{ylim2}),type='n',ann=FALSE)
    abline(v=(seq(#{xlim1},#{xlim2},#{gridx_step})), col="darkgray", lty="dotted")
    abline(h=(seq(#{ylim1},#{ylim2},#{gridy_step})), col="darkgray", lty="dotted")
EOF
#    plot(c(1),c(1),xlim=c(#{xlim1},#{xlim2}),ylim=c(#{ylim1},#{ylim2}),type='n',axes=TRUE,ann=FALSE)
    i = 0
    key_idx = -1
    captions = Array.new
    filter_keys.each do |filter_key|
      key_idx += 1
      if exclude_filter_idx.include? key_idx
        next
      end
      values = results_object[filter_key]

      xdata = plot_configuration[:xdata]
      xdata = xdata.call values if xdata.is_a? Proc
      ydata = plot_configuration[:ydata]
      ydata = ydata.call values if ydata.is_a? Proc
      ydata2 = plot_configuration[:ydata2]
      ydata2 = ydata2.call values if ydata2.is_a? Proc
      yerror = plot_configuration[:yerror]
      yerror = yerror.call values if yerror && yerror.is_a?(Proc)
#      PP.pp yerror

      ydata_new = []
      ydata.each {|y| ydata_new.push y.to_f}
      ydata = ydata_new
      if ydata2
        ydata2_new = []
        ydata2.each {|y| ydata2_new.push y.to_f}
        ydata2 = ydata2_new
      end
      xdata_new = []
      xdata.each {|x| xdata_new.push x.to_f}
      xdata = xdata_new

      con.assign "x", Rserve::REXP::Wrapper.wrap(xdata)
      con.assign "y", Rserve::REXP::Wrapper.wrap(ydata)
      con.assign "y2", Rserve::REXP::Wrapper.wrap(ydata2) if ydata2


#      puts i, colors[i]
      con.eval "points(x,y,type='o',pch='.',cex=1.5,col='#{colors[i]}')"
      con.eval "points(x,y2,type='o',pch='.',lty='dashed',cex=1.5,col='#{colors[i]}')" if ydata2
      if yerror
        yerror_new = []
        yerror.each {|y| yerror_new.push y.to_f}
        yerror = yerror_new
        con.assign "yerror", Rserve::REXP::Wrapper.wrap(yerror) if yerror
#        con.eval "plotCI(x,y,col='#{colors[i]}'#{", uiw=yerror"},type='l',add=TRUE)"
        con.eval "plotCI(x,y,col='#{colors[i]}'#{", uiw=yerror"},type='l',gap=0,add=TRUE)"
      end

      caption = plot_captions[:caption]
      caption = caption.call(filter_key) if caption.is_a? Proc
      captions.push caption
      i += 1
    end
    r_captions = Array.new
    r_colors = Array.new
    captions.each {|c| r_captions.push c.to_s}
    captions.size.times{|i| r_colors.push colors[i]}
    con.assign "captions", Rserve::REXP::Wrapper.wrap(r_captions)
    con.assign "colors", Rserve::REXP::Wrapper.wrap(r_colors)
    con.eval("title(main='#{title}')") if title

    con.eval <<EOF
    legend('#{legend_location}', captions, col=colors, lty=1, bg='white')
    title(sub='#{subtitle}')
    title(xlab='#{xaxis}')
    title(ylab='#{yaxis}')
    dev.off()
EOF
  end
end

def plot_bbc_sql_fuzzy_svm_one_sampling_interval_different_training_sizes conf, lresult_dir
  puts "plot_bbc_sql_fuzzy_svm_one_sampling_interval_different_training_sizes"

  bbc_sql_xval_creator = job_creator_bbcxval_sql_fuzzy_svm(conf, "svm_sql_new_")

  results_object = bbc_sql_xval_creator.variation.get_results_object("#{lresult_dir}/generated_processes")

  iter = results_object.filter(
    {
#      "Inner Learner.process_location" => [
#          "//Diplomarbeit/struktur/prozesse/model_creation/j48",
#          "//Diplomarbeit/struktur/prozesse/model_creation/weka-ds",
#        ],
#      "Bayesian Boosting SQL.new_sample_interval" => :all,
      "Read Examples.Sampling Properties.gamma_count" => :all
    },
    [
      "Read Examples.Sampling Properties.gamma_count",
      "Bayesian Boosting SQL.fuzzy_partition_sizes",
      "Bayesian Boosting SQL.fuzzy_reweighting",
    ]
  )

  groups = ResultsObject.group_keys(iter,
    [
      "Bayesian Boosting SQL.new_sample_interval",
      "Inner Learner.process_location",
      "Read Examples.Sampling Properties.gamma_count",
    ])

  plot_captions = {}
  inner_learner = lambda{|p| File.basename p[:parameters]["Inner Learner.process_location"]}
  title = lambda{|p| "Ada2Boost++ with #{inner_learner.call p} (#{p[:parameters]["Read Examples.Sampling Properties.gamma_count"]} examples; r=#{p[:parameters]["Bayesian Boosting SQL.new_sample_interval"]})"}
  plot_captions[:filename] = lambda{|p| "~/office/uni/Diplomarbeit/plots/bay_boost_sql_sampling_interval_#{p[:parameters]["Bayesian Boosting SQL.new_sample_interval"]}_#{inner_learner.call p}_#{p[:parameters]["Read Examples.Sampling Properties.gamma_count"]}"}
  plot_captions[:pdf_title] = title
  plot_captions[:title] = title
#  plot_captions[:subtitle] = lambda{|p| "r=#{p[:parameters]["Bayesian Boosting SQL.new_sample_interval"]}"}
  plot_captions[:xaxis] = "iterations"
  plot_captions[:yaxis] = "AUC"
  plot_captions[:caption] = lambda{|p| "#{p["Read Examples.Sampling Properties.gamma_count"]}"}

  plot_captions[:caption] = lambda{|p|
      excount = p["Read Examples.Sampling Properties.gamma_count"].to_i * 2
#      inner_learner = File.basename p["Train Model.Inner Learner.process_location"]
      fuzzy_reweighting = p["Bayesian Boosting SQL.fuzzy_reweighting"]
      fuzzy_set_size = p["Bayesian Boosting SQL.fuzzy_partition_sizes"]
      "#{excount}#{", frw" if fuzzy_reweighting}#{", fss" if fuzzy_set_size}"
  }



  plot_configuration = {}
  plot_configuration[:xlim1] = 0
  plot_configuration[:xlim2] = 150
  plot_configuration[:ylim1] = 0.0
  plot_configuration[:ylim2] = 1.0
  plot_configuration[:width] = 8
  plot_configuration[:height] = 6
  plot_configuration[:legend_location] = 'bottomright'
  plot_configuration[:gridx_step] = 25
  plot_configuration[:gridy_step] = 0.05
  plot_configuration[:xdata] = lambda{|v| v["result.log"][:columns]["iterations"]}
  plot_configuration[:ydata] = lambda{|v| v["result.log"][:columns]["auc"]}

  generic_plot(groups, results_object, plot_captions, plot_configuration)
end

# which value: one of :auc, :prec
def plot_bbc_sql_one_sampling_interval_different_training_sizes conf, lresult_dir, which_value
  puts "plot_bbc_sql_one_sampling_interval_different_training_sizes"

  bbc_sql_xval_creator = job_creator_bbcxval_sql_fuzzy(conf, "bbc_fuzzy_sql_new_")

  results_object = bbc_sql_xval_creator.variation.get_results_object("#{lresult_dir}/generated_processes")

  iter = results_object.filter(
    {
#      "Inner Learner.process_location" => [
#          "//Diplomarbeit/struktur/prozesse/model_creation/j48",
#          "//Diplomarbeit/struktur/prozesse/model_creation/weka-ds",
#        ],
      "Bayesian Boosting SQL.new_sample_interval" => :all
    },
    [
      "Read Examples.Sampling Properties.gamma_count",
      "Bayesian Boosting SQL.fuzzy_partition_sizes",
      "Bayesian Boosting SQL.fuzzy_reweighting",
    ]
  )

  colors = ["darkgreen", "magenta", "darkorange", "blue", "red"]
  colors += ["red", "green", "blue", "yellow", "black"]

  groups = ResultsObject.group_keys(iter,
    [
      "Read Examples.Sampling Properties.gamma_count",
      "Bayesian Boosting SQL.new_sample_interval",
      "Inner Learner.process_location",
    ])

  plot_captions = {}
  inner_learner = lambda{|p| File.basename p[:parameters]["Inner Learner.process_location"]}
  title = lambda{|p| "VLDS-Ada2Boost mit #{inner_learner.call p} (#{p[:parameters]["Read Examples.Sampling Properties.gamma_count"]*2} Beispielen; R=#{p[:parameters]["Bayesian Boosting SQL.new_sample_interval"]})"}
  plot_captions[:filename] = lambda{|p| "~/office/uni/Diplomarbeit/plots/bay_boost_sql_sampling_interval_#{p[:parameters]["Bayesian Boosting SQL.new_sample_interval"]}_#{inner_learner.call p}_#{which_value.to_s}_#{p[:parameters]["Read Examples.Sampling Properties.gamma_count"]*2}"}
  plot_captions[:pdf_title] = title
  plot_captions[:title] = title
#  plot_captions[:subtitle] = lambda{|p| "r=#{p[:parameters]["Bayesian Boosting SQL.new_sample_interval"]}"}
  plot_captions[:xaxis] = "Iterationen"
#  plot_captions[:caption] = lambda{|p| "#{p["Read Examples.Sampling Properties.gamma_count"]}"}
  plot_captions[:caption] = lambda{|p|
      excount = p["Read Examples.Sampling Properties.gamma_count"].to_i * 2
#      inner_learner = File.basename p["Train Model.Inner Learner.process_location"]
      fuzzy_reweighting = p["Bayesian Boosting SQL.fuzzy_reweighting"]
      fuzzy_set_size = p["Bayesian Boosting SQL.fuzzy_partition_sizes"]
      "#{excount}#{", frw" if fuzzy_reweighting}#{", fss" if fuzzy_set_size}"
  }


  plot_configuration = {}
  plot_configuration[:xlim1] = 0
  plot_configuration[:xlim2] = 200
  if which_value == :auc
    plot_configuration[:ylim1] = 0.92
    plot_configuration[:ylim2] = 1.0
    plot_configuration[:ydata] = lambda{|v| v["result.log"][:columns]["auc"]}
    plot_captions[:yaxis] = "AUC"
    plot_configuration[:gridy_step] = 0.005
  elsif which_value == :prec
    plot_configuration[:ylim1] = 0.5
    plot_configuration[:ylim2] = 0.9
    plot_configuration[:ydata] = lambda{|v| v["result.log"][:columns]["precision"]}
    plot_configuration[:ydata2] = lambda{|v| v["result.log"][:columns]["recall"]}
    plot_captions[:yaxis] = "Precision, Recall"
    plot_configuration[:gridy_step] = 0.05
  end
  plot_configuration[:width] = 8
  plot_configuration[:height] = 6
  plot_configuration[:legend_location] = 'bottomright'
  plot_configuration[:gridx_step] = 25
  plot_configuration[:xdata] = lambda{|v| v["result.log"][:columns]["iterations"]}

  generic_plot(groups, results_object, plot_captions, plot_configuration)
end



def plot_binning_selection_fw conf, lresult_dir
  jc = job_creator_forward_binning_selection(conf, "bs_")
  plot_binning_selection_fw_bw(conf, lresult_dir, jc, "fw")
end

def plot_binning_selection_bw conf, lresult_dir
  jc = job_creator_backward_binning_selection(conf, "bs_")
  plot_binning_selection_fw_bw(conf, lresult_dir, jc, "bw")
end

def plot_binning_selection_evo conf, lresult_dir
  jc = job_creator_evo_binning_selection(conf, "bs_")
  plot_binning_selection_fw_bw(conf, lresult_dir, jc, "evo")
end

def plot_binning_selection_fw_bw conf, lresult_dir, jc, fw_bw_str
  puts "plot_binning_selection_fw_bw"

  results_object = jc.variation.get_results_object("#{lresult_dir}/generated_processes")
  PP.pp results_object.keys[0]

  results_object.merge_results "Read Examples.Configure Binning.bin_count", "result.log"

  puts "SIZE:"
  puts results_object.size

  result_keys = results_object.filter(
    {
    },
    ["Read Examples.Read Examples.Sampling Properties.gamma_count"]
  )


  groups = ResultsObject.group_keys(result_keys,
    [
#      "Train Model.process_location",
      "Train Model.base_process",
      "Read Examples.Configure Binning.min_bin_value",
      "Read Examples.Read Examples.base_process",
    ])

  plot_captions = {}
  plot_captions[:filename] = lambda{|p|
    model = p[:keys][0]["Train Model.Train Inner Learner.base_process"]
    if model
      model = File.basename p[:keys][0]["Train Model.Train Inner Learner.base_process"], ".rmp"
      if model == "bbc"
        model = "Ada2Boost with #{File.basename p[:keys][0]["Train Model.Train Inner Learner.Inner Learner.process_location"], ".rmp"}"
      end
    else
      model = File.basename p[:keys][0]["Train Model.Train Inner Learner.process_location"], ".rmp"
    end
    "~/office/uni/Diplomarbeit/plots/binning_selection_#{fw_bw_str}_#{model}_#{File.basename p[:parameters]["Read Examples.Read Examples.base_process"], ".rmp"}_#{p[:parameters]["Read Examples.Configure Binning.min_bin_value"]}"
  }

  title = lambda{|p|
    model = p[:keys][0]["Train Model.Train Inner Learner.base_process"]
    if model
      model = File.basename p[:keys][0]["Train Model.Train Inner Learner.base_process"], ".rmp"
      if model == "bbc"
        model = "Ada2Boost with #{File.basename p[:keys][0]["Train Model.Train Inner Learner.Inner Learner.process_location"], ".rmp"}"
      end
    else
      model = File.basename p[:keys][0]["Train Model.Train Inner Learner.process_location"], ".rmp"
    end
    "Binning Selection (#{fw_bw_str}) with #{model}"
  }

  plot_captions[:pdf_title] = title
  plot_captions[:title] = title
  plot_captions[:subtitle] = "" #lambda{|p| "r=#{p["Bayesian Boosting SQL.new_sample_interval"]}"}
  plot_captions[:xaxis] = "initial bin count"
  plot_captions[:yaxis] = "AUC"
  plot_captions[:caption] = lambda{|p| "#{(p["Read Examples.Read Examples.Sampling Properties.gamma_count"].to_i()*2).to_s}"}

  plot_configuration = {}
  plot_configuration[:xlim1] = 0
  plot_configuration[:xlim2] = 90
  plot_configuration[:ylim1] = 0.8
  plot_configuration[:ylim2] = 1.0
  plot_configuration[:width] = 8
  plot_configuration[:height] = 6
  plot_configuration[:legend_location] = 'bottomright'
  plot_configuration[:gridx_step] = 10
  plot_configuration[:gridy_step] = 0.05
  plot_configuration[:xdata] = lambda{ |v| v["result.log"][:merged]["Read Examples.Configure Binning.bin_count"][:columns][:x] }
  plot_configuration[:ydata] = lambda{ |v| v["result.log"][:merged]["Read Examples.Configure Binning.bin_count"][:columns]["auc"] }

  generic_plot(groups, results_object, plot_captions, plot_configuration)
end




def plot_binning_eval conf, llog_directory, rresult_dir, lresult_dir
  puts "plot_binning_evaluation"
  evo_binning_selection = job_creator_evo_binning_selection conf, "bs_"
  fw_binning_selection = job_creator_forward_binning_selection conf, "bs_"
  bw_binning_selection = job_creator_backward_binning_selection conf, "bs_"

#  evo_filenames = evo_binning_selection.filenames

    binning_selectors = [
      evo_binning_selection,
      fw_binning_selection,
      bw_binning_selection,
    ]
  jc = job_creator_binning_eval conf, llog_directory, binning_selectors, "be_new_", rresult_dir
#  PP.pp jc
#  puts "#{lresult_dir}/generated_processes"
  results_object = jc.variation.get_results_object("#{lresult_dir}/generated_processes")
#  PP.pp results_object
#  PP.pp results_object.keys[0]

  results_object.merge_results "Read Examples.Sampling Properties.gamma_count", "result.log"

  puts "SIZE:"
  puts results_object.size
#  PP.pp results_object

  result_keys = results_object.filter(
    {
      "Train Inner Learner.Bayesian Boosting.fuzzy_reweighting" => false,
#      "Train Inner Learner.Inner Learner.process_location" => "//Diplomarbeit/struktur/prozesse/model_creation/weka-ds"
    },
    [
      "Train Inner Learner.Inner Learner.process_location",
      "Train Inner Learner.Bayesian Boosting.fuzzy_partition_sizes",
      "Train Inner Learner.Bayesian Boosting.fuzzy_reweighting",
    ]
  )

  groups = ResultsObject.group_keys(result_keys,
    [
      "Read Limits.data_file",
#      "Train Inner Learner.base_process",
#      "Train Inner Learner.Bayesian Boosting.fuzzy_reweighting",
#      "Train Inner Learner.Bayesian Boosting.fuzzy_partition_sizes",
    ])

  puts groups.size
#  puts groups[0].size
#  return

  plot_captions = {}
  plot_captions[:filename] = lambda{|p|
    datafile = p[:keys][0]["Read Limits.data_file"]
    datafile = datafile.gsub '/home/mhelf/results/generated_processes/', ''
    datafile = datafile.gsub 'Read_Examples.process_location.bs_linear_discretization/Configure_Binning.min_bin_value.1.03109120412576/', ''
    datafile = datafile.gsub 'Configure_Binning.bin_count.', 'bin_count_'
    datafile = datafile.gsub 'Read_Examples.process_location.bs_sql_Zd_10_40_maxHeight_greater0/Sampling_Properties.gamma_count.', 'gamma_count_'
    datafile = datafile.gsub '/Train_Model.process_location.bs_combined_model/Train_Inner_Learner.process_location.j48/limits.arff', ''
    datafile = datafile.gsub 'bs_', ''
    datafile = datafile.gsub '/', '__'
    datafile = datafile.gsub 'feature_selection_', ''
    filename = "~/office/uni/Diplomarbeit/plots/binning_eval_#{datafile}"
    filename
  }

  title = lambda{|p|
    datafile = p[:keys][0]["Read Limits.data_file"]
    datafile = datafile.gsub '/home/mhelf/results/generated_processes/', ''
    datafile = datafile.gsub 'Read_Examples.process_location.bs_linear_discretization/Configure_Binning.min_bin_value.1.03109120412576/', ''
    datafile = datafile.gsub 'Configure_Binning.bin_count.', 'bin_count_'
    datafile = datafile.gsub 'Read_Examples.process_location.bs_sql_Zd_10_40_maxHeight_greater0/Sampling_Properties.gamma_count.', 'gamma_count_'
    datafile = datafile.gsub '/Train_Model.process_location.bs_combined_model/Train_Inner_Learner.process_location.j48/limits.arff', ''
    datafile = datafile.gsub 'bs_', ''
    datafile = datafile.gsub '/', '__'
    datafile = datafile.gsub 'feature_selection_', ''
    datafile = datafile.gsub 'binning_eval_', 'Binning Model with Ada2Boost'
    datafile = datafile.gsub 'bin_count_', ''
    datafile = datafile.gsub 'gamma_count_', ''

    filename = "binning_eval_#{datafile}"
    filename
    "Binning-Modell mit Ada2Boost"
  }

  subtitle = lambda{|p|
    datafile = p[:keys][0]["Read Limits.data_file"]
    datafile = datafile.gsub '/home/mhelf/results/generated_processes/', ''
    datafile = datafile.gsub 'Read_Examples.process_location.bs_linear_discretization/Configure_Binning.min_bin_value.1.03109120412576/', ''
    datafile = datafile.gsub 'Configure_Binning.bin_count.', 'bin_count_'
    datafile = datafile.gsub 'Read_Examples.process_location.bs_sql_Zd_10_40_maxHeight_greater0/Sampling_Properties.gamma_count.', 'gamma_count_'
    datafile = datafile.gsub '/Train_Model.process_location.bs_combined_model/Train_Inner_Learner.process_location.j48/limits.arff', ''
    datafile = datafile.gsub 'bs_', ''
    datafile = datafile.gsub '/', '__'
    datafile = datafile.gsub 'feature_selection_', ''
    datafile = datafile.gsub 'binning_eval_', ''
    datafile = datafile.gsub '__bin_count_', '-Merkmalsselektion auf '
    datafile = datafile.gsub '__gamma_count_', ' Start-Bins, '

    filename = "Binning erzeugt mit #{datafile} Beispielen"
    filename
  }

  plot_captions[:pdf_title] = title
#  plot_captions[:title] = title
#  plot_captions[:subtitle] = subtitle
  plot_captions[:xaxis] = "Anzahl Beispiele"
  plot_captions[:yaxis] = "AUC"
#  plot_captions[:caption] = lambda{|p| "#{(p["Read Examples.Read Examples.Sampling Properties.gamma_count"].to_i()*2).to_s}"}
    plot_captions[:caption] = lambda{|p|
      model = File.basename p["Train Inner Learner.Inner Learner.process_location"]
      fuzzy_reweighting = p["Train Inner Learner.Bayesian Boosting.fuzzy_reweighting"]
      fuzzy_set_size = p["Train Inner Learner.Bayesian Boosting.fuzzy_partition_sizes"]
      "#{model}#{"; frw" if fuzzy_reweighting}#{", fss" if fuzzy_set_size}"
  }


  plot_configuration = {}
  plot_configuration[:xlim1] = 60000
  plot_configuration[:xlim2] = 210000
  plot_configuration[:ylim1] = 0.95
  plot_configuration[:ylim2] = 0.98
  plot_configuration[:width] = 4
  plot_configuration[:height] = 4
  plot_configuration[:legend_location] = 'bottomright'
  plot_configuration[:gridx_step] = 10000
  plot_configuration[:gridy_step] = 0.005
  plot_configuration[:xdata] = lambda{ |v|
    xdata  = []
    v["result.log"][:merged]["Read Examples.Sampling Properties.gamma_count"][:columns][:x].each{ |x| xdata.push x*2}
    xdata
  }
  plot_configuration[:ydata] = lambda{ |v| v["result.log"][:merged]["Read Examples.Sampling Properties.gamma_count"][:columns]["auc"] }
  plot_configuration[:yerror] = lambda{ |v| v["result.log"][:merged]["Read Examples.Sampling Properties.gamma_count"][:columns]["auc_stddev"] }

  generic_plot(groups, results_object, plot_captions, plot_configuration, [], :pdf)
end





def plot_linear_binning_no_optimization conf, lresult_dir
  puts "plot_linear_binning_no_optimization"

  jc = job_creator_stdxval_with_binning(conf, "linear_binning_")

  results_object = jc.variation.get_results_object("#{lresult_dir}/generated_processes")

#  f1 = results_object.filter(
#    {
#      "Train Model.Train Inner Learner.base_process" => "/home/mhelf/office/uni/Diplomarbeit/git/rapidminer-repo/struktur/prozesse/model_creation/bbc.rmp"
#    }
#  )
#  results_object.merge_results "Read Examples.Configure Binning.bin_count", "result.log", :x, true, f1

  f2 = results_object.filter(
    {
      "Train Model.Train Inner Learner.process_location"=> [
        "//Diplomarbeit/struktur/prozesse/model_creation/j48",
        "//Diplomarbeit/struktur/prozesse/model_creation/naive-bayes",
      ]
    }
  )
  results_object.merge_results "Read Examples.Configure Binning.bin_count", "result.log", :x, true, f2
  puts "SIZE:"
  puts results_object.size

  result_keys = results_object.filter(
    {
      "Read Examples.Read Examples.Sampling Properties.gamma_count" =>  [
        5000,
        30000,
        45000,
        75000,
        105000
      ],
      "Train Model.Train Inner Learner.process_location"=> [
        "//Diplomarbeit/struktur/prozesse/model_creation/j48",
        "//Diplomarbeit/struktur/prozesse/model_creation/naive-bayes",
      ],
    },
    ["Read Examples.Read Examples.Sampling Properties.gamma_count"]
  )


  groups = ResultsObject.group_keys(result_keys,
    [
      "Train Model.process_location",
      "Read Examples.Configure Binning.min_bin_value",
      "Read Examples.Read Examples.base_process",
    ])

  plot_captions = {}
  plot_captions[:filename] = lambda{|p|
    model = p[:keys][0]["Train Model.Train Inner Learner.base_process"]
#    puts model
    if model
      model = File.basename p[:keys][0]["Train Model.Train Inner Learner.base_process"], ".rmp"
      if model == "bbc"
        model = "Ada2Boost with #{File.basename p[:keys][0]["Train Model.Train Inner Learner.Inner Learner.process_location"], ".rmp"}"
      end
    else
      model = File.basename p[:keys][0]["Train Model.Train Inner Learner.process_location"], ".rmp"
    end
    "~/office/uni/Diplomarbeit/plots/linear_binning_no_optimization_#{model}_#{File.basename p[:parameters]["Read Examples.Read Examples.base_process"], ".rmp"}_#{p[:parameters]["Read Examples.Configure Binning.min_bin_value"]}"
  }

  title = lambda{|p|
    model = p[:keys][0]["Train Model.Train Inner Learner.base_process"]
    if model
      model = File.basename p[:keys][0]["Train Model.Train Inner Learner.base_process"], ".rmp"
      if model == "bbc"
        model = "Ada2Boost with #{File.basename p[:keys][0]["Train Model.Train Inner Learner.Inner Learner.process_location"], ".rmp"}"
      end
    else
      model = File.basename p[:keys][0]["Train Model.Train Inner Learner.process_location"], ".rmp"
    end
    "Äquidistantes Binning mit #{model}"
  }

  plot_captions[:pdf_title] = title
  plot_captions[:title] = title
  plot_captions[:subtitle] = "" #lambda{|p| "r=#{p["Bayesian Boosting SQL.new_sample_interval"]}"}
  plot_captions[:xaxis] = "#Bins"
  plot_captions[:yaxis] = "AUC"
  plot_captions[:caption] = lambda{|p| "#{(p["Read Examples.Read Examples.Sampling Properties.gamma_count"].to_i()*2).to_s} Bsp."}

  plot_configuration = {}
  plot_configuration[:xlim1] = 0
  plot_configuration[:xlim2] = 90
  plot_configuration[:ylim1] = 0.80
  plot_configuration[:ylim2] = 1.00
  plot_configuration[:width] = 8
  plot_configuration[:height] = 6
  plot_configuration[:legend_location] = 'bottomleft'
  plot_configuration[:gridx_step] = 10
  plot_configuration[:gridy_step] = 0.05
  plot_configuration[:xdata] = lambda{ |v| v["result.log"][:merged]["Read Examples.Configure Binning.bin_count"][:columns][:x] }
  plot_configuration[:ydata] = lambda{ |v| v["result.log"][:merged]["Read Examples.Configure Binning.bin_count"][:columns]["auc"] }
  plot_configuration[:yerror] = lambda{ |v| v["result.log"][:merged]["Read Examples.Configure Binning.bin_count"][:columns]["auc_stddev"] }

  generic_plot(groups, results_object, plot_captions, plot_configuration)
end



def plot_weka_rf_different_training_sizes conf, lresult_dir
  puts "plot_weka_rf_different_training_sizes"
  job_creator = job_creator_stdxval_with_weka_rf(conf, "weka_rf_")

  results_object = job_creator.variation.get_results_object("#{lresult_dir}/generated_processes")

#  PP.pp results_object.keys[0]

  results_object.merge_results "Train Model.W-RandomForest.I", "result.log"
#  puts "SIZE:"
#  puts results_object.size

  result_keys = results_object.filter(
    {
#      "Read Examples.Sampling Properties.gamma_count" => [
#        1000,
#        30000,
#        45000,
#        75000,
#        105000,
#      ]
      "Read Examples.Sampling Properties.gamma_count" => [
        1000,
        5000,
        15000,
        60000,
        105000,
      ]
    },
    ["Read Examples.Sampling Properties.gamma_count"]
  )


  groups = ResultsObject.group_keys(result_keys,
    [
      "Train Model.W-RandomForest.depth",
      "Read Examples.base_process",
    ])
  

  plot_captions = {}
#  plot_captions[:filename] = lambda{|p|
#    tree_count = "Train Model.W-RandomForest.I"
#    "~/office/uni/Diplomarbeit/plots/linear_binning_no_optimization_#{model}_#{File.basename p[:parameters]["Read Examples.Read Examples.base_process"], ".rmp"}_#{p[:parameters]["Read Examples.Configure Binning.min_bin_value"]}"
#  }
  plot_captions[:filename] = lambda{|p| "~/office/uni/Diplomarbeit/plots/rf_#{p[:parameters]["Read Examples.base_process"]}_depth_#{p[:parameters]["Train Model.W-RandomForest.depth"]}"}

#  title = lambda{|p|
#    model = p[:keys][0]["Train Model.Train Inner Learner.base_process"]
#    if model
#      model = File.basename p[:keys][0]["Train Model.Train Inner Learner.base_process"], ".rmp"
#      if model == "bbc"
#        model = "Ada2Boost with #{File.basename p[:keys][0]["Train Model.Train Inner Learner.Inner Learner.process_location"], ".rmp"}"
#      end
#    else
#      model = File.basename p[:keys][0]["Train Model.Train Inner Learner.process_location"], ".rmp"
#    end
#    "Linear Binning with #{model}"
#  }
  title = lambda{|p|
    depth = p[:parameters]["Train Model.W-RandomForest.depth"]
    "Weka Random Forest#{" (depth = #{depth})" unless depth == 0}"
  }

  plot_captions[:pdf_title] = title
  plot_captions[:title] = title
  plot_captions[:subtitle] = "" #lambda{|p| "r=#{p["Bayesian Boosting SQL.new_sample_interval"]}"}
  plot_captions[:xaxis] = "tree count"
  plot_captions[:yaxis] = "AUC"
  plot_captions[:caption] = lambda{|p| "#{(p["Read Examples.Sampling Properties.gamma_count"].to_i()*2).to_s} examples"}

  plot_configuration = {}
  plot_configuration[:xlim1] = 20
  plot_configuration[:xlim2] = 100
  plot_configuration[:ylim1] = 0.92
  plot_configuration[:ylim2] = 1.0
  plot_configuration[:width] = 8
  plot_configuration[:height] = 6
  plot_configuration[:legend_location] = 'bottomright'
  plot_configuration[:gridx_step] = 10
  plot_configuration[:gridy_step] = 0.01
  plot_configuration[:xdata] = lambda{ |v| v["result.log"][:merged]["Train Model.W-RandomForest.I"][:columns][:x] }
  plot_configuration[:ydata] = lambda{ |v| v["result.log"][:merged]["Train Model.W-RandomForest.I"][:columns]["auc"] }
  plot_configuration[:yerror] = lambda{ |v| v["result.log"][:merged]["Train Model.W-RandomForest.I"][:columns]["auc_stddev"] }

  generic_plot(groups, results_object, plot_captions, plot_configuration)
end

# which_value: one of :auc, :prec
def plot_ada2boost_different_training_sizes_gs conf, lresult_dir, which_value
  puts "plot_ada2boost_different_training_sizes"
  adaboost_xval_creator = job_creator_bbcxval(conf, "")

  results_object = adaboost_xval_creator.variation.get_results_object("#{lresult_dir}/generated_processes")

#  puts "result object:"
#  PP.pp ro
  PP.pp results_object.keys[0]

  result_keys = results_object.filter({
      "Train Model.base_process" => [
        "bbc_fuzzy",
#        "bbc", # not necessary, same as fuzzy without frw and fss
      ],
      "Read Examples.base_process" => "sql_Zd_10_40_maxHeight_greater0",
#      "Read Examples.Sampling Properties.gamma_count" => [
#        "15000",
#        "45000",
#        "75000",
#        "105000",
#      ]
    },
    [
      "Train Model.Inner Learner.process_location",
      "Read Examples.Sampling Properties.gamma_count",
      "Train Model.Bayesian Boosting.fuzzy_partition_sizes",
      "Train Model.Bayesian Boosting.fuzzy_reweighting",
    ]
  )
#  return
#  puts "ITER:"
#  PP.pp iter
#  puts "END ITER"


  groups = ResultsObject.group_keys(result_keys,
    [
      "Read Examples.Sampling Properties.gamma_count",
    ])

  plot_captions = {}
  plot_captions[:filename] = lambda{|p|
    ex_count = p[:parameters]["Read Examples.Sampling Properties.gamma_count"].to_i * 2
    filename = "~/office/uni/Diplomarbeit/plots/ada2boost_Zd_10_40"
    if which_value == :auc
      filename += "_auc"
    elsif which_value == :prec
      filename += "_prec"
    end
    filename += "_#{ex_count}_examples"
    filename
  }

  title = lambda{|p|
    ex_count = p[:parameters]["Read Examples.Sampling Properties.gamma_count"].to_i * 2
    "Fuzzy Ada2Boost mit #{ex_count} Beispielen"
  }

  plot_captions[:pdf_title] = title
  plot_captions[:title] = title
  plot_captions[:subtitle] = "" #lambda{|p| "r=#{p["Bayesian Boosting SQL.new_sample_interval"]}"}
  plot_captions[:xaxis] = "Iterationen"
  plot_captions[:caption] = lambda{|p|
      inner_learner = File.basename p["Train Model.Inner Learner.process_location"]
      fuzzy_reweighting = p["Train Model.Bayesian Boosting.fuzzy_reweighting"]
      fuzzy_set_size = p["Train Model.Bayesian Boosting.fuzzy_partition_sizes"]
      "#{inner_learner}#{", frw" if fuzzy_reweighting}#{", fss" if fuzzy_set_size}"
  }

  plot_configuration = {}
  plot_configuration[:xlim1] = 0
  plot_configuration[:xlim2] = 200
  plot_configuration[:width] = 8
  plot_configuration[:height] = 6
  plot_configuration[:legend_location] = 'topleft'
  plot_configuration[:gridx_step] = 25
  if which_value == :auc
    plot_captions[:yaxis] = "AUC"
    plot_configuration[:ydata] = lambda{ |v| v["result.log"][:columns]["auc"] }
    plot_configuration[:gridy_step] = 0.005
    plot_configuration[:ylim1] = 0.92
    plot_configuration[:ylim2] = 1.0
#    plot_configuration[:yerror] = lambda{ |v| v["result.log"][:columns]["auc_stddev"] }
  elsif which_value == :prec
    plot_captions[:yaxis] = "Precision, Recall"
    plot_configuration[:ydata] = lambda{ |v| v["result.log"][:columns]["precision"] }
    plot_configuration[:ydata2] = lambda{ |v| v["result.log"][:columns]["recall"] }
    plot_configuration[:gridy_step] = 0.05
    plot_configuration[:ylim1] = 0.5
    plot_configuration[:ylim2] = 0.9
  end
  plot_configuration[:xdata] = lambda{ |v| v["result.log"][:columns]["iterations"] }

  generic_plot(groups, results_object, plot_captions, plot_configuration)
  return







  #######################################################



  con = Rserve::Connection.new
  con.eval <<EOF
    pdf(file = "~/office/uni/Diplomarbeit/plots/ada2boost_Zd_10_40.pdf",
    width = 8, height = 6, family = "Helvetica",
    title = "Ada2Boost (different example counts)", fonts = NULL, version = "1.1",
    paper = "special")
    plot(c(1),c(1),xlim=c(0,200),ylim=c(0.6,0.9),type='c',axes=TRUE,ann=FALSE)
    abline(v=(seq(0,200,25)), col="darkgray", lty="dotted")
    abline(h=(seq(.5,.9,.05)), col="darkgray", lty="dotted")
EOF

  i = 0
  captions = Array.new

  iter.each do |it|
#    PP.pp ro.filter(it)
#    puts ro.filter(it).size
    filter_keys = ro.filter(it)
    values = ro[filter_keys[0]]

    filter_keys.each do |filter_key|


      values = ro[filter_key]
      con.assign "x", Rserve::REXP::Wrapper.wrap(values["result.log"][:columns]["iterations"])
      con.assign "y", Rserve::REXP::Wrapper.wrap(values["result.log"][:columns]["auc"])
#      puts i
      con.eval "points(x,y,type='l',col='#{colors[i]}')"
      ex_count = filter_key["Read Examples.Sampling Properties.gamma_count"].to_i * 2
      inner_learner = File.basename filter_key["Train Model.Inner Learner.process_location"]
      fuzzy_reweighting = filter_key["Train Model.Bayesian Boosting.fuzzy_reweighting"]
      fuzzy_set_size = filter_key["Train Model.Bayesian Boosting.fuzzy_partition_sizes"]
      captions.push "#{inner_learner}, #{ex_count} ex.#{", frw" if fuzzy_reweighting}#{", fss" if fuzzy_set_size}"
      i += 1
    end
  end

  r_colors = Array.new
  r_captions = Array.new

  captions.size.times {|i| r_colors.push colors[i]}
  captions.each {|c| r_captions.push c.to_s}

  con.assign "captions", Rserve::REXP::Wrapper.wrap(r_captions)
  con.assign "colors", Rserve::REXP::Wrapper.wrap(r_colors)
#  PP.pp r_captions
#  PP.pp r_colors
  con.eval <<EOF
  legend('bottomright', captions, col=colors, lty=1, bg='white')
  title(main='Ada2Boost (different example counts)')
  title(xlab='iterations')
  title(ylab='auc')
  dev.off()
EOF
end


def plot_adaboost_different_training_sizes_gs conf, lresult_dir
  puts "plot_adaboost_different_training_sizes"
  adaboost_xval_creator = job_creator_bbcxval(conf, "")

  results_object = adaboost_xval_creator.variation.get_results_object("#{lresult_dir}/generated_processes")

#  puts "result object:"
#  PP.pp ro
  PP.pp results_object.keys[0]

  result_keys = results_object.filter({
      "Train Model.base_process" => [
        "rm_adaboost",
#        "bbc", # not necessary, same as fuzzy without frw and fss
      ],
      "Read Examples.base_process" => "sql_Zd_10_40_maxHeight_greater0",
#      "Read Examples.Sampling Properties.gamma_count" => [
#        "15000",
#        "45000",
#        "75000",
#        "105000",
#      ]
    },
    [
      "Train Model.Inner Learner.process_location",
      "Read Examples.Sampling Properties.gamma_count",
    ]
  )
#  return
#  puts "ITER:"
#  PP.pp iter
#  puts "END ITER"


  groups = ResultsObject.group_keys(result_keys,
    [
      "Read Examples.Sampling Properties.gamma_count",
    ])

  plot_captions = {}
  plot_captions[:filename] = lambda{|p|
    ex_count = p[:parameters]["Read Examples.Sampling Properties.gamma_count"].to_i * 2
    "~/office/uni/Diplomarbeit/plots/adaboost_Zd_10_40_#{ex_count}_examples"
  }

  title = lambda{|p|
    ex_count = p[:parameters]["Read Examples.Sampling Properties.gamma_count"].to_i * 2
    "AdaBoost with #{ex_count} examples"
  }

  plot_captions[:pdf_title] = title
  plot_captions[:title] = title
  plot_captions[:subtitle] = "" #lambda{|p| "r=#{p["Bayesian Boosting SQL.new_sample_interval"]}"}
  plot_captions[:xaxis] = "iterations"
  plot_captions[:yaxis] = "AUC"
  plot_captions[:caption] = lambda{|p|
      inner_learner = File.basename p["Train Model.Inner Learner.process_location"]
#      fuzzy_reweighting = p["Train Model.Bayesian Boosting.fuzzy_reweighting"]
#      fuzzy_set_size = p["Train Model.Bayesian Boosting.fuzzy_partition_sizes"]
      "#{inner_learner}"

  }

  plot_configuration = {}
  plot_configuration[:xlim1] = 0
  plot_configuration[:xlim2] = 200
  plot_configuration[:ylim1] = 0.92
  plot_configuration[:ylim2] = 1.0
  plot_configuration[:width] = 8
  plot_configuration[:height] = 6
  plot_configuration[:legend_location] = 'bottomright'
  plot_configuration[:gridx_step] = 25
  plot_configuration[:gridy_step] = 0.05
  plot_configuration[:xdata] = lambda{ |v| v["result.log"][:columns]["iterations"] }
  plot_configuration[:ydata] = lambda{ |v| v["result.log"][:columns]["auc"] }
#  plot_configuration[:yerror] = lambda{ |v| v["result.log"][:columns]["auc_stddev"] }

  generic_plot(groups, results_object, plot_captions, plot_configuration)
end





def plot_bbc_sql_sampling_size_7500_different_intervals conf, lresult_dir
  bbc_sql_xval_creator = job_creator_bbcxval_sql(conf, "")

  ro = bbc_sql_xval_creator.variation.get_results_object("#{lresult_dir}/generated_processes")
  iter = ro.filter({
      "Inner Learner.process_location" => [
          "//Diplomarbeit/struktur/prozesse/model_creation/j48",
      ],

      "Read Examples.process_location" => "//generated_processes/sql_Zd_10_40_maxHeight_greater0_for_bbc_sql/Sampling_Properties.gamma_count.7500",
      "Bayesian Boosting SQL.new_sample_interval" => [1,2,5,10,20]})

  colors = ["darkgreen", "magenta", "darkorange", "blue", "red"]
  colors += ["green", "blue", "yellow", "black"]

  con = Rserve::Connection.new
  con.eval <<EOF
    pdf(file = "~/tmp/bay_boost_sql_example_count_7500.pdf",
    width = 8, height = 6, family = "Helvetica",
    title = "R Graphics Output", fonts = NULL, version = "1.1",
    paper = "special")

    plot(c(1),c(1),xlim=c(0,150),ylim=c(0.6,0.9),type='c',axes=TRUE,ann=FALSE)

    abline(v=(seq(0,200,25)), col="darkgray", lty="dotted")
    abline(h=(seq(.5,.9,.05)), col="darkgray", lty="dotted")
EOF

  captions = Hash.new
  i = 0
  iter.each do |it|
    filter_keys = ro.filter(it)

    filter_keys.each do |filter_key|
      sampling_interval = filter_key["Bayesian Boosting SQL.new_sample_interval"]
      values = ro[filter_key]
      con.assign "x", Rserve::REXP::Wrapper.wrap(values["result.log"][:columns]["iterations"])
      con.assign "y", Rserve::REXP::Wrapper.wrap(values["result.log"][:columns]["auc"])
#      PP.pp filter_key
#      puts i, colors[i], sampling_interval
      con.eval "points(x,y,type='l',col='#{colors[i]}')"
      captions[sampling_interval] = colors[i]
      i += 1
    end
  end

  captions_keys = captions.keys.sort
  r_colors = Array.new
  captions_keys.each {|c| r_colors.push captions[c]}
  r_captions = Array.new
  captions_keys.each {|c| r_captions.push "r = #{c.to_s}"}

  con.assign "captions", Rserve::REXP::Wrapper.wrap(r_captions)
  con.assign "colors", Rserve::REXP::Wrapper.wrap(r_colors)
  con.eval <<EOF
  legend('bottomright', captions, col=colors, lty=1,bg='white')
  title(main='Ada2Boost++ (15.000 examples, different sampling intervals)')
  title(xlab='iterations')
  title(ylab='AUC')
  dev.off()
EOF
end

def plot_best_of_adaboost_bbc_bbc_sql conf, lresult_dir
  con = Rserve::Connection.new
  adaboost_xval_creator = job_creator_bbcxval(conf, "")

  ro = adaboost_xval_creator.variation.get_results_object("#{lresult_dir}/generated_processes")

  iter = ro.filter(
    {
      "Train Model.process_location" => [
          "//generated_processes/bbc/Bayesian_Boosting.iterations.200/Inner_Learner.process_location.struktur/prozesse/model_creation/j48",
#          "//generated_processes/rm_adaboost/AdaBoost.iterations.200/Inner_Learner.process_location.struktur/prozesse/model_creation/j48",
        ],
      "Read Examples.process_location" => [
        "//generated_processes/sql_Zd_10_40_maxHeight_greater0/Sampling_Properties.gamma_count.105000",
      ]
    }
  )

  colors = ["darkgreen", "magenta", "darkorange", "blue", "red"]
  colors += ["green", "blue", "yellow", "black"]

  con.eval <<EOF
    pdf(file = "~/office/uni/Diplomarbeit/plots/best_of_ada_bbc_bbc_sql_weka-ds_Zd_10_40.pdf",
      width = 8, height = 6, family = "Helvetica",
      title = "Best-of AdaBoost, Ada2Boost, Ada2Boost SQL", fonts = NULL, version = "1.1",
      paper = "special")
    plot(c(1),c(1),xlim=c(0,150),ylim=c(0.6,0.9),type='c',axes=TRUE,ann=FALSE)
    abline(v=(seq(0,200,25)), col="darkgray", lty="dotted")
    abline(h=(seq(.5,.9,.05)), col="darkgray", lty="dotted")
EOF

  i = 0
  captions = Array.new
  iter.each do |it|
    filter_keys = ro.filter(it)
    values = ro[filter_keys[0]]

    filter_keys.each do |filter_key|
      values = ro[filter_key]
      x = values["result.log"][:columns]["iterations"]
      y = values["result.log"][:columns]["auc"]
      con.assign "x", Rserve::REXP::Wrapper.wrap(x)
      con.assign "y", Rserve::REXP::Wrapper.wrap(y)
      con.eval "points(x,y,type='l',col='#{colors[i]}')"

      ex_count = values[:process_name]
      ex_count = /Sampling_Properties\.gamma_count\.\d+/.match(ex_count)[0]
      ex_count = /\d+\Z/.match(ex_count)[0]
      if filter_key["Train Model.process_location"].match /AdaBoost/
        captions.push "AdaBoost (210.000 examples)"
      else
        captions.push "Ada2Boost (210.000 examples)"
      end
      i += 1
    end
  end

  ##
  ## plot bbc_sql
  ####################
    bbc_sql_xval_creator = job_creator_bbcxval_sql(conf, "")
  g_count = 7500

  ro = bbc_sql_xval_creator.variation.get_results_object("#{lresult_dir}/generated_processes")
  iter = ro.filter({
      "Inner Learner.process_location" => [
          "//Diplomarbeit/struktur/prozesse/model_creation/j48",
        ],
      "Read Examples.process_location" => "//generated_processes/sql_Zd_10_40_maxHeight_greater0_for_bbc_sql/Sampling_Properties.gamma_count.#{g_count}",
      "Bayesian Boosting SQL.new_sample_interval" => [2,5,10]})

  iter.each do |it|
    filter_keys = ro.filter(it)
    values = ro[filter_keys[0]]



    filter_keys.each do |filter_key|
      values = ro[filter_key]
      iteration_counts = values["result.log"][:columns]["iterations"]
      sampling_interval = filter_key["Bayesian Boosting SQL.new_sample_interval"]

      x = iteration_counts
      y = values["result.log"][:columns]["auc"]
      con.assign "x", Rserve::REXP::Wrapper.wrap(x)
      con.assign "y", Rserve::REXP::Wrapper.wrap(y)
#      puts colors[i]
      con.eval "points(x,y,type='l',col='#{colors[i]}')"

      x = Array.new
      y = Array.new
      max_it = iteration_counts[iteration_counts.size-1].to_i
      cur_it = 1
      seen_ex = 0
      while cur_it < max_it
        seen_ex += g_count*2
        if seen_ex > 210000
          con.eval "abline(v=#{cur_it},lty='dashed',col='#{colors[i]}')"
          break
        end
        cur_it += sampling_interval
      end

      captions.push "Ada2Boost++ (#{g_count*2} examples, r=#{sampling_interval})"
      i += 1
    end
  end



#  ltys = Array.new colors.size, '1'
#  captions.push 'total sample size > 210.000'
#  colors.push 'black'
#  ltys.push 'dashed'
PP.pp captions
PP.pp colors
  con.assign "captions", Rserve::REXP::Wrapper.wrap(captions)
  con.assign "colors", Rserve::REXP::Wrapper.wrap(colors)
#  con.assign "ltys", Rserve::REXP::Wrapper.wrap(ltys)
  con.eval <<EOF
  legend('bottomright', captions, col=colors, lty=1,bg='white')
  title(main='Ada2Boost vs. Ada2Boost++')
  title(xlab='Iterationen')
  title(ylab='AUC')
  dev.off()
EOF
end
