# represents a PBS job and can create a jobfile.
# Member variables:
#   mail_address: mail address in th jobfile
#   mail_trigger: when to send mails ((a)bortion, (b)egin, (e)nd, (n)ever; default is: (a)bortion)
#   walltime: walltime in the jobfile
#   memory: max memory for the java process in mb. In the jobfile additional 50mb are added for
#     security
#   cores: how many cores to use
#   rm_executable: the command to start RapidMiner
#   log_directory: where the logs of the rapidminer process are stored (stdout, stderr)
#   process_file: the location of the process file (on the server) run by this job (including full path)
class PBSJob
  def initialize
    @mail_trigger = "abe"
    @cores = 1
  end

  attr_accessor :mail_address, :mail_trigger, :walltime, :memory, :cores, :rm_executable, :log_directory, :process_file

  # assembles the data fields into a string which resembles a PBS file
  def assemble_script with_comments = true
#    process_basename = File.basename @process_file, '.rmp'
    process_basename = @process_file.gsub /\A\/\/\w*\//, "" # remove repository name in the form of //repo_name/
    time = Time.now
    script  = "#!/bin/sh\n"
    # leave job name empty. In this case the name of the job file will be used as job name
    script += "### this job is\n" if with_comments
    script += "#PBS -N 'rapidminer_#{time.strftime("%Y-%m-%d__%H:%M:%S")}__#{"%10.9f" % time.to_f}'\n"
    script += "### send mail to\n" if with_comments
    script += "#PBS -M #{@mail_address}\n"
    script += "### send mail on (a)bortion, (b)egin, (e)nd, (n)ever; default is: (a)bortion\n"
    script += "#PBS -m #{@mail_trigger}\n"
    script += "### logfiles:\n" if with_comments
    script += "#PBS -o '#{@log_directory}/#{process_basename}.stdout.log'\n"
    script += "#PBS -e '#{@log_directory}/#{process_basename}.error.log'\n"
    script += "### ressource configuration:\n" if with_comments
    script += "#PBS -l walltime=#{@walltime}\n"
    script += "#PBS -l nodes=1:ppn=#{@cores}\n"
    script += "#PBS -l pmem=#{@memory.to_i+50}mb\n"
    script += "\n"
    script += "mkdir -p '#{@log_directory}/#{File.dirname(process_basename)}'\n"
    script += "echo 'RUNNING' > '#{@log_directory}/#{process_basename}.error.log'\n"
    script += "export MAX_JAVA_MEMORY=#{@memory}\n"
    script += "\"#{@rm_executable}\" '#{@process_file}'\n"
    return script
  end

  # writes the script returned by assemble_script into filename
  def write_jobfile filename
    path = File.dirname filename
    system "mkdir -p #{path}" unless path == ""
    File.open(filename, 'w') do |file|
      file.puts assemble_script true
    end
  end

end
