def plot_vlds_R_3_j48_2000 conf, lresult_dir
  colors = ["darkgreen", "magenta", "darkorange", "blue"]
#  colors += ["red", "green", "gold", "black"]
  con = Rserve::Connection.new
  con.eval <<EOF
    pdf(file = "~/office/uni/Diplomarbeit/plots/vlds_R_3_j48_2000.pdf",
      width = 8, height = 6, family = "Helvetica",
      title = "Ada2Boost mit J48, R = 3, m = 2000", fonts = NULL, version = "1.1",
      paper = "special")
    plot(1,xlim=c(0,150),ylim=c(0.94,.98),type='n',axes=TRUE,ann=FALSE)
    abline(v=(seq(0,200,25)), col="darkgray", lty="dotted")
    abline(h=(seq(.92,1.0,.005)), col="darkgray", lty="dotted")
EOF

  i = 0
  captions = Array.new

  bbc_sql_xval_creator = job_creator_bbcxval_sql_fuzzy(conf, "bbc_fuzzy_sql_new_")

  ro = bbc_sql_xval_creator.variation.get_results_object("#{lresult_dir}/generated_processes")

  iter = ro.filter(
    {
#      "Inner Learner.process_location" => [
#          "//Diplomarbeit/struktur/prozesse/model_creation/j48",
#          "//Diplomarbeit/struktur/prozesse/model_creation/weka-ds",
#        ],
      "Bayesian Boosting SQL.new_sample_interval" => 3,
      "Read Examples.Sampling Properties.gamma_count" => 1000,
      "Inner Learner.process_location" => "//Diplomarbeit/struktur/prozesse/model_creation/j48"

    },
    [
      "Read Examples.Sampling Properties.gamma_count",
      "Bayesian Boosting SQL.fuzzy_partition_sizes",
      "Bayesian Boosting SQL.fuzzy_reweighting",
    ]
  )


  iter.each do |it|
    filter_keys = ro.filter(it)
    values = ro[filter_keys[0]]

    filter_keys.each do |filter_key|
      values = ro[filter_key]
      x = values["result.log"][:columns]["iterations"]
      y = values["result.log"][:columns]["auc"]
      con.assign "x", Rserve::REXP::Wrapper.wrap(x)
      con.assign "y", Rserve::REXP::Wrapper.wrap(y)
      con.eval "points(x,y,type='l',pch='.',cex=1.5,col='#{colors[i]}',lwd=1.5)"

      ex_count = values[:process_name]
      ex_count = /Sampling_Properties\.gamma_count\.\d+/.match(ex_count)[0]
      ex_count = /\d+\Z/.match(ex_count)[0]
#      if filter_key["Train Model.process_location"].match /AdaBoost/
#        captions.push "AdaBoost (210.000 examples)"
#      else
#        captions.push "Ada2Boost (210.000 examples)"
#      end
      i += 1

      fss = filter_key["Bayesian Boosting SQL.fuzzy_partition_sizes"]
      frw = filter_key["Bayesian Boosting SQL.fuzzy_reweighting"]
      captions.push "VLDS#{", frw" if frw}#{", fss" if fss}"
    end
  end


  adaboost_xval_creator = job_creator_bbcxval(conf, "")

  ro = adaboost_xval_creator.variation.get_results_object("#{lresult_dir}/generated_processes")

#  puts "result object:"
#  PP.pp ro
#  PP.pp results_object.keys[0]

  iter = ro.filter({
      "Train Model.base_process" => [
        "bbc_fuzzy",
#        "bbc", # not necessary, same as fuzzy without frw and fss
      ],
      "Read Examples.base_process" => "sql_Zd_10_40_maxHeight_greater0",
      "Read Examples.Sampling Properties.gamma_count" => ["10000", "15000"],
      "Train Model.Inner Learner.process_location" => "//Diplomarbeit/struktur/prozesse/model_creation/j48",
      "Train Model.Bayesian Boosting.fuzzy_partition_sizes" => true,
      "Train Model.Bayesian Boosting.fuzzy_reweighting" => true,
    },
    [
      "Train Model.Inner Learner.process_location",
      "Read Examples.Sampling Properties.gamma_count",
      "Train Model.Bayesian Boosting.fuzzy_partition_sizes",
      "Train Model.Bayesian Boosting.fuzzy_reweighting",
    ]
  )

#  PP.pp iter
  i = 0
  iter.each do |it|
    filter_keys = ro.filter(it)
#    PP.pp filter_keys

    filter_keys.each do |filter_key|
      values = ro[filter_key]
      x = values["result.log"][:columns]["iterations"]
      y = values["result.log"][:columns]["auc"]
      con.assign "x", Rserve::REXP::Wrapper.wrap(x)
      con.assign "y", Rserve::REXP::Wrapper.wrap(y)
      lty = i == 0 ? "solid" : "dashed"
      con.eval "points(x,y,lty='#{lty}',type='l',pch='.',cex=1.5,col='black',lwd=1.5)"

      i += 1
    end
  end

  con.eval "abline(v=30,lty='solid',col='black',lwd=1.5)"
  con.eval "abline(v=45,lty='dashed',col='black',lwd=1.5)"


  captions += ["Fuzzy, m = 20.000"]
  captions += ["Fuzzy, m = 30.000"]
  colors += ["black", "black"]
  ltys = ['solid','solid','solid','solid','solid','dashed']

  con.assign "captions", Rserve::REXP::Wrapper.wrap(captions)
  con.assign "colors", Rserve::REXP::Wrapper.wrap(colors)
  con.assign "ltys", Rserve::REXP::Wrapper.wrap(ltys)
  con.eval <<EOF
  legend('bottomright', captions, col=colors, lty=ltys,lwd='1.5',bg='white')
  title(main='VLDS-Ada2Boost (J48, R = 3, m = 2.000) vs. Fuzzy Ada2Boost')
  title(xlab='Iterationen')
  title(ylab='AUC')
EOF

  con.eval "dev.off()"
  return
end

















def plot_vlds_ds conf, lresult_dir
  colors = ["magenta", "magenta", "darkorange", "blue"]
#  colors += ["red", "green", "gold", "black"]
  con = Rserve::Connection.new
  con.eval <<EOF
    pdf(file = "~/office/uni/Diplomarbeit/plots/vlds_ds.pdf",
      width = 8, height = 6, family = "Helvetica",
      title = "VLDS-Ada2Boost mit WEKA-DS", fonts = NULL, version = "1.1",
      paper = "special")
    plot(1,xlim=c(0,150),ylim=c(0.94,.98),type='n',axes=TRUE,ann=FALSE)
    abline(v=(seq(0,200,25)), col="darkgray", lty="dotted")
    abline(h=(seq(.92,1.0,.005)), col="darkgray", lty="dotted")
EOF

  i = 0
  captions = Array.new

  bbc_sql_xval_creator = job_creator_bbcxval_sql_fuzzy(conf, "bbc_fuzzy_sql_new_")

  ro = bbc_sql_xval_creator.variation.get_results_object("#{lresult_dir}/generated_processes")

  iter = ro.filter(
    {
#      "Inner Learner.process_location" => [
#          "//Diplomarbeit/struktur/prozesse/model_creation/j48",
#          "//Diplomarbeit/struktur/prozesse/model_creation/weka-ds",
#        ],
      "Bayesian Boosting SQL.new_sample_interval" => 3,
      "Read Examples.Sampling Properties.gamma_count" => 10000,
      "Inner Learner.process_location" => "//Diplomarbeit/struktur/prozesse/model_creation/weka-ds",
      "Bayesian Boosting SQL.fuzzy_partition_sizes" => false,
      "Bayesian Boosting SQL.fuzzy_reweighting" => false,
    },
    [
      "Read Examples.Sampling Properties.gamma_count",
      "Bayesian Boosting SQL.fuzzy_partition_sizes",
      "Bayesian Boosting SQL.fuzzy_reweighting",
    ]
  )


  iter.each do |it|
    filter_keys = ro.filter(it)
    values = ro[filter_keys[0]]

    filter_keys.each do |filter_key|
      values = ro[filter_key]
      x = values["result.log"][:columns]["iterations"]
      y = values["result.log"][:columns]["auc"]
      con.assign "x", Rserve::REXP::Wrapper.wrap(x)
      con.assign "y", Rserve::REXP::Wrapper.wrap(y)
      con.eval "points(x,y,type='l',pch='.',cex=1.5,col='#{colors[i]}',lwd=1.5)"

      ex_count = values[:process_name]
      ex_count = /Sampling_Properties\.gamma_count\.\d+/.match(ex_count)[0]
      ex_count = /\d+\Z/.match(ex_count)[0]
#      if filter_key["Train Model.process_location"].match /AdaBoost/
#        captions.push "AdaBoost (210.000 examples)"
#      else
#        captions.push "Ada2Boost (210.000 examples)"
#      end
      i += 1

      fss = filter_key["Bayesian Boosting SQL.fuzzy_partition_sizes"]
      frw = filter_key["Bayesian Boosting SQL.fuzzy_reweighting"]
      captions.push "VLDS"
    end
  end


  adaboost_xval_creator = job_creator_bbcxval(conf, "")

  ro = adaboost_xval_creator.variation.get_results_object("#{lresult_dir}/generated_processes")

#  puts "result object:"
#  PP.pp ro
#  PP.pp results_object.keys[0]

  iter = ro.filter({
      "Train Model.base_process" => [
        "bbc_fuzzy",
#        "bbc", # not necessary, same as fuzzy without frw and fss
      ],
      "Read Examples.base_process" => "sql_Zd_10_40_maxHeight_greater0",
      "Read Examples.Sampling Properties.gamma_count" => ["10000", "105000"],
      "Train Model.Inner Learner.process_location" => "//Diplomarbeit/struktur/prozesse/model_creation/weka-ds",
      "Train Model.Bayesian Boosting.fuzzy_partition_sizes" => false,
      "Train Model.Bayesian Boosting.fuzzy_reweighting" => false,
    },
    [
      "Train Model.Inner Learner.process_location",
      "Read Examples.Sampling Properties.gamma_count",
      "Train Model.Bayesian Boosting.fuzzy_partition_sizes",
      "Train Model.Bayesian Boosting.fuzzy_reweighting",
    ]
  )

#  PP.pp iter
  i = 0
  iter.each do |it|
    filter_keys = ro.filter(it)
#    PP.pp filter_keys

    filter_keys.each do |filter_key|
      values = ro[filter_key]
      x = values["result.log"][:columns]["iterations"]
      y = values["result.log"][:columns]["auc"]
      con.assign "x", Rserve::REXP::Wrapper.wrap(x)
      con.assign "y", Rserve::REXP::Wrapper.wrap(y)
      lty = i == 0 ? "solid" : "dashed"
      con.eval "points(x,y,lty='#{lty}',type='l',pch='.',cex=1.5,col='black',lwd=1.5)"

      i += 1
    end
  end

  con.eval "abline(v=1,lty='solid',col='black',lwd=1.5)"
  con.eval "abline(v=31,lty='dashed',col='black',lwd=1.5)"


  captions = [
    "VLDS-Ada2Boost, m = 20.000, R = 3",
    "Ada2Boost, m = 20.000",
    "Ada2Boost, m = 210.000",
    ]
  colors = [colors[0], "black", "black"]
  ltys = ['solid','solid','dashed']

  con.assign "captions", Rserve::REXP::Wrapper.wrap(captions)
  con.assign "colors", Rserve::REXP::Wrapper.wrap(colors)
  con.assign "ltys", Rserve::REXP::Wrapper.wrap(ltys)
  con.eval <<EOF
  legend('bottomright', captions, col=colors, lty=ltys,lwd='1.5',bg='white')
  title(main='VLDS-Ada2Boost (DS, R = 3, m = 20.000) vs. Ada2Boost')
  title(xlab='Iterationen')
  title(ylab='AUC')
EOF

  con.eval "dev.off()"
  return
end





















def plot_vlds_j48_saettigung conf, lresult_dir
  colors = ["darkgreen", "magenta", "darkorange", "blue"]
#  colors += ["red", "green", "gold", "black"]
  con = Rserve::Connection.new

  i = 0
  captions = Array.new

  bbc_sql_xval_creator = job_creator_bbcxval_sql_fuzzy(conf, "bbc_fuzzy_sql_new_")

  ro = bbc_sql_xval_creator.variation.get_results_object("#{lresult_dir}/generated_processes")

  iter = ro.filter(
    {
      "Bayesian Boosting SQL.new_sample_interval" => [1,3,5,20],
      "Read Examples.Sampling Properties.gamma_count" => 10000,
      "Inner Learner.process_location" => "//Diplomarbeit/struktur/prozesse/model_creation/j48"
    },
    [
      "Read Examples.Sampling Properties.gamma_count",
      "Bayesian Boosting SQL.fuzzy_partition_sizes",
      "Bayesian Boosting SQL.fuzzy_reweighting",
    ]
  )

  groups = ResultsObject.group_keys(iter,
    [
      "Read Examples.Sampling Properties.gamma_count",
      "Bayesian Boosting SQL.new_sample_interval",
      "Inner Learner.process_location",
    ])



  adaboost_xval_creator = job_creator_bbcxval(conf, "")

  ro1 = adaboost_xval_creator.variation.get_results_object("#{lresult_dir}/generated_processes")

#  puts "result object:"
#  PP.pp ro
#  PP.pp results_object.keys[0]

  iter1 = ro1.filter({
      "Train Model.base_process" => [
        "bbc_fuzzy",
#        "bbc", # not necessary, same as fuzzy without frw and fss
      ],
      "Read Examples.base_process" => "sql_Zd_10_40_maxHeight_greater0",
      "Read Examples.Sampling Properties.gamma_count" => ["105000"],
      "Train Model.Inner Learner.process_location" => "//Diplomarbeit/struktur/prozesse/model_creation/j48",
      "Train Model.Bayesian Boosting.fuzzy_partition_sizes" => false,
      "Train Model.Bayesian Boosting.fuzzy_reweighting" => false,
    },
    [
      "Train Model.Inner Learner.process_location",
      "Read Examples.Sampling Properties.gamma_count",
      "Train Model.Bayesian Boosting.fuzzy_partition_sizes",
      "Train Model.Bayesian Boosting.fuzzy_reweighting",
    ]
  )
  ro2 = ro1
  iter2 = ro2.filter({
      "Train Model.base_process" => [
        "bbc_fuzzy",
#        "bbc", # not necessary, same as fuzzy without frw and fss
      ],
      "Read Examples.base_process" => "sql_Zd_10_40_maxHeight_greater0",
      "Read Examples.Sampling Properties.gamma_count" => ["105000"],
      "Train Model.Inner Learner.process_location" => "//Diplomarbeit/struktur/prozesse/model_creation/j48",
      "Train Model.Bayesian Boosting.fuzzy_partition_sizes" => true,
      "Train Model.Bayesian Boosting.fuzzy_reweighting" => true,
    },
    [
      "Train Model.Inner Learner.process_location",
      "Read Examples.Sampling Properties.gamma_count",
      "Train Model.Bayesian Boosting.fuzzy_partition_sizes",
      "Train Model.Bayesian Boosting.fuzzy_reweighting",
    ]
  )


  group_idx = 1
  groups.each do |group|
    puts group_idx
#    PP.pp group[:keys]
    group_idx += 1
    filter_keys = group[:keys]


    filename = "~/office/uni/Diplomarbeit/plots/vlds_j48_saettigung_R_#{group[:parameters]["Bayesian Boosting SQL.new_sample_interval"]}_j48_20000"
    puts filename
    p = group
    title = "VLDS-Ada2Boost mit J48, m = #{p[:parameters]["Read Examples.Sampling Properties.gamma_count"]*2}, R=#{p[:parameters]["Bayesian Boosting SQL.new_sample_interval"]}"
    resampling_intervall = p[:parameters]["Bayesian Boosting SQL.new_sample_interval"]
    xaxis = "Iterationen"
    yaxis = "AUC"

    xlim1 = 0
    xlim2 = 200
    ylim1 = 0.94
    ylim2 = 0.98
    width = 4
    height = 4
    legend_location = 'bottomright'
    gridx_step = 25
    gridy_step = 0.005

    colors = ["darkgreen", "magenta", "darkorange", "blue", "red"]
    colors += ["green", "gold", "black"]
    colors += colors
    colors += colors


    con.eval "library(gplots)"

      con.eval <<EOF
        pdf(file = "#{filename}.pdf",
          width = #{width}, height = #{height}, family = "Helvetica",
          fonts = NULL, version = "1.1",
          paper = "special", pointsize=8)
EOF
    con.eval <<EOF
    plotCI(1,xlim=c(#{xlim1},#{xlim2}),ylim=c(#{ylim1},#{ylim2}),type='n',ann=FALSE)
    abline(v=(seq(#{xlim1},#{xlim2},#{gridx_step})), col="darkgray", lty="dotted")
    abline(h=(seq(#{ylim1},#{ylim2},#{gridy_step})), col="darkgray", lty="dotted")
EOF

    i = 0
    key_idx = -1
    captions = Array.new
    filter_keys.each do |filter_key|
      key_idx += 1
      values = ro[filter_key]

      xdata = values["result.log"][:columns]["iterations"]
      ydata = values["result.log"][:columns]["auc"]

      ydata_new = []
      ydata.each {|y| ydata_new.push y.to_f}
      ydata = ydata_new
      xdata_new = []
      xdata.each {|x| xdata_new.push x.to_f}
      xdata = xdata_new

      con.assign "x", Rserve::REXP::Wrapper.wrap(xdata)
      con.assign "y", Rserve::REXP::Wrapper.wrap(ydata)


      con.eval "points(x,y,type='l',pch='.',cex=1.5,col='#{colors[i]}')"

      fuzzy_reweighting = filter_key["Bayesian Boosting SQL.fuzzy_reweighting"]
      fuzzy_set_size = filter_key["Bayesian Boosting SQL.fuzzy_partition_sizes"]
      captions.push "VLDS#{", frw" if fuzzy_reweighting}#{", fss" if fuzzy_set_size}"
      i += 1
    end
    r_captions = Array.new
    r_colors = Array.new
    captions.size.times{|i| r_colors.push colors[i]}
    captions.push "A2B"
    captions.push "A2B, frw, fss"
    captions.each {|c| r_captions.push c.to_s}
    r_colors += ["black", "black"]
    con.assign "captions", Rserve::REXP::Wrapper.wrap(r_captions)
    con.assign "colors", Rserve::REXP::Wrapper.wrap(r_colors)
    con.eval("title(main='#{title}')") if title
    con.assign "ltys", Rserve::REXP::Wrapper.wrap(["solid","solid","solid","solid","solid","dashed"])

    con.eval "abline(v=#{210.0/20.0 * resampling_intervall + resampling_intervall-1},lty='dashed',col='black',lwd=1)"


    con.eval <<EOF
    legend('#{legend_location}', captions, col=colors, lty=ltys, bg='white')
    title(xlab='#{xaxis}')
    title(ylab='#{yaxis}')
EOF








#  PP.pp iter
  i = 0
  iter1.each do |it|
    filter_keys1 = ro1.filter(it)
#    PP.pp filter_keys

    filter_keys1.each do |filter_key|
      values = ro1[filter_key]
      x = values["result.log"][:columns]["iterations"]
      y = values["result.log"][:columns]["auc"]
      con.assign "x", Rserve::REXP::Wrapper.wrap(x)
      con.assign "y", Rserve::REXP::Wrapper.wrap(y)
      lty = i == 0 ? "solid" : "dashed"
      con.eval "points(x,y,lty='#{lty}',type='l',pch='.',cex=1.5,col='black',lwd=1.5)"

      i += 1
    end
  end
  i = 0
  iter2.each do |it|
    filter_keys2 = ro2.filter(it)
#    PP.pp filter_keys

    filter_keys2.each do |filter_key|
      values = ro1[filter_key]
      x = values["result.log"][:columns]["iterations"]
      y = values["result.log"][:columns]["auc"]
      con.assign "x", Rserve::REXP::Wrapper.wrap(x)
      con.assign "y", Rserve::REXP::Wrapper.wrap(y)
      lty = "dashed"
      con.eval "points(x,y,lty='#{lty}',type='l',pch='.',cex=1.5,col='black',lwd=1.5)"

      i += 1
    end
  end

    con.eval "dev.off()"
  end
end



















def plot_vlds_svm conf, lresult_dir
  colors = ["darkgreen", "magenta", "darkorange", "blue"]
#  colors += ["red", "green", "gold", "black"]
  con = Rserve::Connection.new

  i = 0
  captions = Array.new

  bbc_sql_xval_creator = job_creator_bbcxval_sql_fuzzy_svm(conf, "svm_sql_new_")

  ro = bbc_sql_xval_creator.variation.get_results_object("#{lresult_dir}/generated_processes")

  iter = ro.filter(
    {
      "Bayesian Boosting SQL.new_sample_interval" => [1,3,5,10],
      "Read Examples.Sampling Properties.gamma_count" => 200,
      "Inner Learner.process_location" => "//Diplomarbeit/struktur/prozesse/model_creation/libsvm"
    },
    [
      "Read Examples.Sampling Properties.gamma_count",
      "Bayesian Boosting SQL.fuzzy_partition_sizes",
      "Bayesian Boosting SQL.fuzzy_reweighting",
    ]
  )

#  PP.pp iter

  groups = ResultsObject.group_keys(iter,
    [
      "Read Examples.Sampling Properties.gamma_count",
      "Bayesian Boosting SQL.new_sample_interval",
      "Inner Learner.process_location",
    ])



  group_idx = 1
  groups.each do |group|
    puts group_idx
#    PP.pp group[:keys]
    group_idx += 1
    filter_keys = group[:keys]


    filename = "~/office/uni/Diplomarbeit/plots/vlds_svm_R_#{group[:parameters]["Bayesian Boosting SQL.new_sample_interval"]}_j48"
    puts filename
    p = group
    title = "VLDS-Ada2Boost mit SVM, m = #{p[:parameters]["Read Examples.Sampling Properties.gamma_count"]*2}, R=#{p[:parameters]["Bayesian Boosting SQL.new_sample_interval"]}"
    xaxis = "Iterationen"
    yaxis = "AUC"

    xlim1 = 0
    xlim2 = 100
    ylim1 = 0.5
    ylim2 = 0.81
    width = 4
    height = 4
    legend_location = 'bottomright'
    gridx_step = 25
    gridy_step = 0.05

    colors = ["darkgreen", "magenta", "darkorange", "blue", "red"]
    colors += ["green", "gold", "black"]
    colors += colors
    colors += colors


    con.eval "library(gplots)"

      con.eval <<EOF
        pdf(file = "#{filename}.pdf",
          width = #{width}, height = #{height}, family = "Helvetica",
          fonts = NULL, version = "1.1",
          paper = "special", pointsize=8)
EOF
    con.eval <<EOF
    plotCI(1,xlim=c(#{xlim1},#{xlim2}),ylim=c(#{ylim1},#{ylim2}),type='n',ann=FALSE)
    abline(v=(seq(#{xlim1},#{xlim2},#{gridx_step})), col="darkgray", lty="dotted")
    abline(h=(seq(#{ylim1},#{ylim2},#{gridy_step})), col="darkgray", lty="dotted")
EOF

    i = 0
    key_idx = -1
    captions = Array.new
    filter_keys.each do |filter_key|
      key_idx += 1
      values = ro[filter_key]

      xdata = values["result.log"][:columns]["iterations"]
      ydata = values["result.log"][:columns]["auc"]

      ydata_new = []
      ydata.each {|y| ydata_new.push y.to_f}
      ydata = ydata_new
      xdata_new = []
      xdata.each {|x| xdata_new.push x.to_f}
      xdata = xdata_new

      con.assign "x", Rserve::REXP::Wrapper.wrap(xdata)
      con.assign "y", Rserve::REXP::Wrapper.wrap(ydata)


      con.eval "points(x,y,type='l',pch='.',cex=1.5,col='#{colors[i]}')"

      fuzzy_reweighting = filter_key["Bayesian Boosting SQL.fuzzy_reweighting"]
      fuzzy_set_size = filter_key["Bayesian Boosting SQL.fuzzy_partition_sizes"]
      captions.push "VLDS#{", frw" if fuzzy_reweighting}#{", fss" if fuzzy_set_size}"
      i += 1
    end
    r_captions = Array.new
    r_colors = Array.new
    captions.size.times{|i| r_colors.push colors[i]}
#    captions.push "A2B"
#    captions.push "A2B, frw, fss"
    captions.each {|c| r_captions.push c.to_s}
#    r_colors += ["black", "black"]
    con.assign "captions", Rserve::REXP::Wrapper.wrap(r_captions)
    con.assign "colors", Rserve::REXP::Wrapper.wrap(r_colors)
    con.eval("title(main='#{title}')") if title
    con.assign "ltys", Rserve::REXP::Wrapper.wrap(["solid","solid","solid","solid"])

    con.eval <<EOF
    legend('#{legend_location}', captions, col=colors, lty=ltys, bg='white')
    title(xlab='#{xaxis}')
    title(ylab='#{yaxis}')
EOF

  con.eval "dev.off()"
  end
end






