require "rexml/document.rb"
include REXML

require 'rserve'
require "pp"

require 'plot.rb'
require 'manual_plot.rb'
require 'jobs.rb'
require 'run_config'

require "variation.rb"
require "rmprocess.rb"
require "jobfilecreator.rb"
require "parametervalues.rb"
require "pbsjob.rb"

def prefix_array array, prefix
  result = Array.new
  array.each{|s| result.push(prefix+s)}
  return result
end

def array_add_stripped_filenames array, path
  result = Array.new
  array.each do |f|
    if f.is_a? Array
      result.push f
    else
      result.push [f, f.gsub(path, "")] unless f.is_a? Array
    end
  end
  return result
end

def print_states e
  puts "success: #{e.values.count(:success)}"
  puts "running: #{e.values.count(:running)}"
  puts "submitted: #{e.values.count(:submitted)}"
  puts "killed: #{e.values.count(:killed)}"
  puts "error: #{e.values.count(:error)}"
  puts "not_run: #{e.values.count(:not_run)}"
end

def sync_logs_from_server conf, llog_directory
  server_info = conf[:server_info]
  rlog_directory = conf[:remote_log_directory]


  command  = "rsync -az"
  command += " --rsh='ssh -p #{server_info[:port]}'" if server_info[:port]
  command += " #{server_info[:user]}@#{server_info[:server]}"
  command += ":#{rlog_directory}/"
  command += " #{llog_directory}/"

  success   = system("mkdir -p #{llog_directory}")
  success &&= system(command)
  if !success
    throw "could not retrieve logs from the server. Command was:\n#{command}"
  end
end

def sync_logs_to_server conf, llog_directory
  server_info = conf[:server_info]
  rlog_directory = conf[:remote_log_directory]


  command  = "rsync -auz"
  command += " --rsh='ssh -p #{server_info[:port]}'" if server_info[:port]
  command += " #{llog_directory}/"
  command += " #{server_info[:user]}@#{server_info[:server]}"
  command += ":#{rlog_directory}/"

  success   = system("mkdir -p #{llog_directory}")
  success &&= system(command)
  if !success
    throw "could not retrieve logs from the server. Command was:\n#{command}"
  end
end


def get_configuration
  conf = Hash.new
  conf[:local_base_repository] = "/home/mhelf/office/uni/Diplomarbeit/git/rapidminer-repo"

  # where the process files are created locally and copied to on the server:
  conf[:repository] = Hash.new
  conf[:repository][:name] = "generated_processes"
  conf[:repository][:local_directory] = "/home/mhelf/office/uni/Diplomarbeit/generated_processes"
  conf[:repository][:remote_directory] = "/home/mhelf/nobackup/generated_processes"

  # where the job files are created locally:
  conf[:jobfile_creation_path] = "/home/mhelf/office/uni/Diplomarbeit/phido_jobs"

  # where the logs are created during job execution (on the server):
  conf[:remote_log_directory] = "/home/mhelf/nobackup/rm_logs"

  # the variations file_separator:
  conf[:file_separator] = "/"

  # command to run RapidMiner:
  conf[:rapidminer_executable] = "${RAPIDMINER_HOME}/scripts/rapidminer"

  # mail address in the job files:
  conf[:mail_address] = "marius.helf@tu-dortmund.de"

  # where the process files will be copied to on the remote server:
  conf[:remote_process_path] = "/home/mhelf/nobackup/rapidminer_processes"

  # where the job files will be copied to on the remote server:
  conf[:remote_jobfile_path] = "/home/mhelf/nobackup/jobfiles"

  conf[:submitted_jobs_logfile] = "/home/mhelf/office/uni/Diplomarbeit/submitted_phido_jobs.log"

  # connection info:
  server_info = Hash.new
  server_info[:server] = "localhost"
  server_info[:port] = 50001
  server_info[:user] = "mhelf"
  conf[:server_info] = server_info

  return conf
end

def print_configuration conf
  puts "process_creation_path: #{conf[:process_creation_path]}"
  puts "jobfile_creation_path: #{conf[:jobfile_creation_path]}"
  puts "remote_log_directory: #{conf[:remote_log_directory]}"
  puts "remote_process_path: #{conf[:remote_process_path]}"
  puts "file_separator: #{conf[:file_separator]}"
  puts "rapidminer_excecutable: #{conf[:rapidminer_executable]}"
  puts "mail_address: #{conf[:mail_address]}"
end




def main
  rc = RunConfig.new



  puts "1 Liter Cola auf ex ist suboptimal für ruhiges und konzentriertes Arbeiten."
  puts

  conf = get_configuration
  lresult_dir = "/home/mhelf/office/uni/Diplomarbeit/phido_process_results" # local result directory
  rresult_dir = "/home/mhelf/results" # remote result directory

  llog_directory = "/home/mhelf/office/uni/Diplomarbeit/phido_rm_logs"
  if rc.retrieve_logs
    puts "Retrieving logs..."
    sync_logs_from_server(conf, llog_directory)
    puts "Done."
  end

  if rc.retrieve_results
    puts "Retrieving results..."
    JobFileCreator.retrieve_results(conf[:server_info], rresult_dir, lresult_dir)
    puts "Done."
  end



#  job_creator = job_creator_sql_Zd_10_40_maxHeight_greater0(conf)

#  std_xval_creator = job_creator_stdxval_with_bbc(conf)
#  puts std_xval_creator.filenames


  if rc.work_on_processes
    puts "*** stdxval with linear binning, no optimizations"
    linear_binning_creator = job_creator_stdxval_with_binning(conf, "linear_binning_")
    e = linear_binning_creator.find_errors llog_directory
    print_states e
    linear_binning_creator.compact_logs llog_directory, e if rc.compact_logs
#    e.each_pair {|k,v| PP.pp(k) if v == :not_run}
    linear_binning_creator.variation.create_process_files false if rc.create_processes
    linear_binning_creator.create_job_files false, e, [:error, :killed, :not_run]

    puts "*** bbc_xval_creator"
    bbc_xval_creator = job_creator_bbcxval(conf, "")
    e = bbc_xval_creator.find_errors llog_directory
    print_states e
    bbc_xval_creator.compact_logs llog_directory, e if rc.compact_logs
    bbc_xval_creator.variation.create_process_files false if rc.create_processes
    bbc_xval_creator.create_job_files false, e, [:error, :killed, :not_run, :success]




    puts "*** xval with weka-rf"
    rf_xval_creator = job_creator_stdxval_with_weka_rf conf, "weka_rf_"
    e = rf_xval_creator.find_errors llog_directory
    print_states e
    rf_xval_creator.compact_logs llog_directory, e if rc.compact_logs
    rf_xval_creator.variation.create_process_files false if rc.create_processes
    rf_xval_creator.create_job_files false, e, [:error, :killed, :not_run, :success]



    puts "*** bbc_sql_fuzzy_xval_creator"
    bbc_sql_xval_creator = job_creator_bbcxval_sql_fuzzy conf, "bbc_fuzzy_sql_new_"
    e = bbc_sql_xval_creator.find_errors llog_directory
    print_states e
    bbc_sql_xval_creator.compact_logs llog_directory, e if rc.compact_logs
    bbc_sql_xval_creator.variation.create_process_files false if rc.create_processes
    bbc_sql_xval_creator.create_job_files false, e, [:error, :killed, :not_run]





    puts "*** evolutionary binning selection"
    evo_binning_selection = job_creator_evo_binning_selection conf, "bs_"
    e = evo_binning_selection.find_errors llog_directory
    print_states e
    evo_binning_selection.compact_logs llog_directory, e if rc.compact_logs
    evo_binning_selection.variation.create_process_files false if rc.create_processes
    evo_binning_selection.create_job_files false, e, [:error, :killed, :not_run]

    puts "*** forward binning selection"
    fw_binning_selection = job_creator_forward_binning_selection conf, "bs_"
    e = fw_binning_selection.find_errors llog_directory
    print_states e
    fw_binning_selection.compact_logs llog_directory, e if rc.compact_logs
    fw_binning_selection.variation.create_process_files false if rc.create_processes
    fw_binning_selection.create_job_files false, e, [:error, :killed, :not_run]

    puts "*** backward binning selection"
    bw_binning_selection = job_creator_backward_binning_selection conf, "bs_"
    e = bw_binning_selection.find_errors llog_directory
    print_states e
    bw_binning_selection.compact_logs llog_directory, e if rc.compact_logs
#    puts "ERROR:"
#    e.each_pair {|k,v| PP.pp(k) if v == :error}
#    puts "RUNNING:"
#    e.each_pair {|k,v| PP.pp(k) if v == :running}
    bw_binning_selection.variation.create_process_files false if rc.create_processes
    bw_binning_selection.create_job_files false, e, [:error, :killed, :not_run]

    puts "*** binning evaluation"
    binning_selectors = [
      evo_binning_selection,
      fw_binning_selection,
      bw_binning_selection
    ]
    binning_eval = job_creator_binning_eval conf, llog_directory, binning_selectors, "be_new_", rresult_dir
    e = binning_eval.find_errors llog_directory
    print_states e
    binning_eval.variation.create_process_files false if rc.create_processes
    binning_eval.create_job_files false, e, [:not_run]




    puts "*** job_creator_bbcxval_sql_fuzzy_svm"
    svm = job_creator_bbcxval_sql_fuzzy_svm conf, "svm_sql_new_"
    e = svm.find_errors llog_directory
    print_states e
    svm.compact_logs llog_directory, e if rc.compact_logs
#    puts "ERROR:"
#    e.each_pair {|k,v| PP.pp(k) if v == :error}
#    puts "RUNNING:"
#    e.each_pair {|k,v| PP.pp(k) if v == :running}
    svm.variation.create_process_files false if rc.create_processes
    svm.create_job_files false, e, [:error, :killed, :not_run]



    if rc.sync_processes_and_jobs_to_server
      puts "Syncing jobs and processes..."
      bbc_sql_xval_creator.sync_jobfiles_to_server(conf[:server_info], conf[:remote_jobfile_path])
      bbc_sql_xval_creator.variation.sync_processes_to_server conf[:server_info]
      puts "Done."
    end

    if rc.sync_logs_to_server
      puts "Syncing logs to server..."
      sync_logs_to_server(conf, llog_directory)
      puts "Done."
    end

  end

  if rc.create_plots
    puts "Plotting..."
    plot_vlds_j48_saettigung(conf, lresult_dir)
    return
    plot_weka_rf_different_training_sizes(conf, lresult_dir)
    plot_vlds_svm(conf, lresult_dir)
    plot_vlds_j48_saettigung(conf, lresult_dir)
    plot_vlds_ds(conf, lresult_dir)
    plot_vlds_R_3_j48_2000(conf, lresult_dir)
    return
#    plot_best_of_adaboost_bbc_bbc_sql(conf, lresult_dir)
    plot_ada2boost_different_training_sizes_gs conf, lresult_dir, :auc
    plot_ada2boost_different_training_sizes_gs conf, lresult_dir, :prec
    plot_bbc_sql_one_sampling_interval_different_training_sizes conf, lresult_dir, :auc
    plot_bbc_sql_one_sampling_interval_different_training_sizes conf, lresult_dir, :prec
    plot_bbc_sql_fuzzy_svm_one_sampling_interval_different_training_sizes conf, lresult_dir
    plot_binning_eval conf, llog_directory, rresult_dir, lresult_dir
    plot_linear_binning_no_optimization(conf, lresult_dir)
#    plot_bbc_sql_sampling_size_7500_different_intervals conf, lresult_dir
#    plot_adaboost_different_training_sizes conf, lresult_dir
#    plot_adaboost_different_training_sizes_gs conf, lresult_dir
#    plot_binning_selection_bw(conf, lresult_dir)
    plot_binning_selection_fw(conf, lresult_dir)
#    plot_binning_selection_evo(conf, lresult_dir)
    puts "Done."
  end

  puts "All done."
end

main()
