def job_creator_sql_Zd_10_40_maxHeight_greater0 conf, namespace, example_counts = nil
#  puts "job_creator_sql_Zd_10_40_maxHeight_greater0"
  base_process = "#{conf[:local_base_repository]}/struktur/prozesse/data_retrieval/sql_Zd_10_40_maxHeight_greater0.rmp"


  # create process:
  process = RMProcess.new base_process

  # create variation and variation values:
  variation = Variation.new process, conf[:repository], conf[:file_separator]
  variation.namespace = namespace

  vo = variation.variation_objects
  example_counts = [1000, 2000, 3000, 4000, 5000, 7500, 10000, 15000, 30000, 45000, 60000, 75000, 90000, 105000] unless example_counts
  v1 = ParameterValues.new "Sampling Properties", "gamma_count", example_counts, "list"
  v2 = ParameterValues.new "Sampling Properties", "hadron_count", example_counts, "list"
  vo.push SynchronizedParameterValues.new([v1,v2])


  # init job:
  pbs_job = PBSJob.new
  pbs_job.rm_executable = conf[:rapidminer_executable]
  pbs_job.log_directory = conf[:remote_log_directory]
  pbs_job.mail_address = conf[:mail_address]
  pbs_job.walltime = "00:15:00"
  pbs_job.memory = "1024"
  pbs_job.cores = 1

  # create job files:
  job_creator = JobFileCreator.new conf[:remote_process_path], conf[:jobfile_creation_path], variation, pbs_job

  return job_creator
end

def job_creator_sql_Zd_10_40_maxHeight_greater0_for_bbc_sql conf, namespace, example_counts = nil
#  puts "job_creator_sql_Zd_10_40_maxHeight_greater0_for_bbc_sql"
  base_process = "#{conf[:local_base_repository]}/struktur/prozesse/data_retrieval/sql_Zd_10_40_maxHeight_greater0_for_bbc_sql.rmp"


  # create process:
  process = RMProcess.new base_process

  # create variation and variation values:
  variation = Variation.new process, conf[:repository], conf[:file_separator]
  variation.namespace = namespace

  vo = variation.variation_objects
#  example_counts = [1000, 2000, 3000, 4000, 5000, 7500, 10000, 15000, 30000, 45000, 60000, 75000, 90000, 105000]
#  example_counts = [1000, 2000, 3000, 4000, 5000, 7500, 10000, 15000, 30000]
example_counts = [5000, 7500, 10000, 15000, 30000] unless example_counts
  example_counts2 = Array.new
  example_counts.each{|x| example_counts2.push 2*x}
  v1 = ParameterValues.new "Sampling Properties", "gamma_count", example_counts, "list"
  v2 = ParameterValues.new "Sampling Properties", "hadron_count", example_counts, "list"
  v3 = ParameterValues.new "Sampling Properties", "gamma_count2", example_counts2, "list"
  v4 = ParameterValues.new "Sampling Properties", "hadron_count2", example_counts2, "list"
  vo.push SynchronizedParameterValues.new([v1,v2,v3,v4])


  # init job:
  pbs_job = PBSJob.new
  pbs_job.rm_executable = conf[:rapidminer_executable]
  pbs_job.log_directory = conf[:remote_log_directory]
  pbs_job.mail_address = conf[:mail_address]
  pbs_job.walltime = "00:15:00"
  pbs_job.memory = "1024"
  pbs_job.cores = 1

  # create job files:
  job_creator = JobFileCreator.new conf[:remote_process_path], conf[:jobfile_creation_path], variation, pbs_job

  return job_creator
end

def job_creator_sql_no_Zd_limit_maxHeight_greater0 conf, namespace
#  puts "job_creator_sql_no_Zd_limit_maxHeight_greater0"
  base_process = "#{conf[:local_base_repository]}/struktur/prozesse/data_retrieval/sql_no_Zd_limit_maxHeight_greater0.rmp"


  # create process:
  process = RMProcess.new base_process

  # create variation and variation values:
  variation = Variation.new process, conf[:repository], conf[:file_separator]
  variation.namespace = namespace

  vo = variation.variation_objects
  example_counts = [1000, 2000, 3000, 4000, 5000, 7500, 10000, 15000, 30000, 45000, 60000, 75000, 90000, 105000]
  v1 = ParameterValues.new "Sampling Properties", "gamma_count", example_counts, "list"
  v2 = ParameterValues.new "Sampling Properties", "hadron_count", example_counts, "list"
  vo.push SynchronizedParameterValues.new([v1,v2])


  # init job:
  pbs_job = PBSJob.new
  pbs_job.rm_executable = conf[:rapidminer_executable]
  pbs_job.log_directory = conf[:remote_log_directory]
  pbs_job.mail_address = conf[:mail_address]
  pbs_job.walltime = "00:15:00"
  pbs_job.memory = "1024"
  pbs_job.cores = 1

  # create job files:
  job_creator = JobFileCreator.new conf[:remote_process_path], conf[:jobfile_creation_path], variation, pbs_job

  return job_creator
end

def job_creator_sql_no_Zd_limit_maxHeight_greater0_for_bbc_sql conf, namespace
#  puts "job_creator_sql_no_Zd_limit_maxHeight_greater0_for_bbc_sql"
  base_process = "#{conf[:local_base_repository]}/struktur/prozesse/data_retrieval/sql_no_Zd_limit_maxHeight_greater0_for_bbc_sql.rmp"


  # create process:
  process = RMProcess.new base_process

  # create variation and variation values:
  variation = Variation.new process, conf[:repository], conf[:file_separator]
  variation.namespace = namespace

  vo = variation.variation_objects
  example_counts = [1000, 2000, 3000, 4000, 5000, 7500, 10000, 15000, 30000, 45000, 60000, 75000, 90000, 105000]
  example_counts2 = Array.new
  example_counts.each{|x| example_counts2.push 2*x}
  v1 = ParameterValues.new "Sampling Properties", "gamma_count", example_counts, "list"
  v2 = ParameterValues.new "Sampling Properties", "hadron_count", example_counts, "list"
  v3 = ParameterValues.new "Sampling Properties", "gamma_count2", example_counts2, "list"
  v4 = ParameterValues.new "Sampling Properties", "hadron_count2", example_counts2, "list"
  vo.push SynchronizedParameterValues.new([v1,v2,v3,v4])


  # init job:
  pbs_job = PBSJob.new
  pbs_job.rm_executable = conf[:rapidminer_executable]
  pbs_job.log_directory = conf[:remote_log_directory]
  pbs_job.mail_address = conf[:mail_address]
  pbs_job.walltime = "00:15:00"
  pbs_job.memory = "1024"
  pbs_job.cores = 1

  # create job files:
  job_creator = JobFileCreator.new conf[:remote_process_path], conf[:jobfile_creation_path], variation, pbs_job

  return job_creator
end

def job_creator_sql_Zd_10_40_maxHeight_greater0_for_binning conf, namespace, example_counts = nil
#  puts "job_creator_sql_Zd_10_40_maxHeight_greater0_for_binning"
  base_process = "#{conf[:local_base_repository]}/struktur/prozesse/data_retrieval/sql_Zd_10_40_maxHeight_greater0.rmp"


  # create process:
  process = RMProcess.new base_process

  # create variation and variation values:
  variation = Variation.new process, conf[:repository], conf[:file_separator]
  variation.namespace = namespace

  vo = variation.variation_objects
  example_counts = [5000, 10000, 15000, 30000, 45000, 60000, 75000, 90000, 105000] unless example_counts
  v1 = ParameterValues.new "Sampling Properties", "gamma_count", example_counts, "list"
  v2 = ParameterValues.new "Sampling Properties", "hadron_count", example_counts, "list"
  vo.push SynchronizedParameterValues.new([v1,v2])


  # init job:
  pbs_job = PBSJob.new
  pbs_job.rm_executable = conf[:rapidminer_executable]
  pbs_job.log_directory = conf[:remote_log_directory]
  pbs_job.mail_address = conf[:mail_address]
  pbs_job.walltime = "00:15:00"
  pbs_job.memory = "1024"
  pbs_job.cores = 1

  # create job files:
  job_creator = JobFileCreator.new conf[:remote_process_path], conf[:jobfile_creation_path], variation, pbs_job

  return job_creator
end

def job_creator_sql_Zd_10_40_maxHeight_greater0_for_binning_fs conf, namespace
#  puts "job_creator_sql_Zd_10_40_maxHeight_greater0_for_binning_fs"
  base_process = "#{conf[:local_base_repository]}/struktur/prozesse/data_retrieval/sql_Zd_10_40_maxHeight_greater0.rmp"


  # create process:
  process = RMProcess.new base_process

  # create variation and variation values:
  variation = Variation.new process, conf[:repository], conf[:file_separator]
  variation.namespace = namespace

  vo = variation.variation_objects
  example_counts = [2000,5000,7500, 15000, 30000]
#  example_counts = [15000]
  v1 = ParameterValues.new "Sampling Properties", "gamma_count", example_counts, "list"
  v2 = ParameterValues.new "Sampling Properties", "hadron_count", example_counts, "list"
  vo.push SynchronizedParameterValues.new([v1,v2])


  # init job:
  pbs_job = PBSJob.new
  pbs_job.rm_executable = conf[:rapidminer_executable]
  pbs_job.log_directory = conf[:remote_log_directory]
  pbs_job.mail_address = conf[:mail_address]
  pbs_job.walltime = "00:15:00"
  pbs_job.memory = "1024"
  pbs_job.cores = 1

  # create job files:
  job_creator = JobFileCreator.new conf[:remote_process_path], conf[:jobfile_creation_path], variation, pbs_job

  return job_creator
end

def job_creator_sql_no_Zd_limit_maxHeight_greater0_for_binning conf, namespace
#  puts "job_creator_sql_no_Zd_limit_maxHeight_greater0_for_binning"
  base_process = "#{conf[:local_base_repository]}/struktur/prozesse/data_retrieval/sql_no_Zd_limit_maxHeight_greater0.rmp"


  # create process:
  process = RMProcess.new base_process

  # create variation and variation values:
  variation = Variation.new process, conf[:repository], conf[:file_separator]
  variation.namespace = namespace

  vo = variation.variation_objects
  example_counts = [15000, 30000, 45000, 60000, 75000, 90000, 105000]
  v1 = ParameterValues.new "Sampling Properties", "gamma_count", example_counts, "list"
  v2 = ParameterValues.new "Sampling Properties", "hadron_count", example_counts, "list"
  vo.push SynchronizedParameterValues.new([v1,v2])


  # init job:
  pbs_job = PBSJob.new
  pbs_job.rm_executable = conf[:rapidminer_executable]
  pbs_job.log_directory = conf[:remote_log_directory]
  pbs_job.mail_address = conf[:mail_address]
  pbs_job.walltime = "00:15:00"
  pbs_job.memory = "1024"
  pbs_job.cores = 1

  # create job files:
  job_creator = JobFileCreator.new conf[:remote_process_path], conf[:jobfile_creation_path], variation, pbs_job

  return job_creator
end



def job_creator_linear_binned_data conf, namespace
  base_process = "#{conf[:local_base_repository]}/struktur/prozesse/discretization/linear_discretization.rmp"

  # create process:
  process = RMProcess.new base_process

  # create variation and variation values:
  variation = Variation.new process, conf[:repository], conf[:file_separator]
  variation.namespace = namespace

  vo = variation.variation_objects

#  min_bin_values = [1.03109120412576, 10] # cos2Zd, Zd
#  max_bin_values = [1.70408819104185, 40] # cos2Zd, Zd
#  cluster_attributes = ["cos2Zd", "Zd"]
#  other_attributes1  = ["Zd", "cos2Zd"]
  min_bin_values = [1.03109120412576] # cos2Zd, Zd
  max_bin_values = [1.70408819104185] # cos2Zd, Zd
  cluster_attributes = ["cos2Zd"]
  other_attributes1  = ["Zd"]
  v1 = ParameterValues.new "Configure Binning", "min_bin_value", min_bin_values, "list"
  v2 = ParameterValues.new "Configure Binning", "max_bin_value", max_bin_values, "list"
  v3 = ParameterValues.new "Cluster Attribute", "value", cluster_attributes
  v4 = ParameterValues.new "Other Attribute1", "value", other_attributes1
  v = SynchronizedParameterValues.new [v1,v2,v3,v4]
  vo.push v

#  bin_counts = [1,3,5,6,7,8,9,10,11,12,13,14,15,20,25, 30, 45, 60, 75, 90]
  bin_counts = [1,3,5,10,15,20,25, 30, 45, 60, 75, 90]
  v = ParameterValues.new "Configure Binning", "bin_count", bin_counts, "list"
  vo.push v

  

  example_readers  = job_creator_sql_Zd_10_40_maxHeight_greater0_for_binning(conf, namespace).variation.filenames :repository_name, false
#  example_readers += job_creator_sql_no_Zd_limit_maxHeight_greater0_for_binning(conf, namespace).variation.filenames :repository_name, false
  v = ParameterValues.new "Read Examples", "process_location", array_add_stripped_filenames(example_readers, "//#{conf[:repository][:name]}/")
  v.base_variations = [
    job_creator_sql_Zd_10_40_maxHeight_greater0_for_binning(conf, namespace).variation,
#    job_creator_sql_no_Zd_limit_maxHeight_greater0_for_binning(conf, namespace).variation,
  ]
  vo.push v



  # init job:
  pbs_job = PBSJob.new
  pbs_job.rm_executable = conf[:rapidminer_executable]
  pbs_job.log_directory = conf[:remote_log_directory]
  pbs_job.mail_address = conf[:mail_address]
  pbs_job.walltime = "01:00:00"
  pbs_job.memory = "3024"
  pbs_job.cores = 1

  # create job files:
  job_creator = JobFileCreator.new conf[:remote_process_path], conf[:jobfile_creation_path], variation, pbs_job

  return job_creator
end




def job_creator_linear_binned_data_for_fs conf, namespace, bin_counts = nil
  base_process = "#{conf[:local_base_repository]}/struktur/prozesse/discretization/linear_discretization.rmp"

  # create process:
  process = RMProcess.new base_process

  # create variation and variation values:
  variation = Variation.new process, conf[:repository], conf[:file_separator]
  variation.namespace = namespace


  vo = variation.variation_objects

  min_bin_values = [1.03109120412576] # cos2Zd
  max_bin_values = [1.70408819104185] # cos2Zd
  cluster_attributes = ["cos2Zd"]
  other_attributes1  = ["Zd"]
  v1 = ParameterValues.new "Configure Binning", "min_bin_value", min_bin_values, "list"
  v2 = ParameterValues.new "Configure Binning", "max_bin_value", max_bin_values, "list"
  v3 = ParameterValues.new "Cluster Attribute", "value", cluster_attributes
  v4 = ParameterValues.new "Other Attribute1", "value", other_attributes1
  v = SynchronizedParameterValues.new [v1,v2,v3,v4]
  vo.push v

  bin_counts = [15, 30, 45, 60, 75, 90] unless bin_counts
  v = ParameterValues.new "Configure Binning", "bin_count", bin_counts, "list"
  vo.push v



  example_readers  = job_creator_sql_Zd_10_40_maxHeight_greater0_for_binning_fs(conf, namespace).variation.filenames :repository_name, false
#  example_readers += job_creator_sql_no_Zd_limit_maxHeight_greater0_for_binning(conf, namespace).variation.filenames :repository_name, false
  v = ParameterValues.new "Read Examples", "process_location", array_add_stripped_filenames(example_readers, "//#{conf[:repository][:name]}/")
  v.base_variations = [
    job_creator_sql_Zd_10_40_maxHeight_greater0_for_binning_fs(conf, namespace).variation,
#    job_creator_sql_no_Zd_limit_maxHeight_greater0_for_binning(conf, namespace).variation,
  ]
  vo.push v



  # init job:
  pbs_job = PBSJob.new
  pbs_job.rm_executable = conf[:rapidminer_executable]
  pbs_job.log_directory = conf[:remote_log_directory]
  pbs_job.mail_address = conf[:mail_address]
  pbs_job.walltime = "01:00:00"
  pbs_job.memory = "3024"
  pbs_job.cores = 1

  # create job files:
  job_creator = JobFileCreator.new conf[:remote_process_path], conf[:jobfile_creation_path], variation, pbs_job

  return job_creator
end






def job_creator_bbc_for_binning conf, namespace
#  puts "job_creator_bbc_for_binning"
  base_process = "#{conf[:local_base_repository]}/struktur/prozesse/model_creation/bbc.rmp"


  # create process:
  process = RMProcess.new base_process

  # create variation and variation values:
  variation = Variation.new process, conf[:repository], conf[:file_separator]
  variation.namespace = namespace

  vo = variation.variation_objects
#  iteration_counts = [15, 30, 45, 60, 75, 90]
  iteration_counts = [100]
  v = ParameterValues.new "Bayesian Boosting", "iterations", iteration_counts
  vo.push v

#  processes = job_creator_sql_Zd_10_40_maxHeight_greater0(conf, namespace).remote_process_filenames[0..2]
  repo = {:name => "Diplomarbeit"}
  inner_learners = [
    "//#{repo[:name]}/struktur/prozesse/model_creation/j48",
    "//#{repo[:name]}/struktur/prozesse/model_creation/weka-ds",
    #"//#{repo[:name]}/struktur/prozesse/model_creation/rm-ds" # mit dem RapidMiner Decision Stump kackt der Prozess voll ab und liefert keine sinnvollen Ergebnisse
  ]
  inner_learners = array_add_stripped_filenames inner_learners, "//#{repo[:name]}/"
  v = ParameterValues.new "Inner Learner", "process_location", inner_learners
  vo.push v


  # init job:
  pbs_job = PBSJob.new
  pbs_job.rm_executable = conf[:rapidminer_executable]
  pbs_job.log_directory = conf[:remote_log_directory]
  pbs_job.mail_address = conf[:mail_address]
  pbs_job.walltime = "01:00:00"
  pbs_job.memory = "3024"
  pbs_job.cores = 1

  # create job files:
  job_creator = JobFileCreator.new conf[:remote_process_path], conf[:jobfile_creation_path], variation, pbs_job

  return job_creator
end






def job_creator_bbc_for_binning_fs conf, namespace
#  puts "job_creator_bbc_for_binning"
  base_process = "#{conf[:local_base_repository]}/struktur/prozesse/model_creation/bbc.rmp"


  # create process:
  process = RMProcess.new base_process

  # create variation and variation values:
  variation = Variation.new process, conf[:repository], conf[:file_separator]
  variation.namespace = namespace
  vo = variation.variation_objects



  iteration_counts = [15,50] # 25 for j48; 100 for weka-ds
  v1 = ParameterValues.new "Bayesian Boosting", "iterations", iteration_counts
  repo = {:name => "Diplomarbeit"}
  inner_learners = [
    "//#{repo[:name]}/struktur/prozesse/model_creation/j48",
    "//#{repo[:name]}/struktur/prozesse/model_creation/weka-ds",
    #"//#{repo[:name]}/struktur/prozesse/model_creation/rm-ds" # mit dem RapidMiner Decision Stump kackt der Prozess voll ab und liefert keine sinnvollen Ergebnisse
  ]
  inner_learners = array_add_stripped_filenames inner_learners, "//#{repo[:name]}/"
  v2 = ParameterValues.new "Inner Learner", "process_location", inner_learners

  v = SynchronizedParameterValues.new [v2,v1]
  vo.push v


  # init job:
  pbs_job = PBSJob.new
  pbs_job.rm_executable = conf[:rapidminer_executable]
  pbs_job.log_directory = conf[:remote_log_directory]
  pbs_job.mail_address = conf[:mail_address]
  pbs_job.walltime = "01:00:00"
  pbs_job.memory = "3024"
  pbs_job.cores = 1

  # create job files:
  job_creator = JobFileCreator.new conf[:remote_process_path], conf[:jobfile_creation_path], variation, pbs_job

  return job_creator
end






# a model creation process for my fuzzy bbc classifier
def job_creator_bbc_fuzzy conf, namespace, iteration_counts = [200], inner_learners = nil, frw = [true,false], fss = [true,false]
#  puts "job_creator_bbc"
  base_process = "#{conf[:local_base_repository]}/struktur/prozesse/model_creation/bbc_fuzzy.rmp"


  # create process:
  process = RMProcess.new base_process

  # create variation and variation values:
  variation = Variation.new process, conf[:repository], conf[:file_separator]
  variation.namespace = namespace

  vo = variation.variation_objects
  v = ParameterValues.new "Bayesian Boosting", "iterations", iteration_counts
  vo.push v

  v = ParameterValues.new "Bayesian Boosting", "fuzzy_reweighting", frw
  vo.push v

  v = ParameterValues.new "Bayesian Boosting", "fuzzy_partition_sizes", fss
  vo.push v

  repo = {:name => "Diplomarbeit"}
  inner_learners = [
    "//#{repo[:name]}/struktur/prozesse/model_creation/j48",
    "//#{repo[:name]}/struktur/prozesse/model_creation/weka-ds",
    #"//#{repo[:name]}/struktur/prozesse/model_creation/rm-ds" # mit dem RapidMiner Decision Stump kackt der Prozess voll ab und liefert keine sinnvollen Ergebnisse
  ] unless inner_learners
  inner_learners = array_add_stripped_filenames inner_learners, "//#{repo[:name]}/"
  v = ParameterValues.new "Inner Learner", "process_location", inner_learners
  vo.push v


  # init job:
  pbs_job = PBSJob.new
  pbs_job.rm_executable = conf[:rapidminer_executable]
  pbs_job.log_directory = conf[:remote_log_directory]
  pbs_job.mail_address = conf[:mail_address]
  pbs_job.walltime = "05:50:00"
  pbs_job.memory = "4096"
  pbs_job.cores = 1

  # create job files:
  job_creator = JobFileCreator.new conf[:remote_process_path], conf[:jobfile_creation_path], variation, pbs_job

  return job_creator
end


# a model creation process for Scholz's bbc classifier
def job_creator_bbc conf, namespace
#  puts "job_creator_bbc"
  base_process = "#{conf[:local_base_repository]}/struktur/prozesse/model_creation/bbc.rmp"


  # create process:
  process = RMProcess.new base_process

  # create variation and variation values:
  variation = Variation.new process, conf[:repository], conf[:file_separator]
  variation.namespace = namespace

  vo = variation.variation_objects
  iteration_counts = [200]
  v = ParameterValues.new "Bayesian Boosting", "iterations", iteration_counts
  vo.push v

  repo = {:name => "Diplomarbeit"}
  inner_learners = [
    "//#{repo[:name]}/struktur/prozesse/model_creation/j48",
    "//#{repo[:name]}/struktur/prozesse/model_creation/weka-ds",
    #"//#{repo[:name]}/struktur/prozesse/model_creation/rm-ds" # mit dem RapidMiner Decision Stump kackt der Prozess voll ab und liefert keine sinnvollen Ergebnisse
  ]
  inner_learners = array_add_stripped_filenames inner_learners, "//#{repo[:name]}/"
  v = ParameterValues.new "Inner Learner", "process_location", inner_learners
  vo.push v


  # init job:
  pbs_job = PBSJob.new
  pbs_job.rm_executable = conf[:rapidminer_executable]
  pbs_job.log_directory = conf[:remote_log_directory]
  pbs_job.mail_address = conf[:mail_address]
  pbs_job.walltime = "05:50:00"
  pbs_job.memory = "4096"
  pbs_job.cores = 1

  # create job files:
  job_creator = JobFileCreator.new conf[:remote_process_path], conf[:jobfile_creation_path], variation, pbs_job

  return job_creator
end



def job_creator_rm_adaboost conf, namespace
#  puts "job_creator_rm_adaboost"
  base_process = "#{conf[:local_base_repository]}/struktur/prozesse/model_creation/rm_adaboost.rmp"


  # create process:
  process = RMProcess.new base_process

  # create variation and variation values:
  variation = Variation.new process, conf[:repository], conf[:file_separator]
  variation.namespace = namespace

  vo = variation.variation_objects
  iteration_counts = [200]
  v = ParameterValues.new "AdaBoost", "iterations", iteration_counts
  vo.push v

  repo = {:name => "Diplomarbeit"}
  inner_learners = [
    "//#{repo[:name]}/struktur/prozesse/model_creation/j48",
    "//#{repo[:name]}/struktur/prozesse/model_creation/weka-ds",
    #"//#{repo[:name]}/struktur/prozesse/model_creation/rm-ds" # mit dem RapidMiner Decision Stump kackt der Prozess voll ab und liefert keine sinnvollen Ergebnisse
  ]
  inner_learners = array_add_stripped_filenames inner_learners, "//#{repo[:name]}/"
  v = ParameterValues.new "Inner Learner", "process_location", inner_learners
  vo.push v


  # init job:
  pbs_job = PBSJob.new
  pbs_job.rm_executable = conf[:rapidminer_executable]
  pbs_job.log_directory = conf[:remote_log_directory]
  pbs_job.mail_address = conf[:mail_address]
  pbs_job.walltime = "05:50:00"
  pbs_job.memory = "4096"
  pbs_job.cores = 1

  # create job files:
  job_creator = JobFileCreator.new conf[:remote_process_path], conf[:jobfile_creation_path], variation, pbs_job

  return job_creator
end

def job_creator_weka_rf conf, namespace
  base_process = "#{conf[:local_base_repository]}/struktur/prozesse/model_creation/weka-rf.rmp"


  # create process:
  process = RMProcess.new base_process

  # create variation and variation values:
  variation = Variation.new process, conf[:repository], conf[:file_separator]
  variation.namespace = namespace
  vo = variation.variation_objects

  tree_counts = [20,40,60,80,100]
  v = ParameterValues.new "W-RandomForest", "I", tree_counts
  vo.push v

#  depths = [0,10]
  depths = [0]
  v = ParameterValues.new "W-RandomForest", "depth", depths
  vo.push v



  # init job:
  pbs_job = PBSJob.new
  pbs_job.rm_executable = conf[:rapidminer_executable]
  pbs_job.log_directory = conf[:remote_log_directory]
  pbs_job.mail_address = conf[:mail_address]
  pbs_job.walltime = "05:50:00"
  pbs_job.memory = "4096"
  pbs_job.cores = 1

  # create job files:
  job_creator = JobFileCreator.new conf[:remote_process_path], conf[:jobfile_creation_path], variation, pbs_job

  return job_creator
end

# a model creation process for the modified, sql-based bbc classifier
def job_creator_bbc_sql conf, namespace
#  puts "job_creator_bbc_sql"
  base_process = "#{conf[:local_base_repository]}/struktur/prozesse/model_creation/bbc_sql.rmp"

  sql_Zd_10_40 = job_creator_sql_Zd_10_40_maxHeight_greater0(conf, namespace)
  sql_no_Zd_limit = job_creator_sql_no_Zd_limit_maxHeight_greater0(conf, namespace)

  # create process:
  process = RMProcess.new base_process

  # create variation and variation values:
  variation = Variation.new process, conf[:repository], conf[:file_separator]
  variation.namespace = namespace

  vo = variation.variation_objects

  iteration_counts = [200]
  v = ParameterValues.new "Bayesian Boosting SQL", "iterations", iteration_counts
  vo.push v

#  resample_intervals = [1,2,3,4,5,6,7,8,9,10,12,15,20]
  resample_intervals = [15,20]
  v = ParameterValues.new "Bayesian Boosting SQL", "new_sample_interval", resample_intervals
  v.base_variations = [
    sql_Zd_10_40.variation,
    sql_no_Zd_limit.variation,
  ]

  vo.push v

  repo = {:name => "Diplomarbeit"}
  inner_learners = [
    "//#{repo[:name]}/struktur/prozesse/model_creation/j48",
    "//#{repo[:name]}/struktur/prozesse/model_creation/weka-ds",
    #"//#{repo[:name]}/struktur/prozesse/model_creation/rm-ds" # mit dem RapidMiner Decision Stump kackt der Prozess voll ab und liefert keine sinnvollen Ergebnisse
  ]
  inner_learners = array_add_stripped_filenames inner_learners, "//#{repo[:name]}/"
  v = ParameterValues.new "Inner Learner", "process_location", inner_learners
  vo.push v


  example_readers = Array.new
#  example_readers  += sql_Zd_10_40.variation.filenames :repository_name, false
  example_readers += sql_no_Zd_limit.variation.filenames :repository_name, false
  v = ParameterValues.new "Read Examples", "process_location", array_add_stripped_filenames(example_readers, "//#{conf[:repository][:name]}/")
  vo.push v


  # init job:
  pbs_job = PBSJob.new
  pbs_job.rm_executable = conf[:rapidminer_executable]
  pbs_job.log_directory = conf[:remote_log_directory]
  pbs_job.mail_address = conf[:mail_address]
  pbs_job.walltime = "05:59:00"
  pbs_job.memory = "4096"
  pbs_job.cores = 1

  # create job files:
  job_creator = JobFileCreator.new conf[:remote_process_path], conf[:jobfile_creation_path], variation, pbs_job

  return job_creator
end


def job_creator_stdxval_with_bbc conf, namespace
  base_process = "#{conf[:local_base_repository]}/struktur/prozesse/std_xval.rmp"


  # create process:
  process = RMProcess.new base_process

  # create variation and variation values:
  variation = Variation.new process, conf[:repository], conf[:file_separator]
  variation.namespace = namespace

  vo = variation.variation_objects

  example_readers = job_creator_sql_Zd_10_40_maxHeight_greater0(conf, namespace).variation.filenames :repository_name, false
  v = ParameterValues.new "Read Examples", "process_location", array_add_stripped_filenames(example_readers, "//#{conf[:repository][:name]}/")
  v.base_variations = [
    job_creator_sql_Zd_10_40_maxHeight_greater0(conf, namespace).variation,
  ]
  vo.push v

  learners = job_creator_bbc(conf, namespace).variation.filenames :repository_name, false
#  learners = array_add_stripped_filenames learners
  v = ParameterValues.new "Train Model", "process_location", array_add_stripped_filenames(learners, "//#{conf[:repository][:name]}/")
  v.base_variations = [
    job_creator_bbc(conf, namespace).variation,
  ]

  vo.push v

  v = DynamicParameterValues.new "Log Location", "value", [lambda{|counter| "rm_logs/#{variation.filename_for_counter counter, :none}"}]
  vo.push v

  # init job:
  pbs_job = PBSJob.new
  pbs_job.rm_executable = conf[:rapidminer_executable]
  pbs_job.log_directory = conf[:remote_log_directory]
  pbs_job.mail_address = conf[:mail_address]
  pbs_job.walltime = "01:30:00"
  pbs_job.memory = "2024"
  pbs_job.cores = 1

  # create job files:
  job_creator = JobFileCreator.new conf[:remote_process_path], conf[:jobfile_creation_path], variation, pbs_job

  return job_creator
end

def job_creator_bbcxval conf, namespace
  base_process = "#{conf[:local_base_repository]}/struktur/prozesse/bbc_xval.rmp"


  sql_Zd_10_40 = job_creator_sql_Zd_10_40_maxHeight_greater0 conf, namespace
#  sql_no_Zd_limit = job_creator_sql_no_Zd_limit_maxHeight_greater0(conf, namespace)
#  bbc_creator = job_creator_bbc(conf, namespace)
  bbc_fuzzy_creator = job_creator_bbc_fuzzy(conf, namespace)
  rm_adaboost_creator = job_creator_rm_adaboost(conf, namespace)


  # create process:
  process = RMProcess.new base_process

  # create variation and variation values:
  variation = Variation.new process, conf[:repository], conf[:file_separator]
  variation.namespace = namespace

  vo = variation.variation_objects

  example_readers = Array.new
  example_readers  += sql_Zd_10_40.variation.filenames :repository_name, false
#  example_readers += sql_no_Zd_limit.variation.filenames :repository_name, false
  v = ParameterValues.new "Read Examples", "process_location", array_add_stripped_filenames(example_readers, "//#{conf[:repository][:name]}/")
  v.base_variations = [
    sql_Zd_10_40.variation,
#    sql_no_Zd_limit.variation,
  ]

  vo.push v

  learners = Array.new
#  learners += bbc_creator.variation.filenames :repository_name, false
  learners += bbc_fuzzy_creator.variation.filenames :repository_name, false
#  learners += rm_adaboost_creator.variation.filenames :repository_name, false
  v = ParameterValues.new "Train Model", "process_location", array_add_stripped_filenames(learners, "//#{conf[:repository][:name]}/")
  v.base_variations = [
#    bbc_creator.variation,
    bbc_fuzzy_creator.variation,
    rm_adaboost_creator.variation,
  ]

  vo.push v

  #v = DynamicParameterValues.new "Log Location", "value", [lambda{|counter| "rm_logs/#{variation.filename_for_counter counter, :none}"}]
  #vo.push v

  # init job:
  pbs_job = PBSJob.new
  pbs_job.rm_executable = conf[:rapidminer_executable]
  pbs_job.log_directory = conf[:remote_log_directory]
  pbs_job.mail_address = conf[:mail_address]
  pbs_job.walltime = "5:55:00"
  pbs_job.memory = "4096"
  pbs_job.cores = 1

  # create job files:
  job_creator = JobFileCreator.new conf[:remote_process_path], conf[:jobfile_creation_path], variation, pbs_job

  return job_creator
end

def job_creator_bbcxval_sql conf, namespace
#  puts "job_creator_bbcxval_sql"
  base_process = "#{conf[:local_base_repository]}/struktur/prozesse/bbc_sql_xval.rmp"


  # create process:
  process = RMProcess.new base_process

  # create variation and variation values:
  variation = Variation.new process, conf[:repository], conf[:file_separator]
  variation.namespace = namespace

  vo = variation.variation_objects


  sql_Zd_10_40 = job_creator_sql_Zd_10_40_maxHeight_greater0_for_bbc_sql(conf, namespace)
  sql_no_Zd_limit = job_creator_sql_no_Zd_limit_maxHeight_greater0_for_bbc_sql(conf, namespace)

  # create process:
  process = RMProcess.new base_process

  # create variation and variation values:
  variation = Variation.new process, conf[:repository], conf[:file_separator]
  variation.namespace = namespace

  vo = variation.variation_objects

  iteration_counts = [200]
  v = ParameterValues.new "Bayesian Boosting SQL", "iterations", iteration_counts
  vo.push v

#  resample_intervals = [1,2,3,4,5,6,7,8,9,10,12,15,20]
#  resample_intervals = [1,2,3,4,5,7,10]
  resample_intervals = [5,1,2,3,4,10]
  resample_intervals += [6,7,8,9,15,20]
  v = ParameterValues.new "Bayesian Boosting SQL", "new_sample_interval", resample_intervals
  vo.push v


  repo = {:name => "Diplomarbeit"}
  inner_learners = [
    "//#{repo[:name]}/struktur/prozesse/model_creation/j48",
    "//#{repo[:name]}/struktur/prozesse/model_creation/weka-ds",
    #"//#{repo[:name]}/struktur/prozesse/model_creation/rm-ds" # mit dem RapidMiner Decision Stump kackt der Prozess voll ab und liefert keine sinnvollen Ergebnisse
  ]
  inner_learners = array_add_stripped_filenames inner_learners, "//#{repo[:name]}/"
  v = ParameterValues.new "Inner Learner", "process_location", inner_learners
  vo.push v


  example_readers = Array.new
  training_set_readers = Array.new
  example_readers  += sql_Zd_10_40.variation.filenames :repository_name, false
  training_set_readers += Array.new example_readers.size - training_set_readers.size, '[mo]_Zd_10_40_4000.'
#  example_readers += sql_no_Zd_limit.variation.filenames :repository_name, false
#  training_set_readers += Array.new example_readers.size - training_set_readers.size, '[mo]_no_Zd_limit_100000_wr'

  v1 = ParameterValues.new "Read Examples", "process_location", array_add_stripped_filenames(example_readers, "//#{conf[:repository][:name]}/")
  v1.base_variations = [
    sql_Zd_10_40.variation,
    sql_no_Zd_limit.variation,
  ]
  v2 = ParameterValues.new "Sampling Properties", "event_set_name", training_set_readers, "list"
  v = SynchronizedParameterValues.new [v1,v2]
  vo.push v

  # init job:
  pbs_job = PBSJob.new
  pbs_job.rm_executable = conf[:rapidminer_executable]
  pbs_job.log_directory = conf[:remote_log_directory]
  pbs_job.mail_address = conf[:mail_address]
  pbs_job.walltime = "23:55:00"
  pbs_job.memory = "4096"
  pbs_job.cores = 4

  # create job files:
  job_creator = JobFileCreator.new conf[:remote_process_path], conf[:jobfile_creation_path], variation, pbs_job

  return job_creator
end

def job_creator_bbcxval_sql_fuzzy conf, namespace
#  puts "job_creator_bbcxval_sql"
  base_process = "#{conf[:local_base_repository]}/struktur/prozesse/bbc_sql_xval.rmp"


  # create process:
  process = RMProcess.new base_process

  # create variation and variation values:
  variation = Variation.new process, conf[:repository], conf[:file_separator]
  variation.namespace = namespace

  vo = variation.variation_objects


  sql_Zd_10_40 = job_creator_sql_Zd_10_40_maxHeight_greater0_for_bbc_sql conf, namespace, [1000, 5000, 10000, 15000]
#  sql_no_Zd_limit = job_creator_sql_no_Zd_limit_maxHeight_greater0_for_bbc_sql(conf, namespace)

  # create process:
  process = RMProcess.new base_process

  # create variation and variation values:
  variation = Variation.new process, conf[:repository], conf[:file_separator]
  variation.namespace = namespace

  vo = variation.variation_objects

  iteration_counts = [200]
  v = ParameterValues.new "Bayesian Boosting SQL", "iterations", iteration_counts
  vo.push v

#  resample_intervals = [1,2,3,4,5,6,7,8,9,10,12,15,20]
#  resample_intervals = [1,2,3,4,5,7,10]
#  resample_intervals = [5,1,2,3,4,10]
#  resample_intervals += [6,7,8,9,15,20]
  resample_intervals = [1,3,5,10,20]
  v = ParameterValues.new "Bayesian Boosting SQL", "new_sample_interval", resample_intervals
  vo.push v


  v = ParameterValues.new "Bayesian Boosting SQL", "fuzzy_reweighting", [true,false]
  vo.push v

  v = ParameterValues.new "Bayesian Boosting SQL", "fuzzy_partition_sizes", [false,true]
  vo.push v

  repo = {:name => "Diplomarbeit"}
  inner_learners = [
    "//#{repo[:name]}/struktur/prozesse/model_creation/j48",
    "//#{repo[:name]}/struktur/prozesse/model_creation/weka-ds",
    #"//#{repo[:name]}/struktur/prozesse/model_creation/rm-ds" # mit dem RapidMiner Decision Stump kackt der Prozess voll ab und liefert keine sinnvollen Ergebnisse
  ]
  inner_learners = array_add_stripped_filenames inner_learners, "//#{repo[:name]}/"
  v = ParameterValues.new "Inner Learner", "process_location", inner_learners
  vo.push v


  example_readers = Array.new
  training_set_readers = Array.new
  example_readers  += sql_Zd_10_40.variation.filenames :repository_name, false
  training_set_readers += Array.new example_readers.size - training_set_readers.size, '[mo]_Zd_10_40_4000.'
#  example_readers += sql_no_Zd_limit.variation.filenames :repository_name, false
#  training_set_readers += Array.new example_readers.size - training_set_readers.size, '[mo]_no_Zd_limit_100000_wr'

  v1 = ParameterValues.new "Read Examples", "process_location", array_add_stripped_filenames(example_readers, "//#{conf[:repository][:name]}/")
  v1.base_variations = [
    sql_Zd_10_40.variation,
#    sql_no_Zd_limit.variation,
  ]
  v2 = ParameterValues.new "Sampling Properties", "event_set_name", training_set_readers, "list"
  v = SynchronizedParameterValues.new [v1,v2]
  vo.push v

  # init job:
  pbs_job = PBSJob.new
  pbs_job.rm_executable = conf[:rapidminer_executable]
  pbs_job.log_directory = conf[:remote_log_directory]
  pbs_job.mail_address = conf[:mail_address]
  pbs_job.walltime = "23:55:00"
  pbs_job.memory = "4096"
  pbs_job.cores = 1

  # create job files:
  job_creator = JobFileCreator.new conf[:remote_process_path], conf[:jobfile_creation_path], variation, pbs_job

  return job_creator
end

def job_creator_bbcxval_sql_fuzzy_svm conf, namespace
#  puts "job_creator_bbcxval_sql"
  base_process = "#{conf[:local_base_repository]}/struktur/prozesse/bbc_sql_xval.rmp"


  # create process:
  process = RMProcess.new base_process

  # create variation and variation values:
  variation = Variation.new process, conf[:repository], conf[:file_separator]
  variation.namespace = namespace

  vo = variation.variation_objects


  sql_Zd_10_40 = job_creator_sql_Zd_10_40_maxHeight_greater0_for_bbc_sql(conf, namespace, [100,200,500,1000])
#  sql_no_Zd_limit = job_creator_sql_no_Zd_limit_maxHeight_greater0_for_bbc_sql(conf, namespace)

  # create process:
  process = RMProcess.new base_process

  # create variation and variation values:
  variation = Variation.new process, conf[:repository], conf[:file_separator]
  variation.namespace = namespace

  vo = variation.variation_objects

  iteration_counts = [200]
  v = ParameterValues.new "Bayesian Boosting SQL", "iterations", iteration_counts
  vo.push v

#  resample_intervals = [1,2,3,4,5,6,7,8,9,10,12,15,20]
#  resample_intervals = [1,2,3,4,5,7,10]
#  resample_intervals = [5,1,2,3,4,10]
#  resample_intervals += [6,7,8,9,15,20]
  resample_intervals = [1,2,3,5,10]
  v = ParameterValues.new "Bayesian Boosting SQL", "new_sample_interval", resample_intervals
  vo.push v


  v = ParameterValues.new "Bayesian Boosting SQL", "fuzzy_reweighting", [true,false]
  vo.push v

  v = ParameterValues.new "Bayesian Boosting SQL", "fuzzy_partition_sizes", [false, true]
  vo.push v

  repo = {:name => "Diplomarbeit"}
  inner_learners = [
    "//#{repo[:name]}/struktur/prozesse/model_creation/libsvm",
  ]
  inner_learners = array_add_stripped_filenames inner_learners, "//#{repo[:name]}/"
  v = ParameterValues.new "Inner Learner", "process_location", inner_learners
  vo.push v


  example_readers = Array.new
  training_set_readers = Array.new
  example_readers  += sql_Zd_10_40.variation.filenames :repository_name, false
  training_set_readers += Array.new example_readers.size - training_set_readers.size, '[mo]_Zd_10_40_4000.'
#  example_readers += sql_no_Zd_limit.variation.filenames :repository_name, false
#  training_set_readers += Array.new example_readers.size - training_set_readers.size, '[mo]_no_Zd_limit_100000_wr'

  v1 = ParameterValues.new "Read Examples", "process_location", array_add_stripped_filenames(example_readers, "//#{conf[:repository][:name]}/")
  v1.base_variations = [
    sql_Zd_10_40.variation,
#    sql_no_Zd_limit.variation,
  ]
  v2 = ParameterValues.new "Sampling Properties", "event_set_name", training_set_readers, "list"
  v = SynchronizedParameterValues.new [v1,v2]
  vo.push v

  # init job:
  pbs_job = PBSJob.new
  pbs_job.rm_executable = conf[:rapidminer_executable]
  pbs_job.log_directory = conf[:remote_log_directory]
  pbs_job.mail_address = conf[:mail_address]
  pbs_job.walltime = "23:55:00"
  pbs_job.memory = "6000"
  pbs_job.cores = 2

  # create job files:
  job_creator = JobFileCreator.new conf[:remote_process_path], conf[:jobfile_creation_path], variation, pbs_job

  return job_creator
end

def job_creator_stdxval_with_binning conf, namespace
  base_process = "#{conf[:local_base_repository]}/struktur/prozesse/std_xval.rmp"


  # create process:
  process = RMProcess.new base_process

  # create variation and variation values:
  variation = Variation.new process, conf[:repository], conf[:file_separator]
  variation.namespace = namespace

  vo = variation.variation_objects

  example_readers = Array.new
  example_readers += job_creator_linear_binned_data(conf, namespace).variation.filenames :repository_name, false
  v = ParameterValues.new "Read Examples", "process_location", array_add_stripped_filenames(example_readers, "//#{conf[:repository][:name]}/")
  v.base_variations = [
    job_creator_linear_binned_data(conf, namespace).variation,
  ]
  vo.push v

  learners = job_creator_combined_model(conf, namespace).variation.filenames :repository_name, false
  v = ParameterValues.new "Train Model", "process_location", array_add_stripped_filenames(learners, "//#{conf[:repository][:name]}/")
  v.base_variations = [
    job_creator_combined_model(conf, namespace).variation,
  ]
  vo.push v

  # init job:
  pbs_job = PBSJob.new
  pbs_job.rm_executable = conf[:rapidminer_executable]
  pbs_job.log_directory = conf[:remote_log_directory]
  pbs_job.mail_address = conf[:mail_address]
  pbs_job.walltime = "05:55:00"
  pbs_job.memory = "6144"
  pbs_job.cores = 1

  # create job files:
  job_creator = JobFileCreator.new conf[:remote_process_path], conf[:jobfile_creation_path], variation, pbs_job

  return job_creator
end



def job_creator_binning_eval conf, log_dir, binning_selectors, namespace, result_directory
  # create process:
  process = RMProcess.new "#{conf[:local_base_repository]}/struktur/prozesse/binning/evaluate_binning.rmp"

  # create variation and variation values:
  variation = Variation.new process, conf[:repository], conf[:file_separator]
  variation.namespace = namespace

  vo = variation.variation_objects

#  example_counts = [1000, 2000, 5000, 7500, 15000, 30000, 45000, 60000, 105000]
  example_counts = [30000, 45000, 75000, 105000]
  sql_Zd_10_40 = job_creator_sql_Zd_10_40_maxHeight_greater0 conf, namespace, example_counts


  repo = {:name => "Diplomarbeit"}
  inner_learners = {}
  inner_learners[:j48]     = ["//#{repo[:name]}/struktur/prozesse/model_creation/j48"]
  inner_learners[:weka_ds] = ["//#{repo[:name]}/struktur/prozesse/model_creation/weka-ds"]
  bbc_fuzzy_j48_creator     = job_creator_bbc_fuzzy conf, namespace, [25], inner_learners[:j48], [false], [true]
  bbc_fuzzy_weka_ds_creator = job_creator_bbc_fuzzy conf, namespace, [200], inner_learners[:weka_ds], [false], [false]


  learners = Array.new
#  learners += bbc_creator.variation.filenames :repository_name, false
  learners += bbc_fuzzy_j48_creator.variation.filenames :repository_name, false
  learners += bbc_fuzzy_weka_ds_creator.variation.filenames :repository_name, false
#  learners += rm_adaboost_creator.variation.filenames :repository_name, false
  v = ParameterValues.new "Train Inner Learner", "process_location", array_add_stripped_filenames(learners, "//#{conf[:repository][:name]}/")
  v.base_variations = [
#    bbc_creator.variation,
    bbc_fuzzy_j48_creator.variation,
    bbc_fuzzy_weka_ds_creator.variation,
#    rm_adaboost_creator.variation,
  ]
  vo.push v

  cluster_roles = Array.new ["cos2Zd"]
  v = ParameterValues.new "Set Cluster Role", "name", cluster_roles
  vo.push v

  example_readers = Array.new
  example_readers  += sql_Zd_10_40.variation.filenames :repository_name, false
#  example_readers += sql_no_Zd_limit.variation.filenames :repository_name, false
  v = ParameterValues.new "Read Examples", "process_location", array_add_stripped_filenames(example_readers, "//#{conf[:repository][:name]}/")
  v.base_variations = [
    sql_Zd_10_40.variation,
#    sql_no_Zd_limit.variation,
  ]
  vo.push v


  limits_locations = []
  binning_selectors.each do |bs|
    e = bs.find_errors log_dir
    e.each_pair do |k,v|
      if v == :success
#        PP.pp(k)
#        system("cat #{result_directory}/generated_processes/#{k}/limits.log")
        limits_locations.push"#{result_directory}/generated_processes/#{k}/limits.arff"
      end
    end
  end
  v = ParameterValues.new "Read Limits", "data_file", limits_locations
  vo.push v

  # init job:
  pbs_job = PBSJob.new
  pbs_job.rm_executable = conf[:rapidminer_executable]
  pbs_job.log_directory = conf[:remote_log_directory]
  pbs_job.mail_address = conf[:mail_address]
  pbs_job.walltime = "5:55:00"
  pbs_job.memory = "8000"
  pbs_job.cores = 1

  # create job files:
  job_creator = JobFileCreator.new conf[:remote_process_path], conf[:jobfile_creation_path], variation, pbs_job

  return job_creator
end


def job_creator_fw_bw_binning_selection conf, base_process, namespace

  # create process:
  process = RMProcess.new base_process

  # create variation and variation values:
  variation = Variation.new process, conf[:repository], conf[:file_separator]
  variation.namespace = namespace

  vo = variation.variation_objects

  example_readers = Array.new
  example_readers += job_creator_linear_binned_data_for_fs(conf, namespace).variation.filenames :repository_name, false
  v = ParameterValues.new "Read Examples", "process_location", array_add_stripped_filenames(example_readers, "//#{conf[:repository][:name]}/")
  v.base_variations = [
    job_creator_linear_binned_data_for_fs(conf, namespace).variation,
  ]
  vo.push v

  learners = job_creator_combined_model_for_fs(conf, namespace).variation.filenames :repository_name, false
  v = ParameterValues.new "Train Model", "process_location", array_add_stripped_filenames(learners, "//#{conf[:repository][:name]}/")
  v.base_variations = [
    job_creator_combined_model_for_fs(conf, namespace).variation,
  ]
  vo.push v

  # init job:
  pbs_job = PBSJob.new
  pbs_job.rm_executable = conf[:rapidminer_executable]
  pbs_job.log_directory = conf[:remote_log_directory]
  pbs_job.mail_address = conf[:mail_address]
  pbs_job.walltime = "23:55:00"
  pbs_job.memory = "14000"
#  pbs_job.walltime = "5:55:00"
#  pbs_job.memory = "6000"
  pbs_job.cores = 1

  # create job files:
  job_creator = JobFileCreator.new conf[:remote_process_path], conf[:jobfile_creation_path], variation, pbs_job

  return job_creator
end


def job_creator_evo_binning_selection conf, namespace
  base_process = "#{conf[:local_base_repository]}/struktur/prozesse/binning/evo_feature_selection.rmp"
  job_creator_fw_bw_binning_selection(conf, base_process, namespace)
end

def job_creator_forward_binning_selection conf, namespace
  base_process = "#{conf[:local_base_repository]}/struktur/prozesse/binning/fw_feature_selection.rmp"
  job_creator_fw_bw_binning_selection(conf, base_process, namespace)
end

def job_creator_backward_binning_selection conf, namespace
  base_process = "#{conf[:local_base_repository]}/struktur/prozesse/binning/bw_feature_selection.rmp"
  job_creator_fw_bw_binning_selection(conf, base_process, namespace)
end





def job_creator_stdxval_with_weka_rf conf, namespace
  base_process = "#{conf[:local_base_repository]}/struktur/prozesse/std_xval.rmp"

  


  # create process:
  process = RMProcess.new base_process

  # create variation and variation values:
  variation = Variation.new process, conf[:repository], conf[:file_separator]
  variation.namespace = namespace

  vo = variation.variation_objects

  ex_counts =  [1000,5000,15000,60000,105000]
  example_readers = Array.new
  example_readers += job_creator_sql_Zd_10_40_maxHeight_greater0(conf, namespace, ex_counts).variation.filenames :repository_name, false
#  example_readers += job_creator_sql_no_Zd_limit_maxHeight_greater0(conf, namespace).variation.filenames :repository_name, false
  v = ParameterValues.new "Read Examples", "process_location", array_add_stripped_filenames(example_readers, "//#{conf[:repository][:name]}/")
  v.base_variations = [
    job_creator_sql_Zd_10_40_maxHeight_greater0(conf, namespace, ex_counts).variation,
#    job_creator_sql_no_Zd_limit_maxHeight_greater0(conf, namespace).variation,
  ]
  vo.push v

  learners = job_creator_weka_rf(conf, namespace).variation.filenames :repository_name, false
  v = ParameterValues.new "Train Model", "process_location", array_add_stripped_filenames(learners, "//#{conf[:repository][:name]}/")
  v.base_variations = [
    job_creator_weka_rf(conf, namespace).variation,
  ]
  vo.push v

  # init job:
  pbs_job = PBSJob.new
  pbs_job.rm_executable = conf[:rapidminer_executable]
  pbs_job.log_directory = conf[:remote_log_directory]
  pbs_job.mail_address = conf[:mail_address]
  pbs_job.walltime = "05:55:00"
  pbs_job.memory = "6144"
  pbs_job.cores = 1

  # create job files:
  job_creator = JobFileCreator.new conf[:remote_process_path], conf[:jobfile_creation_path], variation, pbs_job

  return job_creator
end


def job_creator_combined_model conf, namespace
  base_process = "#{conf[:local_base_repository]}/struktur/prozesse/model_creation/combined_model.rmp"

  # create process:
  process = RMProcess.new base_process

  # create variation and variation values:
  variation = Variation.new process, conf[:repository], conf[:file_separator]
  variation.namespace = namespace

  vo = variation.variation_objects

  repo = {:name => "Diplomarbeit"}
  inner_learners = [
    ["//#{repo[:name]}/struktur/prozesse/model_creation/j48", "j48"],
    ["//#{repo[:name]}/struktur/prozesse/model_creation/naive-bayes", "naive-bayes"]
  ]
  inner_learners += job_creator_bbc_for_binning(conf, namespace).variation.filenames(:repository_name, false)
  inner_learners = array_add_stripped_filenames inner_learners, "//#{conf[:repository][:name]}/"
  v = ParameterValues.new "Train Inner Learner", "process_location", inner_learners
  v.base_variations = [
    job_creator_bbc_for_binning(conf, namespace).variation
  ]
  vo.push v

  # init job:
  pbs_job = PBSJob.new
  pbs_job.rm_executable = conf[:rapidminer_executable]
  pbs_job.log_directory = conf[:remote_log_directory]
  pbs_job.mail_address = conf[:mail_address]
  pbs_job.walltime = "23:55:00"
  pbs_job.memory = "6144"
  pbs_job.cores = 1

  # create job files:
  job_creator = JobFileCreator.new conf[:remote_process_path], conf[:jobfile_creation_path], variation, pbs_job

  return job_creator
end




def job_creator_combined_model_for_fs conf, namespace
  base_process = "#{conf[:local_base_repository]}/struktur/prozesse/model_creation/combined_model.rmp"

  # create process:
  process = RMProcess.new base_process

  # create variation and variation values:
  variation = Variation.new process, conf[:repository], conf[:file_separator]
  variation.namespace = namespace

  vo = variation.variation_objects

  repo = {:name => "Diplomarbeit"}
  inner_learners = []
  inner_learners += [
    ["//#{repo[:name]}/struktur/prozesse/model_creation/j48", "j48"],
    ["//#{repo[:name]}/struktur/prozesse/model_creation/naive-bayes", "naive-bayes"],
  ]
#  inner_learners += job_creator_bbc_for_binning_fs(conf, namespace).variation.filenames(:repository_name, false)
#  inner_learners = array_add_stripped_filenames inner_learners, "//#{conf[:repository][:name]}/"
  v = ParameterValues.new "Train Inner Learner", "process_location", inner_learners
  v.base_variations = [
    job_creator_bbc_for_binning_fs(conf, namespace).variation
  ]
  vo.push v

  # init job:
  pbs_job = PBSJob.new
  pbs_job.rm_executable = conf[:rapidminer_executable]
  pbs_job.log_directory = conf[:remote_log_directory]
  pbs_job.mail_address = conf[:mail_address]
  pbs_job.walltime = "23:55:00"
  pbs_job.memory = "6144"
  pbs_job.cores = 1

  # create job files:
  job_creator = JobFileCreator.new conf[:remote_process_path], conf[:jobfile_creation_path], variation, pbs_job

  return job_creator
end
